/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.postgresql;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.i18n.Resources;
import com.aoapps.lang.io.FastExternalizable;
import com.aoapps.lang.validation.InvalidResult;
import com.aoapps.lang.validation.ValidResult;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.lang.validation.ValidationResult;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Disablable;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.DisableLog;
import com.aoindustries.aoserv.client.dto.PostgresUserName;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.password.PasswordChecker;
import com.aoindustries.aoserv.client.password.PasswordProtected;
import com.aoindustries.aoserv.client.postgresql.CachedObjectUserNameKey;
import com.aoindustries.aoserv.client.postgresql.Server;
import com.aoindustries.aoserv.client.postgresql.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class User
extends CachedObjectUserNameKey<User>
implements Removable,
PasswordProtected,
Disablable {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, User.class);
    static final int COLUMN_USERNAME = 0;
    static final String COLUMN_USERNAME_name = "username";
    @Deprecated
    public static final int MAX_USERNAME_LENGTH = 31;
    public static final Name POSTGRES;
    public static final Name PG_MONITOR;
    public static final Name PG_READ_ALL_SETTINGS;
    public static final Name PG_READ_ALL_STATS;
    public static final Name PG_SIGNAL_BACKEND;
    public static final Name PG_STAT_SCAN_TABLES;
    public static final Name PG_EXECUTE_SERVER_PROGRAM;
    public static final Name PG_READ_SERVER_FILES;
    public static final Name PG_WRITE_SERVER_FILES;
    public static final Name PG_READ_ALL_DATA;
    public static final Name PG_WRITE_ALL_DATA;
    public static final Name PG_DATABASE_OWNER;
    public static final Name PG_CHECKPOINT;
    public static final Name POSTGRESMON;
    public static final Name AOADMIN;
    public static final Name AOSERV_APP;
    public static final Name AOWEB_APP;
    public static final String NO_PASSWORD;
    public static final String NO_PASSWORD_DB_VALUE = "";
    private boolean createdb;
    private boolean trace;
    private boolean superPriv;
    private boolean catupd;
    private int disableLog;

    public static boolean isSpecial(Name username) {
        return username.equals(POSTGRES) || username.equals(PG_MONITOR) || username.equals(PG_READ_ALL_SETTINGS) || username.equals(PG_READ_ALL_STATS) || username.equals(PG_SIGNAL_BACKEND) || username.equals(PG_STAT_SCAN_TABLES) || username.equals(PG_EXECUTE_SERVER_PROGRAM) || username.equals(PG_READ_SERVER_FILES) || username.equals(PG_WRITE_SERVER_FILES) || username.equals(PG_READ_ALL_DATA) || username.equals(PG_WRITE_ALL_DATA) || username.equals(PG_DATABASE_OWNER) || username.equals(PG_CHECKPOINT) || username.equals(POSTGRESMON) || username.equals(AOADMIN) || username.equals(AOSERV_APP) || username.equals(AOWEB_APP);
    }

    @Deprecated
    public User() {
    }

    public int addPostgresServerUser(Server postgresServer) throws IOException, SQLException {
        return this.table.getConnector().getPostgresql().getUserServer().addPostgresServerUser(this.pkey, postgresServer);
    }

    @Override
    public int arePasswordsSet() throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("Refusing to check if passwords set on special PostgreSQL user: " + this);
        }
        return com.aoindustries.aoserv.client.account.User.groupPasswordsSet(this.getPostgresServerUsers());
    }

    public boolean canCatupd() {
        return this.catupd;
    }

    public boolean canCreatedb() {
        return this.createdb;
    }

    @Override
    public boolean canDisable() throws IOException, SQLException {
        if (this.isDisabled() || this.isSpecial()) {
            return false;
        }
        for (UserServer psu : this.getPostgresServerUsers()) {
            if (psu.isDisabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canEnable() throws SQLException, IOException {
        if (this.isSpecial()) {
            return false;
        }
        DisableLog dl = this.getDisableLog();
        if (dl == null) {
            return false;
        }
        return dl.canEnable() && !this.getUsername().isDisabled();
    }

    public boolean canTrace() {
        return this.trace;
    }

    @Override
    public List<PasswordChecker.Result> checkPassword(String password) throws IOException {
        return User.checkPassword(this.pkey, password);
    }

    public static List<PasswordChecker.Result> checkPassword(Name username, String password) throws IOException {
        return PasswordChecker.checkPassword(username, password, PasswordChecker.PasswordStrength.STRICT);
    }

    @Override
    public void disable(DisableLog dl) throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("Refusing to disable special PostgreSQL user: " + this);
        }
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.DISABLE, new Object[]{Table.TableId.POSTGRES_USERS, dl.getPkey(), this.pkey});
    }

    @Override
    public void enable() throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("Refusing to enable special PostgreSQL user: " + this);
        }
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.ENABLE, new Object[]{Table.TableId.POSTGRES_USERS, this.pkey});
    }

    @Override
    protected Object getColumnImpl(int i) {
        if (i == 0) {
            return this.pkey;
        }
        if (i == 1) {
            return this.createdb;
        }
        if (i == 2) {
            return this.trace;
        }
        if (i == 3) {
            return this.superPriv;
        }
        if (i == 4) {
            return this.catupd;
        }
        if (i == 5) {
            return this.getDisableLog_id();
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public boolean isDisabled() {
        return this.disableLog != -1;
    }

    public Integer getDisableLog_id() {
        return this.disableLog == -1 ? null : Integer.valueOf(this.disableLog);
    }

    @Override
    public DisableLog getDisableLog() throws SQLException, IOException {
        if (this.disableLog == -1) {
            return null;
        }
        DisableLog obj = this.table.getConnector().getAccount().getDisableLog().get(this.disableLog);
        if (obj == null) {
            throw new SQLException("Unable to find DisableLog: " + this.disableLog);
        }
        return obj;
    }

    public UserServer getPostgresServerUser(Server server) throws IOException, SQLException {
        return server.getPostgresServerUser(this.pkey);
    }

    public List<UserServer> getPostgresServerUsers() throws IOException, SQLException {
        return this.table.getConnector().getPostgresql().getUserServer().getPostgresServerUsers(this);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.POSTGRES_USERS;
    }

    public Name getUsername_username_id() {
        return this.pkey;
    }

    public com.aoindustries.aoserv.client.account.User getUsername() throws SQLException, IOException {
        com.aoindustries.aoserv.client.account.User username = this.table.getConnector().getAccount().getUser().get(this.pkey);
        if (username == null) {
            throw new SQLException("Unable to find Username: " + this.pkey);
        }
        return username;
    }

    public boolean isSpecial() {
        return User.isSpecial(this.pkey);
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = Name.valueOf(result.getString(1));
            this.createdb = result.getBoolean(2);
            this.trace = result.getBoolean(3);
            this.superPriv = result.getBoolean(4);
            this.catupd = result.getBoolean(5);
            this.disableLog = result.getInt(6);
            if (result.wasNull()) {
                this.disableLog = -1;
            }
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    public boolean isDatabaseAdmin() {
        return this.superPriv;
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = Name.valueOf(in.readUTF()).intern();
            this.createdb = in.readBoolean();
            this.trace = in.readBoolean();
            this.superPriv = in.readBoolean();
            this.catupd = in.readBoolean();
            this.disableLog = in.readCompressedInt();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() throws SQLException, IOException {
        ArrayList reasons = new ArrayList();
        if (this.isSpecial()) {
            reasons.add(new CannotRemoveReason<User>("Not allowed to remove a special PostgreSQL user: " + this.pkey, this));
        }
        for (UserServer psu : this.getPostgresServerUsers()) {
            reasons.addAll(psu.getCannotRemoveReasons());
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("Refusing to remove special PostgreSQL user: " + this);
        }
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.POSTGRES_USERS, this.pkey});
    }

    @Override
    public void setPassword(String password) throws IOException, SQLException {
        for (UserServer user : this.getPostgresServerUsers()) {
            if (!user.canSetPassword()) continue;
            user.setPassword(password);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey.toString());
        out.writeBoolean(this.createdb);
        out.writeBoolean(this.trace);
        out.writeBoolean(this.superPriv);
        out.writeBoolean(this.catupd);
        out.writeCompressedInt(this.disableLog);
    }

    @Override
    public boolean canSetPassword() {
        return !this.isDisabled() && !this.isSpecial();
    }

    static {
        try {
            POSTGRES = Name.valueOf("postgres");
            PG_MONITOR = Name.valueOf("pg_monitor");
            PG_READ_ALL_SETTINGS = Name.valueOf("pg_read_all_settings");
            PG_READ_ALL_STATS = Name.valueOf("pg_read_all_stats");
            PG_SIGNAL_BACKEND = Name.valueOf("pg_signal_backend");
            PG_STAT_SCAN_TABLES = Name.valueOf("pg_stat_scan_tables");
            PG_EXECUTE_SERVER_PROGRAM = Name.valueOf("pg_execute_server_program");
            PG_READ_SERVER_FILES = Name.valueOf("pg_read_server_files");
            PG_WRITE_SERVER_FILES = Name.valueOf("pg_write_server_files");
            PG_READ_ALL_DATA = Name.valueOf("pg_read_all_data");
            PG_WRITE_ALL_DATA = Name.valueOf("pg_write_all_data");
            PG_DATABASE_OWNER = Name.valueOf("pg_database_owner");
            PG_CHECKPOINT = Name.valueOf("pg_checkpoint");
            POSTGRESMON = Name.valueOf("postgresmon");
            AOADMIN = Name.valueOf("aoadmin");
            AOSERV_APP = Name.valueOf("aoserv_app");
            AOWEB_APP = Name.valueOf("aoweb_app");
        }
        catch (ValidationException e) {
            throw new AssertionError("These hard-coded values are valid", e);
        }
        NO_PASSWORD = null;
    }

    public static final class Name
    extends User.Name
    implements FastExternalizable {
        public static final int POSTGRESQL_NAME_MAX_LENGTH = 31;
        private static final ConcurrentMap<String, Name> interned = new ConcurrentHashMap<String, Name>();
        private static final long serialVersionUID = 2L;

        public static ValidationResult validate(String id) {
            if (id == null) {
                return new InvalidResult(RESOURCES, "Name.validate.isNull");
            }
            int len = id.length();
            if (len == 0) {
                return new InvalidResult(RESOURCES, "Name.validate.isEmpty");
            }
            if (len > 31) {
                return new InvalidResult(RESOURCES, "Name.validate.tooLong", new Serializable[]{Integer.valueOf(31), Integer.valueOf(len)});
            }
            char ch = id.charAt(0);
            if (!(ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9')) {
                return new InvalidResult(RESOURCES, "Name.validate.startAtoZor0to9");
            }
            for (int c = 1; c < len; ++c) {
                ch = id.charAt(c);
                if (ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_') continue;
                return new InvalidResult(RESOURCES, "Name.validate.illegalCharacter");
            }
            assert (User.Name.validate(id).isValid()) : "A PostgreSQL User.Name is always a valid Linux User.Name.";
            return ValidResult.getInstance();
        }

        public static Name valueOf(String id) throws ValidationException {
            if (id == null) {
                return null;
            }
            return new Name(id, true);
        }

        private Name(String id, boolean validate) throws ValidationException {
            super(id, validate);
        }

        private Name(String id) {
            super(id);
        }

        @Override
        protected void validate() throws ValidationException {
            ValidationResult result = Name.validate(this.name);
            if (!result.isValid()) {
                throw new ValidationException(result);
            }
        }

        @Override
        public Name intern() {
            Name addMe;
            String internedId;
            Name existing = (Name)interned.get(this.name);
            if (existing == null && (existing = interned.putIfAbsent(internedId, addMe = this.name == (internedId = this.name.intern()) ? this : new Name(internedId))) == null) {
                existing = addMe;
            }
            return existing;
        }

        @Override
        public PostgresUserName getDto() {
            return new PostgresUserName(this.name);
        }

        @Deprecated
        public Name() {
        }

        @Override
        public long getSerialVersionUID() {
            return 2L;
        }
    }
}

