/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.postgresql;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Disablable;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.DisableLog;
import com.aoindustries.aoserv.client.password.PasswordChecker;
import com.aoindustries.aoserv.client.password.PasswordProtected;
import com.aoindustries.aoserv.client.postgresql.Database;
import com.aoindustries.aoserv.client.postgresql.Server;
import com.aoindustries.aoserv.client.postgresql.User;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class UserServer
extends CachedObjectIntegerKey<UserServer>
implements Removable,
PasswordProtected,
Disablable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_USERNAME = 1;
    static final int COLUMN_POSTGRES_SERVER = 2;
    static final String COLUMN_USERNAME_name = "username";
    static final String COLUMN_POSTGRES_SERVER_name = "postgres_server";
    private User.Name username;
    private int postgresServer;
    private int disableLog;
    private String predisablePassword;

    @Deprecated
    public UserServer() {
    }

    @Override
    public int arePasswordsSet() throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("Refusing to check if passwords set on special PostgreSQL user: " + this);
        }
        return this.table.getConnector().requestBooleanQuery(true, AoservProtocol.CommandId.IS_POSTGRES_SERVER_USER_PASSWORD_SET, this.pkey) ? 2 : 0;
    }

    @Override
    public boolean canDisable() {
        return !this.isDisabled() && !this.isSpecial();
    }

    @Override
    public boolean canEnable() throws SQLException, IOException {
        if (this.isSpecial()) {
            return false;
        }
        DisableLog dl = this.getDisableLog();
        if (dl == null) {
            return false;
        }
        return dl.canEnable() && !this.getPostgresUser().isDisabled();
    }

    @Override
    public List<PasswordChecker.Result> checkPassword(String password) throws IOException {
        return User.checkPassword(this.username, password);
    }

    @Override
    public void disable(DisableLog dl) throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("Refusing to disable special PostgreSQL user: " + this);
        }
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.DISABLE, new Object[]{Table.TableId.POSTGRES_SERVER_USERS, dl.getPkey(), this.pkey});
    }

    @Override
    public void enable() throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("Refusing to enable special PostgreSQL user: " + this);
        }
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.ENABLE, new Object[]{Table.TableId.POSTGRES_SERVER_USERS, this.pkey});
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.username;
            }
            case 2: {
                return this.postgresServer;
            }
            case 3: {
                return this.getDisableLog_id();
            }
            case 4: {
                return this.predisablePassword;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public boolean isDisabled() {
        return this.disableLog != -1;
    }

    public Integer getDisableLog_id() {
        return this.disableLog == -1 ? null : Integer.valueOf(this.disableLog);
    }

    @Override
    public DisableLog getDisableLog() throws IOException, SQLException {
        if (this.disableLog == -1) {
            return null;
        }
        DisableLog obj = this.table.getConnector().getAccount().getDisableLog().get(this.disableLog);
        if (obj == null) {
            throw new SQLException("Unable to find DisableLog: " + this.disableLog);
        }
        return obj;
    }

    public List<Database> getPostgresDatabases() throws IOException, SQLException {
        return this.table.getConnector().getPostgresql().getDatabase().getPostgresDatabases(this);
    }

    public User.Name getPostgresUser_username() {
        return this.username;
    }

    public User getPostgresUser() throws SQLException, IOException {
        User obj = this.table.getConnector().getPostgresql().getUser().get(this.username);
        if (obj == null) {
            throw new SQLException("Unable to find PostgresUser: " + this.username);
        }
        return obj;
    }

    public boolean isSpecial() {
        return User.isSpecial(this.username);
    }

    public String getPredisablePassword() {
        return this.predisablePassword;
    }

    public int getPostgresServer_bind_id() {
        return this.postgresServer;
    }

    public Server getPostgresServer() throws IOException, SQLException {
        return this.table.getConnector().getPostgresql().getServer().get(this.postgresServer);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.POSTGRES_SERVER_USERS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.username = User.Name.valueOf(result.getString(2));
            this.postgresServer = result.getInt(3);
            this.disableLog = result.getInt(4);
            if (result.wasNull()) {
                this.disableLog = -1;
            }
            this.predisablePassword = result.getString(5);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.username = User.Name.valueOf(in.readUTF()).intern();
            this.postgresServer = in.readCompressedInt();
            this.disableLog = in.readCompressedInt();
            this.predisablePassword = in.readNullUTF();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() throws SQLException, IOException {
        ArrayList reasons = new ArrayList();
        Server ps = this.getPostgresServer();
        if (this.isSpecial()) {
            reasons.add(new CannotRemoveReason<UserServer>("Not allowed to remove a special PostgreSQL user: " + this.username + " on " + ps.getName() + " on " + ps.getLinuxServer().getHostname(), this));
        }
        for (Database pd : this.getPostgresDatabases()) {
            assert (ps.equals(pd.getPostgresServer()));
            reasons.add(new CannotRemoveReason<Database>("Used by PostgreSQL database " + pd.getName() + " on " + ps.getName() + " on " + ps.getLinuxServer().getHostname(), pd));
        }
        return reasons;
    }

    @Override
    public void remove() throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("Refusing to remove special PostgreSQL user: " + this);
        }
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.POSTGRES_SERVER_USERS, this.pkey});
    }

    @Override
    public void setPassword(final String password) throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("Refusing to set the password for a special PostgreSQL user: " + this);
        }
        AoservConnector connector = this.table.getConnector();
        if (!connector.isSecure()) {
            throw new IOException("Passwords for PostgreSQL users may only be set when using secure protocols.  Currently using the " + connector.getProtocol() + " protocol, which is not secure.");
        }
        connector.requestUpdate(true, AoservProtocol.CommandId.SET_POSTGRES_SERVER_USER_PASSWORD, new AoservConnector.UpdateRequest(){

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(UserServer.this.pkey);
                out.writeBoolean(password != null);
                if (password != null) {
                    out.writeUTF(password);
                }
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
            }

            @Override
            public void afterRelease() {
            }
        });
    }

    public void setPredisablePassword(final String password) throws IOException, SQLException {
        if (this.isSpecial()) {
            throw new SQLException("May not disable special PostgreSQL user: " + this.username);
        }
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.SET_POSTGRES_SERVER_USER_PREDISABLE_PASSWORD, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(UserServer.this.pkey);
                out.writeNullUTF(password);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                UserServer.this.table.getConnector().tablesUpdated(this.invalidateList);
            }
        });
    }

    @Override
    public String toStringImpl() throws IOException, SQLException {
        return this.username + " on " + this.getPostgresServer().toStringImpl();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.username.toString());
        out.writeCompressedInt(this.postgresServer);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_130) <= 0) {
            out.writeCompressedInt(-1);
        }
        out.writeCompressedInt(this.disableLog);
        out.writeNullUTF(this.predisablePassword);
    }

    @Override
    public boolean canSetPassword() throws SQLException, IOException {
        return !this.isDisabled() && !this.isSpecial();
    }
}

