/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.postgresql;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.postgresql.Server;
import com.aoindustries.aoserv.client.postgresql.User;
import com.aoindustries.aoserv.client.postgresql.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;

public final class UserServerTable
extends CachedTableIntegerKey<UserServer> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("username", true), new AoservTable.OrderBy("postgres_server.name", true), new AoservTable.OrderBy("postgres_server.ao_server.hostname", true)};

    UserServerTable(AoservConnector connector) {
        super(connector, UserServer.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addPostgresServerUser(User.Name username, Server postgresServer) throws IOException, SQLException {
        if (User.isSpecial(username)) {
            throw new SQLException("Refusing to add special PostgreSQL user: " + username + " on " + postgresServer);
        }
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.POSTGRES_SERVER_USERS, username, postgresServer.getBind_id()});
    }

    @Override
    public UserServer get(int pkey) throws IOException, SQLException {
        return (UserServer)this.getUniqueRow(0, pkey);
    }

    UserServer getPostgresServerUser(User.Name username, Server postgresServer) throws IOException, SQLException {
        return this.getPostgresServerUser(username, postgresServer.getBind_id());
    }

    UserServer getPostgresServerUser(User.Name username, int postgresServer) throws IOException, SQLException {
        List table = this.getRows();
        int size = table.size();
        for (int c = 0; c < size; ++c) {
            UserServer psu = (UserServer)table.get(c);
            if (!psu.getPostgresUser_username().equals(username) || psu.getPostgresServer_bind_id() != postgresServer) continue;
            return psu;
        }
        return null;
    }

    List<UserServer> getPostgresServerUsers(User pu) throws IOException, SQLException {
        return this.getIndexedRows(1, pu.getUsername_username_id());
    }

    List<UserServer> getPostgresServerUsers(Server postgresServer) throws IOException, SQLException {
        return this.getIndexedRows(2, postgresServer.getBind_id());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.POSTGRES_SERVER_USERS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_postgres_server_user")) {
            if (Aosh.checkParamCount("add_postgres_server_user", args, 3, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addPostgresServerUser(Aosh.parsePostgresUserName(args[1], "username"), Aosh.parsePostgresServerName(args[2], "postgres_server"), args[3]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("disable_postgres_server_user")) {
            if (Aosh.checkParamCount("disable_postgres_server_user", args, 4, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().disablePostgresServerUser(Aosh.parsePostgresUserName(args[1], "username"), Aosh.parsePostgresServerName(args[2], "postgres_server"), args[3], args[4]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("enable_postgres_server_user")) {
            if (Aosh.checkParamCount("enable_postgres_server_user", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().enablePostgresServerUser(Aosh.parsePostgresUserName(args[1], "username"), Aosh.parsePostgresServerName(args[2], "postgres_server"), args[3]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("is_postgres_server_user_password_set")) {
            if (Aosh.checkParamCount("is_postgres_server_user_password_set", args, 2, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().isPostgresServerUserPasswordSet(Aosh.parsePostgresUserName(args[1], "username"), Aosh.parsePostgresServerName(args[2], "postgres_server"), args[3]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_postgres_server_user")) {
            if (Aosh.checkParamCount("remove_postgres_server_user", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().removePostgresServerUser(Aosh.parsePostgresUserName(args[1], "username"), Aosh.parsePostgresServerName(args[2], "postgres_server"), args[3]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_postgres_server_user_password")) {
            if (Aosh.checkParamCount("set_postgres_server_user_password", args, 4, (PrintWriter)err)) {
                this.connector.getSimpleClient().setPostgresServerUserPassword(Aosh.parsePostgresUserName(args[1], "username"), Aosh.parsePostgresServerName(args[2], "postgres_server"), args[3], args[4]);
            }
            return true;
        }
        return false;
    }
}

