/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.postgresql;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.lang.validation.ValidationResult;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.SimpleAoservClient;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.password.PasswordChecker;
import com.aoindustries.aoserv.client.postgresql.CachedTableUserNameKey;
import com.aoindustries.aoserv.client.postgresql.User;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class UserTable
extends CachedTableUserNameKey<User> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("username", true)};

    UserTable(AoservConnector connector) {
        super(connector, User.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public void addPostgresUser(User.Name username) throws IOException, SQLException {
        if (User.isSpecial(username)) {
            throw new SQLException("Refusing to add special PostgreSQL user: " + username);
        }
        this.connector.requestUpdateInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.POSTGRES_USERS, username});
    }

    @Override
    public User get(User.Name username) throws IOException, SQLException {
        return (User)this.getUniqueRow(0, username);
    }

    public List<User> getPostgresUsers(Package pack) throws SQLException, IOException {
        Account.Name name = pack.getName();
        List cached = this.getRows();
        int size = cached.size();
        ArrayList<User> matches = new ArrayList<User>(size);
        for (int c = 0; c < size; ++c) {
            User psu = (User)cached.get(c);
            if (!psu.getUsername().getPackage_name().equals(name)) continue;
            matches.add(psu);
        }
        return matches;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.POSTGRES_USERS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IOException, IllegalArgumentException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_postgres_user")) {
            if (Aosh.checkParamCount("add_postgres_user", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().addPostgresUser(Aosh.parsePostgresUserName(args[1], "username"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("are_postgres_user_passwords_set")) {
            if (Aosh.checkParamCount("are_postgres_user_passwords_set", args, 1, (PrintWriter)err)) {
                int result = this.connector.getSimpleClient().arePostgresUserPasswordsSet(Aosh.parsePostgresUserName(args[1], "username"));
                if (result == 0) {
                    out.println("none");
                } else if (result == 1) {
                    out.println("some");
                } else if (result == 2) {
                    out.println("all");
                } else {
                    throw new RuntimeException("Unexpected value for result: " + result);
                }
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("check_postgres_password")) {
            List<PasswordChecker.Result> results;
            if (Aosh.checkParamCount("check_postgres_password", args, 2, (PrintWriter)err) && PasswordChecker.hasResults(results = SimpleAoservClient.checkPostgresPassword(Aosh.parsePostgresUserName(args[1], "username"), args[2]))) {
                PasswordChecker.printResults(results, (Appendable)out);
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("check_postgres_username")) {
            if (Aosh.checkParamCount("check_postgres_username", args, 1, (PrintWriter)err)) {
                ValidationResult validationResult = User.Name.validate(args[1]);
                out.println(validationResult.isValid());
                out.flush();
                if (!validationResult.isValid()) {
                    err.print("aosh: check_postgres_username: ");
                    err.println(validationResult.toString());
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("disable_postgres_user")) {
            if (Aosh.checkParamCount("disable_postgres_user", args, 2, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().disablePostgresUser(Aosh.parsePostgresUserName(args[1], "username"), args[2]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("enable_postgres_user")) {
            if (Aosh.checkParamCount("enable_postgres_user", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().enablePostgresUser(Aosh.parsePostgresUserName(args[1], "username"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_postgres_user")) {
            if (Aosh.checkParamCount("remove_postgres_user", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().removePostgresUser(Aosh.parsePostgresUserName(args[1], "username"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_postgres_user_password")) {
            if (Aosh.checkParamCount("set_postgres_user_password", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().setPostgresUserPassword(Aosh.parsePostgresUserName(args[1], "username"), args[2]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("wait_for_postgres_user_rebuild")) {
            if (Aosh.checkParamCount("wait_for_postgres_user_rebuild", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().waitForPostgresUserRebuild(args[1]);
            }
            return true;
        }
        return false;
    }

    public void waitForRebuild(Server aoServer) throws IOException, SQLException {
        this.connector.requestUpdate(true, AoservProtocol.CommandId.WAIT_FOR_REBUILD, new Object[]{Table.TableId.POSTGRES_USERS, aoServer.getPkey()});
    }
}

