/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.postgresql;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.GlobalObjectIntegerKey;
import com.aoindustries.aoserv.client.distribution.SoftwareVersion;
import com.aoindustries.aoserv.client.postgresql.Encoding;
import com.aoindustries.aoserv.client.postgresql.Server;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public final class Version
extends GlobalObjectIntegerKey<Version> {
    static final int COLUMN_VERSION = 0;
    static final String COLUMN_MINOR_VERSION_name = "minor_version";
    static final String COLUMN_VERSION_name = "version";
    private String minorVersion;
    private int postgisVersion;
    public static final String TECHNOLOGY_NAME = "postgresql";
    public static final String VERSION_7_1 = "7.1";
    public static final String VERSION_7_2 = "7.2";
    public static final String VERSION_7_3 = "7.3";
    public static final String VERSION_8_0 = "8.0";
    public static final String VERSION_8_1 = "8.1";
    public static final String VERSION_8_3 = "8.3";
    public static final String VERSION_9_2 = "9.2";
    public static final String VERSION_9_4 = "9.4";
    public static final String VERSION_9_5 = "9.5";
    public static final String VERSION_9_6 = "9.6";
    public static final String VERSION_10 = "10";
    public static final String VERSION_11 = "11";
    public static final String VERSION_12 = "12";
    public static final String VERSION_13 = "13";
    public static final String VERSION_14 = "14";
    public static final String VERSION_15 = "15";

    public static String[] getPreferredMinorVersions() {
        return new String[]{VERSION_15, VERSION_14, VERSION_13, VERSION_12, VERSION_11, VERSION_10, VERSION_9_6, VERSION_9_5, VERSION_9_4, VERSION_9_2, VERSION_8_3, VERSION_8_1, VERSION_8_0, VERSION_7_3, VERSION_7_2, VERSION_7_1};
    }

    public static boolean isScramSha256(String version) {
        return version.startsWith("10.") || version.startsWith("10R") || version.startsWith("11.") || version.startsWith("11R") || version.startsWith("12.") || version.startsWith("12R") || version.startsWith("13.") || version.startsWith("13R") || version.startsWith("14.") || version.startsWith("14R") || version.startsWith("15.") || version.startsWith("15R");
    }

    @Deprecated
    public Version() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.minorVersion;
            }
            case 2: {
                return this.postgisVersion == -1 ? null : Integer.valueOf(this.postgisVersion);
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public String getMinorVersion() {
        return this.minorVersion;
    }

    public SoftwareVersion getPostgisVersion(AoservConnector connector) throws SQLException, IOException {
        if (this.postgisVersion == -1) {
            return null;
        }
        SoftwareVersion tv = connector.getDistribution().getSoftwareVersion().get(this.postgisVersion);
        if (tv == null) {
            throw new SQLException("Unable to find TechnologyVersion: " + this.postgisVersion);
        }
        if (tv.getOperatingSystemVersion(connector).getPkey() != this.getTechnologyVersion(connector).getOperatingSystemVersion(connector).getPkey()) {
            throw new SQLException("postgresql/postgis version mismatch on PostgresVersion: #" + this.pkey);
        }
        return tv;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.POSTGRES_VERSIONS;
    }

    public List<Encoding> getPostgresEncodings(AoservConnector connector) throws IOException, SQLException {
        return connector.getPostgresql().getEncoding().getPostgresEncodings(this);
    }

    public Encoding getPostgresEncoding(AoservConnector connector, String encoding) throws IOException, SQLException {
        return connector.getPostgresql().getEncoding().getPostgresEncoding(this, encoding);
    }

    public SoftwareVersion getTechnologyVersion(AoservConnector connector) throws SQLException, IOException {
        SoftwareVersion obj = connector.getDistribution().getSoftwareVersion().get(this.pkey);
        if (obj == null) {
            throw new SQLException("Unable to find TechnologyVersion: " + this.pkey);
        }
        return obj;
    }

    public boolean isScramSha256(AoservConnector connector) throws SQLException, IOException {
        return Version.isScramSha256(this.getTechnologyVersion(connector).getVersion());
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.minorVersion = result.getString(2);
        this.postgisVersion = result.getInt(3);
        if (result.wasNull()) {
            this.postgisVersion = -1;
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.minorVersion = in.readUTF().intern();
        this.postgisVersion = in.readCompressedInt();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_109) <= 0) {
            out.writeCompressedInt(Server.DEFAULT_PORT.getPort());
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_121) >= 0) {
            out.writeUTF(this.minorVersion);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_27) >= 0) {
            out.writeCompressedInt(this.postgisVersion);
        }
    }
}

