/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.reseller;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.DomainName;
import com.aoapps.net.HostAddress;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.CachedObjectAccountNameKey;
import com.aoindustries.aoserv.client.email.Address;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.pki.EncryptionKey;
import com.aoindustries.aoserv.client.reseller.BrandCategory;
import com.aoindustries.aoserv.client.reseller.Reseller;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class Brand
extends CachedObjectAccountNameKey<Brand> {
    static final int COLUMN_ACCOUNTING = 0;
    static final String COLUMN_ACCOUNTING_name = "accounting";
    private DomainName nameserver1;
    private DomainName nameserver2;
    private DomainName nameserver3;
    private DomainName nameserver4;
    private int smtpLinuxServerAccount;
    private HostAddress smtpHost;
    private String smtpPassword;
    private int imapLinuxServerAccount;
    private HostAddress imapHost;
    private String imapPassword;
    private int supportEailAddress;
    private String supportEmailDisplay;
    private int signupEmailAddress;
    private String signupEmailDisplay;
    private int ticketEncryptionFrom;
    private int ticketEncryptionRecipient;
    private int signupEncryptionFrom;
    private int signupEncryptionRecipient;
    private String supportTollFree;
    private String supportDayPhone;
    private String supportEmergencyPhone1;
    private String supportEmergencyPhone2;
    private String supportFax;
    private String supportMailingAddress1;
    private String supportMailingAddress2;
    private String supportMailingAddress3;
    private String supportMailingAddress4;
    private boolean englishEnabled;
    private boolean japaneseEnabled;
    private String aowebStrutsHttpUrlBase;
    private String aowebStrutsHttpsUrlBase;
    private String aowebStrutsGoogleVerifyContent;
    private boolean aowebStrutsNoindex;
    private String aowebStrutsGoogleAnalyticsNewTrackingCode;
    private String aowebAtrutsSignupAdminAddress;
    private int aowebStrutsVncBind;
    private String aowebStrutsKeystoreType;
    private String aowebStrutsKeystorePassword;

    @Deprecated
    public Brand() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.nameserver1;
            }
            case 2: {
                return this.nameserver2;
            }
            case 3: {
                return this.nameserver3;
            }
            case 4: {
                return this.nameserver4;
            }
            case 5: {
                return this.smtpLinuxServerAccount;
            }
            case 6: {
                return this.smtpHost;
            }
            case 7: {
                return this.smtpPassword;
            }
            case 8: {
                return this.imapLinuxServerAccount;
            }
            case 9: {
                return this.imapHost;
            }
            case 10: {
                return this.imapPassword;
            }
            case 11: {
                return this.supportEailAddress;
            }
            case 12: {
                return this.supportEmailDisplay;
            }
            case 13: {
                return this.signupEmailAddress;
            }
            case 14: {
                return this.signupEmailDisplay;
            }
            case 15: {
                return this.ticketEncryptionFrom;
            }
            case 16: {
                return this.ticketEncryptionRecipient;
            }
            case 17: {
                return this.signupEncryptionFrom;
            }
            case 18: {
                return this.signupEncryptionRecipient;
            }
            case 19: {
                return this.supportTollFree;
            }
            case 20: {
                return this.supportDayPhone;
            }
            case 21: {
                return this.supportEmergencyPhone1;
            }
            case 22: {
                return this.supportEmergencyPhone2;
            }
            case 23: {
                return this.supportFax;
            }
            case 24: {
                return this.supportMailingAddress1;
            }
            case 25: {
                return this.supportMailingAddress2;
            }
            case 26: {
                return this.supportMailingAddress3;
            }
            case 27: {
                return this.supportMailingAddress4;
            }
            case 28: {
                return this.englishEnabled;
            }
            case 29: {
                return this.japaneseEnabled;
            }
            case 30: {
                return this.aowebStrutsHttpUrlBase;
            }
            case 31: {
                return this.aowebStrutsHttpsUrlBase;
            }
            case 32: {
                return this.aowebStrutsGoogleVerifyContent;
            }
            case 33: {
                return this.aowebStrutsNoindex;
            }
            case 34: {
                return this.aowebStrutsGoogleAnalyticsNewTrackingCode;
            }
            case 35: {
                return this.aowebAtrutsSignupAdminAddress;
            }
            case 36: {
                return this.aowebStrutsVncBind;
            }
            case 37: {
                return this.aowebStrutsKeystoreType;
            }
            case 38: {
                return this.aowebStrutsKeystorePassword;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Account.Name getAccount_name() {
        return this.pkey;
    }

    public Account getAccount() throws IOException, SQLException {
        Account obj = this.table.getConnector().getAccount().getAccount().get(this.pkey);
        if (obj == null) {
            throw new SQLException("Unable to find Account: " + this.pkey);
        }
        return obj;
    }

    public DomainName getNameserver1() {
        return this.nameserver1;
    }

    public DomainName getNameserver2() {
        return this.nameserver2;
    }

    public DomainName getNameserver3() {
        return this.nameserver3;
    }

    public DomainName getNameserver4() {
        return this.nameserver4;
    }

    public UserServer getSmtpLinuxServerAccount() throws IOException, SQLException {
        UserServer lsa = this.table.getConnector().getLinux().getUserServer().get(this.smtpLinuxServerAccount);
        if (lsa == null) {
            throw new SQLException("Unable to find LinuxServerAccount: " + this.smtpLinuxServerAccount);
        }
        return lsa;
    }

    public HostAddress getSmtpHost() throws IOException, SQLException {
        return this.smtpHost != null ? this.smtpHost : HostAddress.valueOf((DomainName)this.getSmtpLinuxServerAccount().getServer().getHostname());
    }

    public String getSmtpPassword() {
        return this.smtpPassword;
    }

    public UserServer getImapLinuxServerAccount() throws SQLException, IOException {
        UserServer lsa = this.table.getConnector().getLinux().getUserServer().get(this.imapLinuxServerAccount);
        if (lsa == null) {
            throw new SQLException("Unable to find LinuxServerAccount: " + this.imapLinuxServerAccount);
        }
        return lsa;
    }

    public HostAddress getImapHost() throws IOException, SQLException {
        return this.imapHost != null ? this.imapHost : HostAddress.valueOf((DomainName)this.getImapLinuxServerAccount().getServer().getHostname());
    }

    public String getImapPassword() {
        return this.imapPassword;
    }

    public Address getSupportEmailAddress() throws IOException, SQLException {
        Address ea = this.table.getConnector().getEmail().getAddress().get(this.supportEailAddress);
        if (ea == null) {
            throw new SQLException("Unable to find EmailAddress: " + this.supportEailAddress);
        }
        return ea;
    }

    public String getSupportEmailDisplay() {
        return this.supportEmailDisplay;
    }

    public Address getSignupEmailAddress() throws IOException, SQLException {
        Address ea = this.table.getConnector().getEmail().getAddress().get(this.signupEmailAddress);
        if (ea == null) {
            throw new SQLException("Unable to find EmailAddress: " + this.signupEmailAddress);
        }
        return ea;
    }

    public String getSignupEmailDisplay() {
        return this.signupEmailDisplay;
    }

    public EncryptionKey getTicketEncryptionFrom() throws IOException, SQLException {
        EncryptionKey ek = this.table.getConnector().getPki().getEncryptionKey().get(this.ticketEncryptionFrom);
        if (ek == null) {
            throw new SQLException("Unable to find EncryptionKey: " + this.ticketEncryptionFrom);
        }
        return ek;
    }

    public EncryptionKey getTicketEncryptionRecipient() throws IOException, SQLException {
        EncryptionKey ek = this.table.getConnector().getPki().getEncryptionKey().get(this.ticketEncryptionRecipient);
        if (ek == null) {
            throw new SQLException("Unable to find EncryptionKey: " + this.ticketEncryptionRecipient);
        }
        return ek;
    }

    public EncryptionKey getSignupEncryptionFrom() throws IOException, SQLException {
        EncryptionKey ek = this.table.getConnector().getPki().getEncryptionKey().get(this.signupEncryptionFrom);
        if (ek == null) {
            throw new SQLException("Unable to find EncryptionKey: " + this.signupEncryptionFrom);
        }
        return ek;
    }

    public EncryptionKey getSignupEncryptionRecipient() throws IOException, SQLException {
        EncryptionKey ek = this.table.getConnector().getPki().getEncryptionKey().get(this.signupEncryptionRecipient);
        if (ek == null) {
            throw new SQLException("Unable to find EncryptionKey: " + this.signupEncryptionRecipient);
        }
        return ek;
    }

    public String getSupportTollFree() {
        return this.supportTollFree;
    }

    public String getSupportDayPhone() {
        return this.supportDayPhone;
    }

    public String getSupportEmergencyPhone1() {
        return this.supportEmergencyPhone1;
    }

    public String getSupportEmergencyPhone2() {
        return this.supportEmergencyPhone2;
    }

    public String getSupportFax() {
        return this.supportFax;
    }

    public String getSupportMailingAddress1() {
        return this.supportMailingAddress1;
    }

    public String getSupportMailingAddress2() {
        return this.supportMailingAddress2;
    }

    public String getSupportMailingAddress3() {
        return this.supportMailingAddress3;
    }

    public String getSupportMailingAddress4() {
        return this.supportMailingAddress4;
    }

    public boolean getEnglishEnabled() {
        return this.englishEnabled;
    }

    public boolean getJapaneseEnabled() {
        return this.japaneseEnabled;
    }

    public String getAowebStrutsHttpUrlBase() {
        return this.aowebStrutsHttpUrlBase;
    }

    public URL getAowebStrutsHttpUrl() throws MalformedURLException {
        return new URL(this.aowebStrutsHttpUrlBase);
    }

    public String getAowebStrutsHttpsUrlBase() {
        return this.aowebStrutsHttpsUrlBase;
    }

    public URL getAowebStrutsHttpsUrl() throws MalformedURLException {
        return new URL(this.aowebStrutsHttpsUrlBase);
    }

    public String getAowebStrutsGoogleVerifyContent() {
        return this.aowebStrutsGoogleVerifyContent;
    }

    public boolean getAowebStrutsNoindex() {
        return this.aowebStrutsNoindex;
    }

    public String getAowebStrutsGoogleAnalyticsNewTrackingCode() {
        return this.aowebStrutsGoogleAnalyticsNewTrackingCode;
    }

    public String getAowebStrutsSignupAdminAddress() {
        return this.aowebAtrutsSignupAdminAddress;
    }

    public Bind getAowebStrutsVncBind() throws IOException, SQLException {
        Bind nb = this.table.getConnector().getNet().getBind().get(this.aowebStrutsVncBind);
        if (nb == null) {
            throw new SQLException("Unable to find NetBind: " + this.aowebStrutsVncBind);
        }
        return nb;
    }

    public String getAowebStrutsKeystoreType() {
        return this.aowebStrutsKeystoreType;
    }

    public String getAowebStrutsKeystorePassword() {
        return this.aowebStrutsKeystorePassword;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.BRANDS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = Account.Name.valueOf(result.getString(pos++));
            this.nameserver1 = DomainName.valueOf((String)result.getString(pos++));
            this.nameserver2 = DomainName.valueOf((String)result.getString(pos++));
            this.nameserver3 = DomainName.valueOf((String)result.getString(pos++));
            this.nameserver4 = DomainName.valueOf((String)result.getString(pos++));
            this.smtpLinuxServerAccount = result.getInt(pos++);
            this.smtpHost = HostAddress.valueOf((String)result.getString(pos++));
            this.smtpPassword = result.getString(pos++);
            this.imapLinuxServerAccount = result.getInt(pos++);
            this.imapHost = HostAddress.valueOf((String)result.getString(pos++));
            this.imapPassword = result.getString(pos++);
            this.supportEailAddress = result.getInt(pos++);
            this.supportEmailDisplay = result.getString(pos++);
            this.signupEmailAddress = result.getInt(pos++);
            this.signupEmailDisplay = result.getString(pos++);
            this.ticketEncryptionFrom = result.getInt(pos++);
            this.ticketEncryptionRecipient = result.getInt(pos++);
            this.signupEncryptionFrom = result.getInt(pos++);
            this.signupEncryptionRecipient = result.getInt(pos++);
            this.supportTollFree = result.getString(pos++);
            this.supportDayPhone = result.getString(pos++);
            this.supportEmergencyPhone1 = result.getString(pos++);
            this.supportEmergencyPhone2 = result.getString(pos++);
            this.supportFax = result.getString(pos++);
            this.supportMailingAddress1 = result.getString(pos++);
            this.supportMailingAddress2 = result.getString(pos++);
            this.supportMailingAddress3 = result.getString(pos++);
            this.supportMailingAddress4 = result.getString(pos++);
            this.englishEnabled = result.getBoolean(pos++);
            this.japaneseEnabled = result.getBoolean(pos++);
            this.aowebStrutsHttpUrlBase = result.getString(pos++);
            this.aowebStrutsHttpsUrlBase = result.getString(pos++);
            this.aowebStrutsGoogleVerifyContent = result.getString(pos++);
            this.aowebStrutsNoindex = result.getBoolean(pos++);
            this.aowebStrutsGoogleAnalyticsNewTrackingCode = result.getString(pos++);
            this.aowebAtrutsSignupAdminAddress = result.getString(pos++);
            this.aowebStrutsVncBind = result.getInt(pos++);
            this.aowebStrutsKeystoreType = result.getString(pos++);
            this.aowebStrutsKeystorePassword = result.getString(pos++);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = Account.Name.valueOf(in.readUTF()).intern();
            this.nameserver1 = DomainName.valueOf((String)in.readUTF());
            this.nameserver2 = DomainName.valueOf((String)in.readUTF());
            this.nameserver3 = DomainName.valueOf((String)in.readNullUTF());
            this.nameserver4 = DomainName.valueOf((String)in.readNullUTF());
            this.smtpLinuxServerAccount = in.readCompressedInt();
            this.smtpHost = HostAddress.valueOf((String)in.readNullUTF());
            this.smtpPassword = in.readUTF();
            this.imapLinuxServerAccount = in.readCompressedInt();
            this.imapHost = HostAddress.valueOf((String)in.readNullUTF());
            this.imapPassword = in.readUTF();
            this.supportEailAddress = in.readCompressedInt();
            this.supportEmailDisplay = in.readUTF();
            this.signupEmailAddress = in.readCompressedInt();
            this.signupEmailDisplay = in.readUTF();
            this.ticketEncryptionFrom = in.readCompressedInt();
            this.ticketEncryptionRecipient = in.readCompressedInt();
            this.signupEncryptionFrom = in.readCompressedInt();
            this.signupEncryptionRecipient = in.readCompressedInt();
            this.supportTollFree = in.readNullUTF();
            this.supportDayPhone = in.readNullUTF();
            this.supportEmergencyPhone1 = in.readNullUTF();
            this.supportEmergencyPhone2 = in.readNullUTF();
            this.supportFax = in.readNullUTF();
            this.supportMailingAddress1 = in.readNullUTF();
            this.supportMailingAddress2 = in.readNullUTF();
            this.supportMailingAddress3 = in.readNullUTF();
            this.supportMailingAddress4 = in.readNullUTF();
            this.englishEnabled = in.readBoolean();
            this.japaneseEnabled = in.readBoolean();
            this.aowebStrutsHttpUrlBase = in.readUTF();
            this.aowebStrutsHttpsUrlBase = in.readUTF();
            this.aowebStrutsGoogleVerifyContent = in.readNullUTF();
            this.aowebStrutsNoindex = in.readBoolean();
            this.aowebStrutsGoogleAnalyticsNewTrackingCode = in.readNullUTF();
            this.aowebAtrutsSignupAdminAddress = in.readUTF();
            this.aowebStrutsVncBind = in.readCompressedInt();
            this.aowebStrutsKeystoreType = in.readUTF();
            this.aowebStrutsKeystorePassword = in.readUTF();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey.toString());
        out.writeUTF(this.nameserver1.toString());
        out.writeUTF(this.nameserver2.toString());
        out.writeNullUTF(Objects.toString(this.nameserver3, null));
        out.writeNullUTF(Objects.toString(this.nameserver4, null));
        out.writeCompressedInt(this.smtpLinuxServerAccount);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_46) >= 0) {
            out.writeNullUTF(Objects.toString(this.smtpHost, null));
        }
        out.writeUTF(this.smtpPassword);
        out.writeCompressedInt(this.imapLinuxServerAccount);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_46) >= 0) {
            out.writeNullUTF(Objects.toString(this.imapHost, null));
        }
        out.writeUTF(this.imapPassword);
        out.writeCompressedInt(this.supportEailAddress);
        out.writeUTF(this.supportEmailDisplay);
        out.writeCompressedInt(this.signupEmailAddress);
        out.writeUTF(this.signupEmailDisplay);
        out.writeCompressedInt(this.ticketEncryptionFrom);
        out.writeCompressedInt(this.ticketEncryptionRecipient);
        out.writeCompressedInt(this.signupEncryptionFrom);
        out.writeCompressedInt(this.signupEncryptionRecipient);
        out.writeNullUTF(this.supportTollFree);
        out.writeNullUTF(this.supportDayPhone);
        out.writeNullUTF(this.supportEmergencyPhone1);
        out.writeNullUTF(this.supportEmergencyPhone2);
        out.writeNullUTF(this.supportFax);
        out.writeNullUTF(this.supportMailingAddress1);
        out.writeNullUTF(this.supportMailingAddress2);
        out.writeNullUTF(this.supportMailingAddress3);
        out.writeNullUTF(this.supportMailingAddress4);
        out.writeBoolean(this.englishEnabled);
        out.writeBoolean(this.japaneseEnabled);
        out.writeUTF(this.aowebStrutsHttpUrlBase);
        out.writeUTF(this.aowebStrutsHttpsUrlBase);
        out.writeNullUTF(this.aowebStrutsGoogleVerifyContent);
        out.writeBoolean(this.aowebStrutsNoindex);
        out.writeNullUTF(this.aowebStrutsGoogleAnalyticsNewTrackingCode);
        out.writeUTF(this.aowebAtrutsSignupAdminAddress);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_52) >= 0) {
            out.writeCompressedInt(this.aowebStrutsVncBind);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_53) >= 0) {
            out.writeUTF(this.aowebStrutsKeystoreType);
            out.writeUTF(this.aowebStrutsKeystorePassword);
        }
    }

    public Reseller getReseller() throws IOException, SQLException {
        return this.table.getConnector().getReseller().getReseller().getReseller(this);
    }

    public List<BrandCategory> getTicketBrandCategories() throws IOException, SQLException {
        return this.table.getConnector().getReseller().getBrandCategory().getTicketBrandCategories(this);
    }

    public Brand getParentBrand() throws IOException, SQLException {
        Account account = this.getAccount();
        Account parent = account.getParent();
        while (parent != null) {
            Brand parentBrand = parent.getBrand();
            if (parentBrand == null) continue;
            return parentBrand;
        }
        return null;
    }

    public List<Brand> getChildBrands() throws IOException, SQLException {
        ArrayList<Brand> children = new ArrayList<Brand>();
        for (Brand brand : this.table.getConnector().getReseller().getBrand().getRows()) {
            if (brand.equals(this) || !this.equals(brand.getParentBrand())) continue;
            children.add(brand);
        }
        return children;
    }
}

