/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.reseller;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.reseller.Brand;
import com.aoindustries.aoserv.client.reseller.Category;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class BrandCategory
extends CachedObjectIntegerKey<BrandCategory> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_BRAND = 1;
    static final int COLUMN_CATEGORY = 2;
    static final String COLUMN_PKEY_name = "pkey";
    static final String COLUMN_BRAND_name = "brand";
    static final String COLUMN_CATEGORY_name = "category";
    private Account.Name brand;
    private int category;
    private boolean enabled;

    @Deprecated
    public BrandCategory() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.brand;
            }
            case 2: {
                return this.category;
            }
            case 3: {
                return this.enabled;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Brand getBrand() throws SQLException, IOException {
        Brand br = this.table.getConnector().getReseller().getBrand().get(this.brand);
        if (br == null) {
            throw new SQLException("Unable to find Brand: " + this.brand);
        }
        return br;
    }

    public Category getCategory() throws IOException, SQLException {
        Category tc = this.table.getConnector().getReseller().getCategory().get(this.category);
        if (tc == null) {
            throw new SQLException("Unable to find TicketCategory: " + this.category);
        }
        return tc;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.TICKET_BRAND_CATEGORIES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.brand = Account.Name.valueOf(result.getString(2));
            this.category = result.getInt(3);
            this.enabled = result.getBoolean(4);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.brand = Account.Name.valueOf(in.readUTF()).intern();
            this.category = in.readCompressedInt();
            this.enabled = in.readBoolean();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String toStringImpl() {
        return this.brand + "|" + this.category + '|' + this.enabled;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.brand.toString());
        out.writeCompressedInt(this.category);
        out.writeBoolean(this.enabled);
    }
}

