/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.reseller;

import com.aoapps.hodgepodge.tree.Node;
import com.aoapps.hodgepodge.tree.Tree;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.CachedTableAccountNameKey;
import com.aoindustries.aoserv.client.reseller.Brand;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class BrandTable
extends CachedTableAccountNameKey<Brand> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("accounting", true)};
    private final Tree<Brand> tree = () -> {
        List<Brand> topLevelBrands = this.getTopLevelBrands();
        int size = topLevelBrands.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        if (size == 1) {
            BrandTreeNode singleNode = new BrandTreeNode(topLevelBrands.get(0));
            return Collections.singletonList(singleNode);
        }
        ArrayList<BrandTreeNode> rootNodes = new ArrayList<BrandTreeNode>(size);
        for (Brand topLevelBrand : topLevelBrands) {
            rootNodes.add(new BrandTreeNode(topLevelBrand));
        }
        return Collections.unmodifiableList(rootNodes);
    };

    BrandTable(AoservConnector connector) {
        super(connector, Brand.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public Brand get(Account.Name accounting) throws IOException, SQLException {
        return (Brand)this.getUniqueRow(0, accounting);
    }

    public Brand getBrand(Account business) throws IOException, SQLException {
        return (Brand)this.getUniqueRow(0, business.getName());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.BRANDS;
    }

    public List<Brand> getTopLevelBrands() throws IOException, SQLException {
        ArrayList<Brand> matches = new ArrayList<Brand>();
        for (Brand brand : this.getRows()) {
            if (brand.getParentBrand() != null) continue;
            matches.add(brand);
        }
        return matches;
    }

    public Tree<Brand> getTree() {
        return this.tree;
    }

    static class BrandTreeNode
    implements Node<Brand> {
        private final Brand brand;

        BrandTreeNode(Brand brand) {
            this.brand = brand;
        }

        public List<Node<Brand>> getChildren() throws IOException, SQLException {
            List<Brand> children = this.brand.getChildBrands();
            int size = children.size();
            if (size == 0) {
                return null;
            }
            if (size == 1) {
                BrandTreeNode singleNode = new BrandTreeNode(children.get(0));
                return Collections.singletonList(singleNode);
            }
            ArrayList<BrandTreeNode> childNodes = new ArrayList<BrandTreeNode>(size);
            for (Brand child : children) {
                childNodes.add(new BrandTreeNode(child));
            }
            return Collections.unmodifiableList(childNodes);
        }

        public Brand getValue() {
            return this.brand;
        }
    }
}

