/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.reseller;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.i18n.Resources;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.reseller.BrandCategory;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.ResourceBundle;

public final class Category
extends CachedObjectIntegerKey<Category> {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, Category.class);
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_PARENT = 1;
    static final int COLUMN_NAME = 2;
    static final String COLUMN_PKEY_name = "pkey";
    static final String COLUMN_PARENT_name = "parent";
    static final String COLUMN_NAME_name = "name";
    public static final int AOSERV_MASTER_PKEY = 110;
    private int parent;
    private String name;
    private String slashPath;
    private String dotPath;

    @Deprecated
    public Category() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.parent == -1 ? null : Integer.valueOf(this.parent);
            }
            case 2: {
                return this.name;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Integer getParent_id() {
        return this.parent == -1 ? null : Integer.valueOf(this.parent);
    }

    public Category getParent() throws IOException, SQLException {
        if (this.parent == -1) {
            return null;
        }
        Category tc = this.table.getConnector().getReseller().getCategory().get(this.parent);
        if (tc == null) {
            throw new SQLException("Unable to find TicketCategory: " + this.parent);
        }
        return tc;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.TICKET_CATEGORIES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.parent = result.getInt(2);
        if (result.wasNull()) {
            this.parent = -1;
        }
        this.name = result.getString(3);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.parent = in.readCompressedInt();
        this.name = in.readUTF().intern();
    }

    public synchronized String getSlashPath() throws IOException, SQLException {
        if (this.slashPath == null) {
            this.slashPath = this.parent == -1 ? this.name : this.getParent().getSlashPath() + '/' + this.name;
        }
        return this.slashPath;
    }

    public synchronized String getDotPath() throws IOException, SQLException {
        if (this.dotPath == null) {
            this.dotPath = this.parent == -1 ? this.name : this.getParent().getDotPath() + '.' + this.name;
        }
        return this.dotPath;
    }

    @Override
    public String toStringImpl() throws IOException, SQLException {
        return RESOURCES.getMessage(this.getDotPath() + ".toString");
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.parent);
        out.writeUTF(this.name);
    }

    public List<BrandCategory> getTicketBrandCategorys() throws IOException, SQLException {
        return this.table.getConnector().getReseller().getBrandCategory().getTicketBrandCategories(this);
    }

    public List<Category> getChildrenCategories() throws IOException, SQLException {
        return this.table.getConnector().getReseller().getCategory().getChildrenCategories(this);
    }
}

