/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.reseller;

import com.aoapps.hodgepodge.tree.Node;
import com.aoapps.hodgepodge.tree.Tree;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.reseller.Category;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CategoryTable
extends CachedTableIntegerKey<Category> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("parent", true), new AoservTable.OrderBy("name", true)};
    private final Tree<Category> tree = () -> {
        List<Category> topLevelCategories = this.getTopLevelCategories();
        int size = topLevelCategories.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        if (size == 1) {
            TicketCategoryTreeNode singleNode = new TicketCategoryTreeNode(topLevelCategories.get(0));
            return Collections.singletonList(singleNode);
        }
        ArrayList<TicketCategoryTreeNode> rootNodes = new ArrayList<TicketCategoryTreeNode>(size);
        for (Category topLevelCategory : topLevelCategories) {
            rootNodes.add(new TicketCategoryTreeNode(topLevelCategory));
        }
        return Collections.unmodifiableList(rootNodes);
    };

    CategoryTable(AoservConnector connector) {
        super(connector, Category.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public Category get(int pkey) throws IOException, SQLException {
        return (Category)this.getUniqueRow(0, pkey);
    }

    public List<Category> getTopLevelCategories() throws IOException, SQLException {
        List cached = this.getRows();
        ArrayList<Category> matches = new ArrayList<Category>();
        int size = cached.size();
        for (int c = 0; c < size; ++c) {
            Category tc = (Category)cached.get(c);
            if (tc.getParent_id() != null) continue;
            matches.add(tc);
        }
        return matches;
    }

    List<Category> getChildrenCategories(Category parent) throws IOException, SQLException {
        return this.getIndexedRows(1, parent.getPkey());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.TICKET_CATEGORIES;
    }

    public Category getTicketCategory(Category parent, String name) throws IOException, SQLException {
        if (parent == null) {
            for (Category tc : this.getRows()) {
                if (tc.getParent_id() != null || !tc.getName().equals(name)) continue;
                return tc;
            }
        } else {
            for (Category child : this.getChildrenCategories(parent)) {
                if (!child.getName().equals(name)) continue;
                return child;
            }
        }
        return null;
    }

    public Category getTicketCategoryByDotPath(String dotPath) throws IOException, SQLException {
        for (Category category : this.getRows()) {
            if (!category.getDotPath().equals(dotPath)) continue;
            return category;
        }
        return null;
    }

    public Tree<Category> getTree() {
        return this.tree;
    }

    static class TicketCategoryTreeNode
    implements Node<Category> {
        private final Category ticketCategory;

        TicketCategoryTreeNode(Category ticketCategory) {
            this.ticketCategory = ticketCategory;
        }

        public List<Node<Category>> getChildren() throws IOException, SQLException {
            List<Category> children = this.ticketCategory.getChildrenCategories();
            int size = children.size();
            if (size == 0) {
                return null;
            }
            if (size == 1) {
                TicketCategoryTreeNode singleNode = new TicketCategoryTreeNode(children.get(0));
                return Collections.singletonList(singleNode);
            }
            ArrayList<TicketCategoryTreeNode> childNodes = new ArrayList<TicketCategoryTreeNode>(size);
            for (Category child : children) {
                childNodes.add(new TicketCategoryTreeNode(child));
            }
            return Collections.unmodifiableList(childNodes);
        }

        public Category getValue() {
            return this.ticketCategory;
        }
    }
}

