/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.reseller;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.CachedObjectAccountNameKey;
import com.aoindustries.aoserv.client.reseller.Brand;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.ticket.Assignment;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class Reseller
extends CachedObjectAccountNameKey<Reseller> {
    static final int COLUMN_ACCOUNTING = 0;
    static final String COLUMN_ACCOUNTING_name = "accounting";
    private boolean ticketAutoEscalate;

    @Deprecated
    public Reseller() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.ticketAutoEscalate;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Account.Name getBrand_business_accounting() {
        return this.pkey;
    }

    public Brand getBrand() throws SQLException, IOException {
        Brand br = this.table.getConnector().getReseller().getBrand().get(this.pkey);
        if (br == null) {
            throw new SQLException("Unable to find Brand: " + this.pkey);
        }
        return br;
    }

    public boolean getTicketAutoEscalate() {
        return this.ticketAutoEscalate;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.RESELLERS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = Account.Name.valueOf(result.getString(pos++));
            this.ticketAutoEscalate = result.getBoolean(pos++);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = Account.Name.valueOf(in.readUTF()).intern();
            this.ticketAutoEscalate = in.readBoolean();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey.toUpperCase());
        out.writeBoolean(this.ticketAutoEscalate);
    }

    public List<Assignment> getTicketAssignments() throws IOException, SQLException {
        return this.table.getConnector().getTicket().getAssignment().getTicketAssignments(this);
    }

    public Reseller getParent() throws IOException, SQLException {
        Account bu = this.getBrand().getAccount();
        if (bu == null) {
            return null;
        }
        Account parent = bu.getParent();
        while (parent != null) {
            Reseller parentReseller;
            Brand parentBrand = parent.getBrand();
            if (parentBrand == null || (parentReseller = parentBrand.getReseller()) == null) continue;
            return parentReseller;
        }
        return null;
    }

    public List<Reseller> getChildResellers() throws IOException, SQLException {
        ArrayList<Reseller> children = new ArrayList<Reseller>();
        for (Reseller reseller : this.table.getConnector().getReseller().getReseller().getRows()) {
            if (reseller.equals(this) || !this.equals(reseller.getParent())) continue;
            children.add(reseller);
        }
        return children;
    }
}

