/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.reseller;

import com.aoapps.hodgepodge.tree.Node;
import com.aoapps.hodgepodge.tree.Tree;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.CachedTableAccountNameKey;
import com.aoindustries.aoserv.client.reseller.Brand;
import com.aoindustries.aoserv.client.reseller.Reseller;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ResellerTable
extends CachedTableAccountNameKey<Reseller> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("accounting", true)};
    private final Tree<Reseller> tree = () -> {
        List<Reseller> topLevelResellers = this.getTopLevelResellers();
        int size = topLevelResellers.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        if (size == 1) {
            ResellerTreeNode singleNode = new ResellerTreeNode(topLevelResellers.get(0));
            return Collections.singletonList(singleNode);
        }
        ArrayList<ResellerTreeNode> rootNodes = new ArrayList<ResellerTreeNode>(size);
        for (Reseller topLevelReseller : topLevelResellers) {
            rootNodes.add(new ResellerTreeNode(topLevelReseller));
        }
        return Collections.unmodifiableList(rootNodes);
    };

    ResellerTable(AoservConnector connector) {
        super(connector, Reseller.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public Reseller get(Account.Name accounting) throws IOException, SQLException {
        return (Reseller)this.getUniqueRow(0, accounting);
    }

    Reseller getReseller(Brand brand) throws IOException, SQLException {
        return (Reseller)this.getUniqueRow(0, brand.getAccount_name());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.RESELLERS;
    }

    public List<Reseller> getTopLevelResellers() throws IOException, SQLException {
        ArrayList<Reseller> matches = new ArrayList<Reseller>();
        for (Reseller reseller : this.getRows()) {
            if (reseller.getParent() != null) continue;
            matches.add(reseller);
        }
        return matches;
    }

    public Tree<Reseller> getTree() {
        return this.tree;
    }

    static class ResellerTreeNode
    implements Node<Reseller> {
        private final Reseller reseller;

        ResellerTreeNode(Reseller reseller) {
            this.reseller = reseller;
        }

        public List<Node<Reseller>> getChildren() throws IOException, SQLException {
            List<Reseller> children = this.reseller.getChildResellers();
            int size = children.size();
            if (size == 0) {
                return null;
            }
            if (size == 1) {
                ResellerTreeNode singleNode = new ResellerTreeNode(children.get(0));
                return Collections.singletonList(singleNode);
            }
            ArrayList<ResellerTreeNode> childNodes = new ArrayList<ResellerTreeNode>(size);
            for (Reseller child : children) {
                childNodes.add(new ResellerTreeNode(child));
            }
            return Collections.unmodifiableList(childNodes);
        }

        public Reseller getValue() {
            return this.reseller;
        }
    }
}

