/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.schema;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.util.InternUtils;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.GlobalObjectIntegerKey;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.ForeignKey;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.schema.Type;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public final class Column
extends GlobalObjectIntegerKey<Column> {
    static final int COLUMN_ID = 0;
    private String table;
    private String name;
    private String sinceVersion;
    private String lastVersion;
    private short index;
    private String type;
    private boolean isNullable;
    private boolean isUnique;
    private boolean isPublic;
    private String description;

    @Deprecated
    public Column() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.table;
            }
            case 2: {
                return this.name;
            }
            case 3: {
                return this.sinceVersion;
            }
            case 4: {
                return this.lastVersion;
            }
            case 5: {
                return this.index;
            }
            case 6: {
                return this.type;
            }
            case 7: {
                return this.isNullable;
            }
            case 8: {
                return this.isUnique;
            }
            case 9: {
                return this.isPublic;
            }
            case 10: {
                return this.description;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getId() {
        return this.pkey;
    }

    public String getTable_name() {
        return this.table;
    }

    public Table getTable(AoservConnector connector) throws SQLException, IOException {
        Table obj = connector.getSchema().getTable().get(this.table);
        if (obj == null) {
            throw new SQLException("Unable to find SchemaTable: " + this.table);
        }
        return obj;
    }

    public String getName() {
        return this.name;
    }

    public String getSinceVersion_version() {
        return this.sinceVersion;
    }

    public AoservProtocol getSinceVersion(AoservConnector connector) throws SQLException, IOException {
        AoservProtocol obj = connector.getSchema().getAoservProtocol().get(this.sinceVersion);
        if (obj == null) {
            throw new SQLException("Unable to find AoservProtocol: " + this.sinceVersion);
        }
        return obj;
    }

    public String getLastVersion_version() {
        return this.lastVersion;
    }

    public AoservProtocol getLastVersion(AoservConnector connector) throws SQLException, IOException {
        if (this.lastVersion == null) {
            return null;
        }
        AoservProtocol obj = connector.getSchema().getAoservProtocol().get(this.lastVersion);
        if (obj == null) {
            throw new SQLException("Unable to find AoservProtocol: " + this.lastVersion);
        }
        return obj;
    }

    public short getIndex() {
        return this.index;
    }

    public String getType_name() {
        return this.type;
    }

    public Type getType(AoservConnector connector) throws SQLException, IOException {
        Type obj = connector.getSchema().getType().get(this.type);
        if (obj == null) {
            throw new SQLException("Unable to find SchemaType: " + this.type);
        }
        return obj;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SCHEMA_COLUMNS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        int pos = 1;
        this.pkey = result.getInt(pos++);
        this.table = result.getString(pos++);
        this.name = result.getString(pos++);
        this.sinceVersion = result.getString(pos++);
        this.lastVersion = result.getString(pos++);
        this.index = result.getShort(pos++);
        this.type = result.getString(pos++);
        this.isNullable = result.getBoolean(pos++);
        this.isUnique = result.getBoolean(pos++);
        this.isPublic = result.getBoolean(pos++);
        this.description = result.getString(pos++);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.table = in.readUTF().intern();
        this.name = in.readUTF().intern();
        this.sinceVersion = in.readUTF().intern();
        this.lastVersion = InternUtils.intern((String)in.readNullUTF());
        this.index = in.readShort();
        this.type = in.readUTF().intern();
        this.isNullable = in.readBoolean();
        this.isUnique = in.readBoolean();
        this.isPublic = in.readBoolean();
        this.description = in.readUTF();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.table);
        out.writeUTF(this.name);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_18) >= 0) {
            out.writeUTF(this.sinceVersion);
            out.writeNullUTF(this.lastVersion);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_17) <= 0) {
            out.writeCompressedInt((int)this.index);
        } else {
            out.writeShort((int)this.index);
        }
        out.writeUTF(this.type);
        out.writeBoolean(this.isNullable);
        out.writeBoolean(this.isUnique);
        out.writeBoolean(this.isPublic);
        out.writeUTF(this.description);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_17) <= 0) {
            if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_101) >= 0) {
                out.writeUTF(this.sinceVersion);
            }
            if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_104) >= 0) {
                out.writeNullUTF(this.lastVersion);
            }
        }
    }

    @Override
    public String toStringImpl() {
        return this.table + '.' + this.name;
    }

    public List<ForeignKey> getReferencedBy(AoservConnector connector) throws IOException, SQLException {
        return connector.getSchema().getForeignKey().getSchemaForeignKeysReferencing(this);
    }

    public List<ForeignKey> getReferences(AoservConnector connector) throws IOException, SQLException {
        return connector.getSchema().getForeignKey().getSchemaForeignKeysReferencedBy(this);
    }
}

