/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.schema;

import com.aoapps.collections.AoCollections;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.GlobalTableIntegerKey;
import com.aoindustries.aoserv.client.schema.Column;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ColumnTable
extends GlobalTableIntegerKey<Column> {
    private static final int numTables;
    private static final List<List<Column>> tableColumns;
    private static final List<Map<String, Column>> nameToColumns;

    ColumnTable(AoservConnector connector) {
        super(connector, Column.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return null;
    }

    @Override
    public Column get(int pkey) throws IOException, SQLException {
        return (Column)this.getUniqueRow(0, pkey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Column getSchemaColumn(Table table, String columnName) throws IOException, SQLException {
        int tableId = table.getId();
        List<Map<String, Column>> list = nameToColumns;
        synchronized (list) {
            HashMap map = nameToColumns.get(tableId);
            if (map == null || map.isEmpty()) {
                List<Column> cols = this.getSchemaColumns(table);
                int len = cols.size();
                if (map == null) {
                    map = AoCollections.newHashMap((int)len);
                    nameToColumns.set(tableId, map);
                }
                for (int c = 0; c < len; ++c) {
                    Column col = cols.get(c);
                    map.put(col.getName(), col);
                }
            }
            return map.get(columnName);
        }
    }

    Column getSchemaColumn(Table table, int columnIndex) throws IOException, SQLException {
        return this.getSchemaColumns(table).get(columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Column> getSchemaColumns(Table table) throws IOException, SQLException {
        int tableId = table.getId();
        List<List<Column>> list = tableColumns;
        synchronized (list) {
            List<Column> cols = tableColumns.get(tableId);
            if (cols != null) {
                return cols;
            }
            String name = table.getName();
            List cached = this.getRows();
            ArrayList<Column> matches = new ArrayList();
            int size = cached.size();
            for (int c = 0; c < size; ++c) {
                Column col = (Column)cached.get(c);
                if (!col.getTable_name().equals(name)) continue;
                matches.add(col);
            }
            matches = Collections.unmodifiableList(matches);
            tableColumns.set(tableId, matches);
            return matches;
        }
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SCHEMA_COLUMNS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        super.clearCache();
        ColumnTable columnTable = this;
        synchronized (columnTable) {
            for (int c = 0; c < numTables; ++c) {
                List<Object> list = tableColumns;
                synchronized (list) {
                    tableColumns.set(c, null);
                }
                list = nameToColumns;
                synchronized (list) {
                    Map<String, Column> map = nameToColumns.get(c);
                    if (map != null) {
                        map.clear();
                    }
                    continue;
                }
            }
        }
    }

    static {
        int c;
        numTables = Table.TableId.values().length;
        tableColumns = new ArrayList<List<Column>>(numTables);
        for (c = 0; c < numTables; ++c) {
            tableColumns.add(null);
        }
        nameToColumns = new ArrayList<Map<String, Column>>(numTables);
        for (c = 0; c < numTables; ++c) {
            nameToColumns.add(null);
        }
    }
}

