/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.schema;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.util.InternUtils;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.GlobalObjectIntegerKey;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Column;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class ForeignKey
extends GlobalObjectIntegerKey<ForeignKey> {
    static final int COLUMN_ID = 0;
    static final String COLUMN_ID_name = "id";
    private int column;
    private int foreignColumn;
    private String sinceVersion;
    private String lastVersion;

    @Deprecated
    public ForeignKey() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.column;
            }
            case 2: {
                return this.foreignColumn;
            }
            case 3: {
                return this.sinceVersion;
            }
            case 4: {
                return this.lastVersion;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getColumn_id() {
        return this.column;
    }

    public Column getColumn(AoservConnector connector) throws SQLException, IOException {
        Column obj = connector.getSchema().getColumn().get(this.column);
        if (obj == null) {
            throw new SQLException("Unable to find SchemaColumn: " + this.column);
        }
        return obj;
    }

    public int getForeignColumn_id() {
        return this.foreignColumn;
    }

    public Column getForeignColumn(AoservConnector connector) throws SQLException, IOException {
        Column obj = connector.getSchema().getColumn().get(this.foreignColumn);
        if (obj == null) {
            throw new SQLException("Unable to find SchemaColumn: " + this.foreignColumn);
        }
        return obj;
    }

    public String getSinceVersion_version() {
        return this.sinceVersion;
    }

    public AoservProtocol getSinceVersion(AoservConnector connector) throws SQLException, IOException {
        AoservProtocol obj = connector.getSchema().getAoservProtocol().get(this.sinceVersion);
        if (obj == null) {
            throw new SQLException("Unable to find AoservProtocol: " + this.sinceVersion);
        }
        return obj;
    }

    public String getLastVersion_version() {
        return this.lastVersion;
    }

    public AoservProtocol getLastVersion(AoservConnector connector) throws SQLException, IOException {
        if (this.lastVersion == null) {
            return null;
        }
        AoservProtocol obj = connector.getSchema().getAoservProtocol().get(this.lastVersion);
        if (obj == null) {
            throw new SQLException("Unable to find AoservProtocol: " + this.lastVersion);
        }
        return obj;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SCHEMA_FOREIGN_KEYS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        int pos = 1;
        this.pkey = result.getInt(pos++);
        this.column = result.getInt(pos++);
        this.foreignColumn = result.getInt(pos++);
        this.sinceVersion = result.getString(pos++);
        this.lastVersion = result.getString(pos++);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.column = in.readCompressedInt();
        this.foreignColumn = in.readCompressedInt();
        this.sinceVersion = in.readUTF().intern();
        this.lastVersion = InternUtils.intern((String)in.readNullUTF());
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.column);
        out.writeCompressedInt(this.foreignColumn);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeBoolean(false);
            out.writeCompressedInt(-1);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_101) >= 0) {
            out.writeUTF(this.sinceVersion);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_104) >= 0) {
            out.writeNullUTF(this.lastVersion);
        }
    }
}

