/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.schema;

import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.GlobalTableIntegerKey;
import com.aoindustries.aoserv.client.schema.Column;
import com.aoindustries.aoserv.client.schema.ForeignKey;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ForeignKeyTable
extends GlobalTableIntegerKey<ForeignKey> {
    private static final Map<String, List<ForeignKey>> tableKeys = new HashMap<String, List<ForeignKey>>();
    private static final Map<Integer, List<ForeignKey>> referencesHash = new HashMap<Integer, List<ForeignKey>>();
    private static final Map<Integer, List<ForeignKey>> referencedByHash = new HashMap<Integer, List<ForeignKey>>();
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("id", true)};

    ForeignKeyTable(AoservConnector connector) {
        super(connector, ForeignKey.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        super.clearCache();
        Class<ForeignKeyTable> clazz = ForeignKeyTable.class;
        synchronized (ForeignKeyTable.class) {
            tableKeys.clear();
            referencesHash.clear();
            referencedByHash.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public ForeignKey get(int pkey) throws IOException, SQLException {
        return (ForeignKey)this.getUniqueRow(0, pkey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ForeignKey> getSchemaForeignKeys(Table table) throws IOException, SQLException {
        Class<ForeignKeyTable> clazz = ForeignKeyTable.class;
        synchronized (ForeignKeyTable.class) {
            List<ForeignKey> matches;
            if (tableKeys.isEmpty()) {
                List cached = this.getRows();
                int size = cached.size();
                for (int c = 0; c < size; ++c) {
                    ForeignKey key = (ForeignKey)cached.get(c);
                    String tableName = key.getColumn(this.connector).getTable_name();
                    List<ForeignKey> keys = tableKeys.get(tableName);
                    if (keys == null) {
                        keys = new ArrayList<ForeignKey>();
                        tableKeys.put(tableName, keys);
                    }
                    keys.add(key);
                }
            }
            if ((matches = tableKeys.get(table.getName())) != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return matches;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Collections.emptyList();
        }
    }

    private void rebuildReferenceHashes() throws IOException, SQLException {
        if (referencedByHash.isEmpty() || referencesHash.isEmpty()) {
            List cached = this.getRows();
            int size = cached.size();
            for (int c = 0; c < size; ++c) {
                ForeignKey key = (ForeignKey)cached.get(c);
                Integer keyColumnPkey = key.getColumn_id();
                Integer foreignColumnPkey = key.getForeignColumn_id();
                List<ForeignKey> referencedBy = referencedByHash.get(keyColumnPkey);
                if (referencedBy == null) {
                    referencedBy = new ArrayList<ForeignKey>();
                    referencedByHash.put(keyColumnPkey, referencedBy);
                }
                referencedBy.add(key);
                List<ForeignKey> references = referencesHash.get(foreignColumnPkey);
                if (references == null) {
                    references = new ArrayList<ForeignKey>();
                    referencesHash.put(foreignColumnPkey, references);
                }
                references.add(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ForeignKey> getSchemaForeignKeysReferencedBy(Column column) throws IOException, SQLException {
        Class<ForeignKeyTable> clazz = ForeignKeyTable.class;
        synchronized (ForeignKeyTable.class) {
            this.rebuildReferenceHashes();
            List<ForeignKey> matches = referencedByHash.get(column.getPkey());
            if (matches != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return matches;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ForeignKey> getSchemaForeignKeysReferencing(Column column) throws IOException, SQLException {
        Class<ForeignKeyTable> clazz = ForeignKeyTable.class;
        synchronized (ForeignKeyTable.class) {
            this.rebuildReferenceHashes();
            List<ForeignKey> matches = referencesHash.get(column.getPkey());
            if (matches != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return matches;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Collections.emptyList();
        }
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SCHEMA_FOREIGN_KEYS;
    }
}

