/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.schema;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.sort.JavaSort;
import com.aoapps.lang.Throwables;
import com.aoapps.lang.exception.WrappedException;
import com.aoapps.sql.SQLUtility;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservObject;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.GlobalTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.schema.Column;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.schema.Type;
import com.aoindustries.aoserv.client.sql.Parser;
import com.aoindustries.aoserv.client.sql.SqlExpression;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class TableTable
extends GlobalTableIntegerKey<Table> {
    private static final int numTables = Table.TableId.values().length;

    TableTable(AoservConnector connector) {
        super(connector, Table.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return null;
    }

    @Override
    @Deprecated
    public Table get(Object pkey) throws IOException, SQLException {
        if (pkey == null) {
            return null;
        }
        if (pkey instanceof Integer) {
            return this.get(((Number)pkey).intValue());
        }
        if (pkey instanceof String) {
            return this.get((String)pkey);
        }
        if (pkey instanceof Table.TableId) {
            return this.get((Table.TableId)((Object)pkey));
        }
        throw new IllegalArgumentException("Must be an Integer, a String, or a SchemaTable.TableId");
    }

    @Override
    public List<Table> getRows() throws IOException, SQLException {
        List<Table> rows = super.getRows();
        int size = rows.size();
        if (size != numTables) {
            throw new SQLException("Unexpected number of rows: expected " + numTables + ", got " + size);
        }
        return rows;
    }

    @Override
    public Table get(int tableId) throws IOException, SQLException {
        return this.getRows().get(tableId);
    }

    public Table get(String name) throws IOException, SQLException {
        return (Table)this.getUniqueRow(1, name);
    }

    public Table get(Table.TableId tableId) throws IOException, SQLException {
        return this.get(tableId.ordinal());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SCHEMA_TABLES;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws SQLException, IOException {
        String command = args[0];
        if (command.equalsIgnoreCase("desc") || command.equalsIgnoreCase("describe")) {
            if (Aosh.checkParamCount("describe", args, 1, (PrintWriter)err)) {
                String tableName = Parser.unquote(args[1]);
                Table table = this.connector.getSchema().getTable().get(tableName);
                if (table != null) {
                    table.printDescription(this.connector, out, isInteractive);
                    out.flush();
                } else {
                    err.print("aosh: describe: table not found: ");
                    err.println(Parser.quote(tableName));
                    err.flush();
                }
            }
            return true;
        }
        if (command.equalsIgnoreCase("select")) {
            int argCount = args.length;
            if (argCount >= 4) {
                if (argCount == 4 && "count(*)".equalsIgnoreCase(args[1])) {
                    this.selectCount(args, out, err, isInteractive);
                } else {
                    this.selectRows(args, out, err, isInteractive);
                }
            } else if (argCount < 4) {
                err.println("aosh: select: not enough parameters");
                err.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("show")) {
            int argCount = args.length;
            if (argCount >= 2) {
                if ("tables".equalsIgnoreCase(args[1])) {
                    this.handleCommand(new String[]{"select", "name,", "description", "from", "schema_tables"}, in, out, err, isInteractive);
                } else {
                    err.println("aosh: show: unknown parameter: " + args[1]);
                    err.flush();
                }
            } else {
                err.println("aosh: show: not enough parameters");
                err.flush();
            }
            return true;
        }
        return false;
    }

    private void selectCount(String[] args, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IOException, SQLException {
        if ("from".equalsIgnoreCase(args[2])) {
            String tableName = Parser.unquote(args[3]);
            Table table = this.connector.getSchema().getTable().get(tableName);
            if (table != null) {
                SQLUtility.printTable((Object[])new String[]{"count"}, Collections.singleton(new Object[]{table.getAoservTable(this.connector).size()}), (Appendable)out, (boolean)isInteractive, (boolean[])new boolean[]{true});
                out.flush();
            } else {
                err.println("aosh: select: table not found: " + Parser.quote(tableName));
                err.flush();
            }
        } else {
            err.println("aosh: select: unknown parameter: " + args[2]);
            err.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void selectRows(String[] args, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IOException, SQLException {
        String arg;
        int c;
        int argCount = args.length;
        ArrayList<String> expressionArgs = new ArrayList<String>();
        for (c = 1; c < argCount && !"from".equalsIgnoreCase(arg = args[c]); ++c) {
            expressionArgs.add(arg);
        }
        if (c >= argCount - 1) {
            err.println("aosh: select: parameter not found: from");
            err.flush();
            return;
        }
        String tableName = Parser.unquote(args[++c]);
        ++c;
        Table schemaTable = this.connector.getSchema().getTable().get(tableName);
        if (schemaTable != null) {
            ArrayList<String> expressions = new ArrayList<String>(expressionArgs.size());
            for (String expressionArg : expressionArgs) {
                if ("*".equals(expressionArg)) {
                    for (Column column : schemaTable.getSchemaColumns(this.connector)) {
                        expressions.add(Parser.quote(column.getName()));
                    }
                    continue;
                }
                do {
                    String current;
                    int commaPos;
                    if ((commaPos = Parser.indexOfNotQuoted(expressionArg, ',')) == -1) {
                        current = expressionArg;
                        expressionArg = "";
                    } else {
                        current = expressionArg.substring(0, commaPos);
                        expressionArg = expressionArg.substring(commaPos + 1);
                    }
                    if ("*".equals(current)) {
                        for (Column column : schemaTable.getSchemaColumns(this.connector)) {
                            expressions.add(Parser.quote(column.getName()));
                        }
                    } else {
                        expressions.add(current);
                    }
                } while (!expressionArg.isEmpty());
            }
            AoservTable<?, AoservObject<?, ?>> aoServTable = schemaTable.getAoservTable(this.connector);
            ArrayList<SqlExpression> orderExpressions = new ArrayList<SqlExpression>();
            ArrayList<Boolean> sortOrders = new ArrayList<Boolean>();
            if (c < argCount) {
                String arg2;
                if (!"order".equalsIgnoreCase(arg2 = args[c++])) throw new SQLException("Parse error: 'order' expected, found '" + arg2 + '\'');
                if (c >= argCount) throw new SQLException("Parse error: 'by' expected");
                if (!"by".equalsIgnoreCase(args[c++])) throw new SQLException("Parse error: 'by' expected");
                while (c < argCount) {
                    String orderBy = args[c++];
                    do {
                        String expr;
                        int commaPos;
                        if ((commaPos = Parser.indexOfNotQuoted(orderBy, ',')) == -1) {
                            expr = orderBy;
                            orderBy = "";
                        } else {
                            expr = orderBy.substring(0, commaPos);
                            orderBy = orderBy.substring(commaPos + 1);
                        }
                        if (!orderExpressions.isEmpty() && ("asc".equalsIgnoreCase(expr) || "ascending".equalsIgnoreCase(expr))) {
                            sortOrders.set(sortOrders.size() - 1, true);
                            continue;
                        }
                        if (!orderExpressions.isEmpty() && ("desc".equalsIgnoreCase(expr) || "descending".equalsIgnoreCase(expr))) {
                            sortOrders.set(sortOrders.size() - 1, false);
                            continue;
                        }
                        orderExpressions.add(Parser.parseSqlExpression(aoServTable, expr));
                        sortOrders.add(true);
                    } while (!orderBy.isEmpty());
                }
                if (orderExpressions.isEmpty()) {
                    throw new SQLException("Parse error: no expressions listed after 'order by'");
                }
            }
            final int numExpressions = expressions.size();
            final SqlExpression[] valueExpressions = new SqlExpression[numExpressions];
            final Type[] valueTypes = new Type[numExpressions];
            int supportsAnyPrecisionCount = 0;
            boolean[] rightAligns = new boolean[numExpressions];
            for (int d = 0; d < numExpressions; ++d) {
                SqlExpression sql = Parser.parseSqlExpression(aoServTable, (String)expressions.get(d));
                Type type = sql.getType();
                valueExpressions[d] = sql;
                valueTypes[d] = type;
                if (type.supportsPrecision()) {
                    ++supportsAnyPrecisionCount;
                }
                rightAligns[d] = type.alignRight();
            }
            List<AoservObject<?, ?>> rows = null;
            boolean rowsCopied = false;
            Throwable t0 = null;
            try {
                if (!orderExpressions.isEmpty()) {
                    SqlExpression[] exprs = orderExpressions.toArray(new SqlExpression[orderExpressions.size()]);
                    boolean[] orders = new boolean[exprs.length];
                    for (int d = 0; d < orders.length; ++d) {
                        orders[d] = (Boolean)sortOrders.get(d);
                    }
                    rows = aoServTable.getRowsCopy();
                    rowsCopied = true;
                    this.connector.sort(JavaSort.getInstance(), rows, exprs, orders);
                } else {
                    rows = aoServTable.getRows();
                }
                final List<AoservObject<?, ?>> finalRows = rows;
                final int numRows = rows.size();
                final int[] precisions = new int[numExpressions];
                Arrays.fill(precisions, -1);
                if (supportsAnyPrecisionCount > 0) {
                    int precisionsNotMaxedCount = supportsAnyPrecisionCount;
                    block22: for (AoservObject<?, ?> row : rows) {
                        for (int col = 0; col < numExpressions; ++col) {
                            int precision;
                            Type type = valueTypes[col];
                            if (!type.supportsPrecision()) continue;
                            int maxPrecision = type.getMaxPrecision();
                            int current = precisions[col];
                            if (maxPrecision != -1 && current != -1 && current >= maxPrecision || (precision = type.getPrecision(valueExpressions[col].evaluate(this.connector, row))) == -1 || current != -1 && precision <= current) continue;
                            precisions[col] = precision;
                            if (maxPrecision != -1 && precision >= maxPrecision && --precisionsNotMaxedCount <= 0) break block22;
                        }
                    }
                }
                Object[] cnames = new String[numExpressions];
                for (int d = 0; d < numExpressions; ++d) {
                    cnames[d] = valueExpressions[d].getColumnName();
                }
                try {
                    SQLUtility.printTable((Object[])cnames, () -> new Iterator<String[]>(){
                        private int index = 0;

                        @Override
                        public boolean hasNext() {
                            return this.index < numRows;
                        }

                        @Override
                        public String[] next() throws NoSuchElementException {
                            if (this.index >= numRows) {
                                throw new NoSuchElementException();
                            }
                            try {
                                AoservObject row = (AoservObject)finalRows.get(this.index);
                                String[] strings = new String[numExpressions];
                                for (int col = 0; col < numExpressions; ++col) {
                                    strings[col] = valueTypes[col].getString(valueExpressions[col].evaluate(TableTable.this.connector, row), precisions[col]);
                                }
                                ++this.index;
                                return strings;
                            }
                            catch (IOException | SQLException e) {
                                throw new WrappedException((Throwable)e);
                            }
                        }
                    }, (Appendable)out, (boolean)isInteractive, (boolean[])rightAligns);
                }
                catch (WrappedException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    if (!(cause instanceof SQLException)) throw e;
                    throw (SQLException)cause;
                }
            }
            catch (Throwable t) {
                t0 = Throwables.addSuppressed(t0, (Throwable)t);
            }
            finally {
                if (rowsCopied && rows instanceof AutoCloseable) {
                    try {
                        ((AutoCloseable)((Object)rows)).close();
                    }
                    catch (Throwable t) {
                        t0 = Throwables.addSuppressed((Throwable)t0, (Throwable)t);
                    }
                }
            }
            if (t0 != null) {
                if (t0 instanceof IOException) {
                    throw (IOException)t0;
                }
                if (!(t0 instanceof SQLException)) throw (WrappedException)Throwables.wrap((Throwable)t0, WrappedException.class, WrappedException::new);
                throw (SQLException)t0;
            }
            out.flush();
            return;
        }
        err.println("aosh: select: table not found: " + Parser.quote(tableName));
        err.flush();
    }
}

