/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.schema;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.Strings;
import com.aoapps.lang.i18n.Money;
import com.aoapps.lang.util.InternUtils;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.DomainLabel;
import com.aoapps.net.DomainLabels;
import com.aoapps.net.DomainName;
import com.aoapps.net.Email;
import com.aoapps.net.HostAddress;
import com.aoapps.net.IPortRange;
import com.aoapps.net.InetAddress;
import com.aoapps.net.MacAddress;
import com.aoapps.net.Port;
import com.aoapps.net.Protocol;
import com.aoapps.security.HashedKey;
import com.aoapps.security.HashedPassword;
import com.aoapps.security.Identifier;
import com.aoapps.security.SmallIdentifier;
import com.aoapps.sql.SQLUtility;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.GlobalObjectIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.linux.Group;
import com.aoindustries.aoserv.client.linux.LinuxId;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.mysql.Database;
import com.aoindustries.aoserv.client.mysql.Server;
import com.aoindustries.aoserv.client.mysql.TableName;
import com.aoindustries.aoserv.client.mysql.User;
import com.aoindustries.aoserv.client.net.FirewallZone;
import com.aoindustries.aoserv.client.net.IpAddress;
import com.aoindustries.aoserv.client.postgresql.Database;
import com.aoindustries.aoserv.client.postgresql.Server;
import com.aoindustries.aoserv.client.postgresql.User;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.TimeZone;

public final class Type
extends GlobalObjectIntegerKey<Type> {
    public static final TimeZone DATE_TIME_ZONE = TimeZone.getTimeZone("GMT");
    static final int COLUMN_NAME = 1;
    public static final String DATE_name = "date";
    public static final int ACCOUNTING = 0;
    public static final int BOOLEAN = 1;
    public static final int DATE = 5;
    public static final int DECIMAL_2 = 6;
    public static final int DECIMAL_3 = 7;
    public static final int DOUBLE = 8;
    public static final int EMAIL = 9;
    public static final int FKEY = 10;
    public static final int FLOAT = 11;
    public static final int HOSTNAME = 12;
    public static final int INT = 13;
    public static final int INTERVAL = 14;
    public static final int IP_ADDRESS = 15;
    public static final int LONG = 16;
    public static final int OCTAL_LONG = 18;
    public static final int PKEY = 20;
    public static final int PATH = 21;
    public static final int PHONE = 22;
    public static final int SHORT = 23;
    public static final int STRING = 25;
    public static final int TIME = 26;
    public static final int URL = 27;
    public static final int USERNAME = 28;
    public static final int ZONE = 30;
    public static final int BIG_DECIMAL = 31;
    public static final int DOMAIN_LABEL = 32;
    public static final int DOMAIN_LABELS = 33;
    public static final int DOMAIN_NAME = 34;
    public static final int GECOS = 35;
    public static final int GROUP_ID = 36;
    public static final int HASHED_PASSWORD = 37;
    public static final int LINUX_ID = 38;
    public static final int MAC_ADDRESS = 39;
    public static final int MONEY = 40;
    public static final int MYSQL_DATABASE_NAME = 41;
    public static final int MYSQL_SERVER_NAME = 42;
    public static final int MYSQL_TABLE_NAME = 43;
    public static final int MYSQL_USERNAME = 44;
    public static final int NET_PORT = 45;
    public static final int POSTGRES_DATABASE_NAME = 46;
    public static final int POSTGRES_SERVER_NAME = 47;
    public static final int POSTGRES_USERNAME = 48;
    public static final int FIREWALLD_ZONE_NAME = 49;
    public static final int LINUX_USERNAME = 50;
    public static final int IDENTIFIER = 51;
    public static final int SMALL_IDENTIFIER = 52;
    public static final int HASHED_KEY = 53;
    private static final BigDecimal bigDecimalNegativeOne = BigDecimal.valueOf(-1L);
    private String name;
    private String sinceVersion;
    private String lastVersion;
    public static final long MILLIS_PER_DAY = 86400000L;

    @Deprecated
    public Type() {
    }

    public boolean alignRight() {
        return Type.alignRight(this.pkey);
    }

    public static boolean alignRight(int id) {
        switch (id) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 26: 
            case 31: 
            case 38: 
            case 40: 
            case 45: {
                return true;
            }
        }
        return false;
    }

    public Object cast(AoservConnector conn, Object value, Type castToType) throws IOException, SQLException {
        try {
            if (this.pkey == castToType.pkey) {
                return value;
            }
            if (castToType.pkey == 25) {
                return this.getString(value, this.pkey);
            }
            switch (this.pkey) {
                case 0: {
                    break;
                }
                case 1: {
                    switch (castToType.getId()) {
                        case 6: {
                            return value == null ? null : Integer.valueOf((Boolean)value != false ? -100 : 0);
                        }
                        case 7: {
                            return value == null ? null : Integer.valueOf((Boolean)value != false ? -1000 : 0);
                        }
                        case 8: {
                            return value == null ? null : Double.valueOf((Boolean)value != false ? -1.0 : 0.0);
                        }
                        case 11: {
                            return value == null ? null : Float.valueOf((Boolean)value != false ? -1.0f : 0.0f);
                        }
                        case 13: {
                            return value == null ? null : Integer.valueOf((Boolean)value != false ? -1 : 0);
                        }
                        case 16: 
                        case 18: {
                            return value == null ? null : Long.valueOf((Boolean)value != false ? -1L : 0L);
                        }
                        case 23: {
                            return value == null ? null : Short.valueOf((Boolean)value != false ? (short)-1 : 0);
                        }
                        case 31: {
                            return value == null ? null : ((Boolean)value != false ? bigDecimalNegativeOne : BigDecimal.ZERO);
                        }
                    }
                    break;
                }
                case 5: {
                    long tvalue = value == null ? 0L : ((Date)value).getTime();
                    switch (castToType.getId()) {
                        case 6: {
                            return value == null ? null : Integer.valueOf((int)(Type.getDaysFromMillis(tvalue) * 100L));
                        }
                        case 7: {
                            return value == null ? null : Integer.valueOf((int)(Type.getDaysFromMillis(tvalue) * 1000L));
                        }
                        case 8: {
                            return value == null ? null : Double.valueOf(Type.getDaysFromMillis(tvalue));
                        }
                        case 11: {
                            return value == null ? null : Float.valueOf(Type.getDaysFromMillis(tvalue));
                        }
                        case 13: {
                            return value == null ? null : Integer.valueOf((int)Type.getDaysFromMillis(tvalue));
                        }
                        case 16: 
                        case 18: {
                            return value == null ? null : Long.valueOf(Type.getDaysFromMillis(tvalue));
                        }
                        case 23: {
                            return value == null ? null : Short.valueOf((short)Type.getDaysFromMillis(tvalue));
                        }
                        case 26: {
                            return value == null ? null : new UnmodifiableTimestamp(Type.roundToDate(tvalue));
                        }
                        case 31: {
                            return value == null ? null : BigDecimal.valueOf(Type.getDaysFromMillis(tvalue));
                        }
                    }
                    break;
                }
                case 6: {
                    switch (castToType.getId()) {
                        case 1: {
                            return value == null ? null : Boolean.valueOf((Integer)value != 0);
                        }
                        case 5: {
                            return value == null ? null : new Date(Type.getMillisFromDays((Integer)value / 100));
                        }
                        case 7: {
                            return value == null ? null : Integer.valueOf((Integer)value * 10);
                        }
                        case 8: {
                            return value == null ? null : Double.valueOf((double)((Integer)value).intValue() / 100.0);
                        }
                        case 11: {
                            return value == null ? null : Float.valueOf((float)((Integer)value).intValue() / 100.0f);
                        }
                        case 13: {
                            return value == null ? null : Integer.valueOf((Integer)value / 100);
                        }
                        case 14: {
                            return value == null ? null : Long.valueOf((Integer)value / 100);
                        }
                        case 16: 
                        case 18: {
                            return value == null ? null : Long.valueOf((Integer)value / 100);
                        }
                        case 23: {
                            return value == null ? null : Short.valueOf((short)((Integer)value / 100));
                        }
                        case 31: {
                            return value == null ? null : BigDecimal.valueOf(((Integer)value).intValue(), 2);
                        }
                    }
                    break;
                }
                case 7: {
                    switch (castToType.getId()) {
                        case 1: {
                            return value == null ? null : Boolean.valueOf((Integer)value != 0);
                        }
                        case 5: {
                            return value == null ? null : new Date(Type.getMillisFromDays((Integer)value / 1000));
                        }
                        case 6: {
                            return value == null ? null : Integer.valueOf((Integer)value / 10);
                        }
                        case 8: {
                            return value == null ? null : Double.valueOf((double)((Integer)value).intValue() / 1000.0);
                        }
                        case 11: {
                            return value == null ? null : Float.valueOf((float)((Integer)value).intValue() / 1000.0f);
                        }
                        case 13: {
                            return value == null ? null : Integer.valueOf((Integer)value / 1000);
                        }
                        case 14: {
                            return value == null ? null : Long.valueOf((Integer)value / 1000);
                        }
                        case 16: 
                        case 18: {
                            return value == null ? null : Long.valueOf((Integer)value / 1000);
                        }
                        case 23: {
                            return value == null ? null : Short.valueOf((short)((Integer)value / 1000));
                        }
                        case 31: {
                            return value == null ? null : BigDecimal.valueOf(((Integer)value).intValue(), 3);
                        }
                    }
                    break;
                }
                case 8: {
                    switch (castToType.getId()) {
                        case 1: {
                            return value == null ? null : Boolean.valueOf((Double)value != 0.0);
                        }
                        case 5: {
                            return value == null ? null : new Date(Type.getMillisFromDays(((Double)value).longValue()));
                        }
                        case 6: {
                            return value == null ? null : Integer.valueOf((int)((Double)value * 100.0));
                        }
                        case 7: {
                            return value == null ? null : Integer.valueOf((int)((Double)value * 1000.0));
                        }
                        case 11: {
                            return value == null ? null : Float.valueOf(((Double)value).floatValue());
                        }
                        case 13: {
                            return value == null ? null : Integer.valueOf(((Double)value).intValue());
                        }
                        case 14: {
                            return value == null ? null : Long.valueOf(((Double)value).longValue());
                        }
                        case 16: 
                        case 18: {
                            return value == null ? null : Long.valueOf(((Double)value).longValue());
                        }
                        case 23: {
                            return value == null ? null : Short.valueOf(((Double)value).shortValue());
                        }
                        case 31: {
                            return value == null ? null : BigDecimal.valueOf((Double)value);
                        }
                    }
                    break;
                }
                case 9: {
                    switch (castToType.getId()) {
                        case 12: {
                            return value == null ? null : HostAddress.valueOf((DomainName)((Email)value).getDomain());
                        }
                        case 27: {
                            return value == null ? null : "mailto:" + value;
                        }
                        case 28: {
                            return value == null ? null : User.Name.valueOf(Type.getUsernameForEmail((Email)value));
                        }
                        case 30: {
                            return value == null ? null : Type.getZoneForDomainName(conn, ((Email)value).getDomain());
                        }
                        case 34: {
                            return value == null ? null : ((Email)value).getDomain();
                        }
                        case 50: {
                            return value == null ? null : User.Name.valueOf(Type.getUsernameForEmail((Email)value));
                        }
                    }
                    break;
                }
                case 10: {
                    switch (castToType.getId()) {
                        case 13: 
                        case 20: {
                            return value;
                        }
                    }
                    break;
                }
                case 11: {
                    switch (castToType.getId()) {
                        case 1: {
                            return value == null ? null : Boolean.valueOf(((Float)value).floatValue() != 0.0f);
                        }
                        case 5: {
                            return value == null ? null : new Date(Type.getMillisFromDays(((Float)value).longValue()));
                        }
                        case 6: {
                            return value == null ? null : Integer.valueOf((int)(((Float)value).floatValue() * 100.0f));
                        }
                        case 7: {
                            return value == null ? null : Integer.valueOf((int)(((Float)value).floatValue() * 1000.0f));
                        }
                        case 8: {
                            return value == null ? null : Double.valueOf(((Float)value).doubleValue());
                        }
                        case 13: {
                            return value == null ? null : Integer.valueOf(((Float)value).intValue());
                        }
                        case 14: {
                            return value == null ? null : Long.valueOf(((Float)value).longValue());
                        }
                        case 16: 
                        case 18: {
                            return value == null ? null : Long.valueOf(((Float)value).longValue());
                        }
                        case 23: {
                            return value == null ? null : Short.valueOf(((Float)value).shortValue());
                        }
                        case 31: {
                            return value == null ? null : BigDecimal.valueOf(((Float)value).doubleValue());
                        }
                    }
                    break;
                }
                case 12: {
                    switch (castToType.getId()) {
                        case 15: {
                            return value == null ? null : ((HostAddress)value).getInetAddress();
                        }
                        case 30: {
                            return value == null ? null : Type.getZoneForDomainName(conn, ((HostAddress)value).getDomainName());
                        }
                        case 34: {
                            return value == null ? null : ((HostAddress)value).getDomainName();
                        }
                    }
                    break;
                }
                case 13: {
                    switch (castToType.getId()) {
                        case 1: {
                            return value == null ? null : Boolean.valueOf((Integer)value != 0);
                        }
                        case 5: {
                            return value == null ? null : new Date(Type.getMillisFromDays(((Integer)value).intValue()));
                        }
                        case 6: {
                            return value == null ? null : Integer.valueOf((Integer)value * 100);
                        }
                        case 7: {
                            return value == null ? null : Integer.valueOf((Integer)value * 1000);
                        }
                        case 8: {
                            return value == null ? null : Double.valueOf(((Integer)value).doubleValue());
                        }
                        case 10: {
                            return value;
                        }
                        case 11: {
                            return value == null ? null : Float.valueOf(((Integer)value).floatValue());
                        }
                        case 14: {
                            return value == null ? null : Long.valueOf(((Integer)value).longValue());
                        }
                        case 15: {
                            return value == null ? null : InetAddress.valueOf((String)IpAddress.getIpAddressForInt((Integer)value));
                        }
                        case 16: 
                        case 18: {
                            return value == null ? null : Long.valueOf(((Integer)value).longValue());
                        }
                        case 20: {
                            return value;
                        }
                        case 23: {
                            return value == null ? null : Short.valueOf(((Integer)value).shortValue());
                        }
                        case 31: {
                            return value == null ? null : BigDecimal.valueOf(((Integer)value).doubleValue());
                        }
                        case 38: {
                            return value == null ? null : LinuxId.valueOf((Integer)value);
                        }
                    }
                    break;
                }
                case 14: {
                    switch (castToType.getId()) {
                        case 6: {
                            return value == null ? null : Integer.valueOf((int)((Long)value * 100L));
                        }
                        case 7: {
                            return value == null ? null : Integer.valueOf((int)((Long)value * 1000L));
                        }
                        case 8: {
                            return value == null ? null : Double.valueOf(((Long)value).doubleValue());
                        }
                        case 11: {
                            return value == null ? null : Float.valueOf(((Long)value).floatValue());
                        }
                        case 13: {
                            return value == null ? null : Integer.valueOf(((Long)value).intValue());
                        }
                        case 16: 
                        case 18: {
                            return value;
                        }
                        case 23: {
                            return value == null ? null : Short.valueOf(((Long)value).shortValue());
                        }
                        case 31: {
                            return value == null ? null : BigDecimal.valueOf((Long)value);
                        }
                    }
                    break;
                }
                case 15: {
                    break;
                }
                case 16: 
                case 18: {
                    switch (castToType.getId()) {
                        case 1: {
                            return value == null ? null : Boolean.valueOf((Long)value != 0L);
                        }
                        case 5: {
                            return value == null ? null : new Date(Type.getMillisFromDays((Long)value));
                        }
                        case 6: {
                            return value == null ? null : Integer.valueOf((int)((Long)value * 100L));
                        }
                        case 7: {
                            return value == null ? null : Integer.valueOf((int)((Long)value * 1000L));
                        }
                        case 8: {
                            return value == null ? null : Double.valueOf(((Long)value).doubleValue());
                        }
                        case 11: {
                            return value == null ? null : Float.valueOf(((Long)value).floatValue());
                        }
                        case 13: {
                            return value == null ? null : Integer.valueOf(((Long)value).intValue());
                        }
                        case 14: {
                            return value;
                        }
                        case 16: 
                        case 18: {
                            return value;
                        }
                        case 23: {
                            return value == null ? null : Short.valueOf(((Long)value).shortValue());
                        }
                        case 26: {
                            return value == null ? null : new UnmodifiableTimestamp(((Long)value).longValue());
                        }
                        case 31: {
                            return value == null ? null : BigDecimal.valueOf((Long)value);
                        }
                        case 52: {
                            return value == null ? null : new SmallIdentifier(((Long)value).longValue());
                        }
                    }
                    break;
                }
                case 20: {
                    switch (castToType.getId()) {
                        case 10: 
                        case 13: {
                            return value;
                        }
                    }
                    break;
                }
                case 21: {
                    break;
                }
                case 22: {
                    switch (castToType.getId()) {
                        case 27: {
                            return value == null ? null : "tel:" + ((String)value).replace(' ', '-');
                        }
                    }
                    break;
                }
                case 23: {
                    switch (castToType.getId()) {
                        case 1: {
                            return value == null ? null : Boolean.valueOf((Short)value != 0);
                        }
                        case 5: {
                            return value == null ? null : new Date(Type.getMillisFromDays(((Short)value).shortValue()));
                        }
                        case 6: {
                            return value == null ? null : Integer.valueOf((Short)value * 100);
                        }
                        case 7: {
                            return value == null ? null : Integer.valueOf((Short)value * 1000);
                        }
                        case 8: {
                            return value == null ? null : Double.valueOf(((Short)value).doubleValue());
                        }
                        case 11: {
                            return value == null ? null : Float.valueOf(((Short)value).floatValue());
                        }
                        case 13: {
                            return value == null ? null : Integer.valueOf(((Short)value).intValue());
                        }
                        case 14: {
                            return value == null ? null : Long.valueOf(((Short)value).longValue());
                        }
                        case 16: 
                        case 18: {
                            return value == null ? null : Long.valueOf(((Short)value).longValue());
                        }
                        case 31: {
                            return value == null ? null : BigDecimal.valueOf(((Short)value).longValue());
                        }
                    }
                    break;
                }
                case 25: {
                    return castToType.parseString((String)value);
                }
                case 26: {
                    long lvalue = value == null ? 0L : ((Timestamp)value).getTime();
                    switch (castToType.getId()) {
                        case 5: {
                            return value == null ? null : new Date(Type.roundToDate(lvalue));
                        }
                        case 16: 
                        case 18: {
                            return value == null ? null : Long.valueOf(lvalue);
                        }
                    }
                    break;
                }
                case 27: {
                    switch (castToType.getId()) {
                        case 12: {
                            return value == null ? null : HostAddress.valueOf((String)new URL((String)value).getHost());
                        }
                        case 21: {
                            return value == null ? null : PosixPath.valueOf(new URL((String)value).getPath());
                        }
                        case 30: {
                            return value == null ? null : Type.getZoneForDomainName(conn, DomainName.valueOf((String)new URL((String)value).getHost()));
                        }
                        case 34: {
                            return value == null ? null : DomainName.valueOf((String)new URL((String)value).getHost());
                        }
                    }
                    break;
                }
                case 28: {
                    switch (castToType.getId()) {
                        case 44: {
                            return value == null ? null : User.Name.valueOf(((User.Name)value).toString());
                        }
                        case 48: {
                            return value == null ? null : User.Name.valueOf(((User.Name)value).toString());
                        }
                        case 50: {
                            return value == null ? null : User.Name.valueOf(((User.Name)value).toString());
                        }
                    }
                    break;
                }
                case 30: {
                    switch (castToType.getId()) {
                        case 12: {
                            String hname = (String)value;
                            while (hname.endsWith(".")) {
                                hname = hname.substring(0, hname.length() - 1);
                            }
                            return HostAddress.valueOf((String)hname);
                        }
                        case 34: {
                            return value == null ? null : Type.getDomainNameForZone((String)value);
                        }
                    }
                    break;
                }
                case 31: {
                    switch (castToType.getId()) {
                        case 1: {
                            return value == null ? null : Boolean.valueOf(((BigDecimal)value).compareTo(BigDecimal.ZERO) != 0);
                        }
                        case 5: {
                            return value == null ? null : new Date(Type.getMillisFromDays(((BigDecimal)value).longValue()));
                        }
                        case 6: {
                            return value == null ? null : Integer.valueOf(((BigDecimal)value).scaleByPowerOfTen(2).intValue());
                        }
                        case 7: {
                            return value == null ? null : Integer.valueOf(((BigDecimal)value).scaleByPowerOfTen(3).intValue());
                        }
                        case 8: {
                            return value == null ? null : Double.valueOf(((BigDecimal)value).doubleValue());
                        }
                        case 11: {
                            return value == null ? null : Float.valueOf(((BigDecimal)value).floatValue());
                        }
                        case 13: {
                            return value == null ? null : Integer.valueOf(((BigDecimal)value).intValue());
                        }
                        case 14: {
                            return value == null ? null : Long.valueOf(((BigDecimal)value).longValue());
                        }
                        case 16: 
                        case 18: {
                            return value == null ? null : Long.valueOf(((BigDecimal)value).longValue());
                        }
                        case 23: {
                            return value == null ? null : Short.valueOf(((BigDecimal)value).shortValue());
                        }
                        case 52: {
                            return value == null ? null : new SmallIdentifier(((BigDecimal)value).longValue());
                        }
                    }
                    break;
                }
                case 32: {
                    switch (castToType.getId()) {
                        case 33: {
                            return value == null ? null : DomainLabels.valueOf((String)((DomainLabel)value).toString());
                        }
                        case 34: {
                            return value == null ? null : DomainName.valueOf((String)((DomainLabel)value).toString());
                        }
                    }
                    break;
                }
                case 33: {
                    switch (castToType.getId()) {
                        case 34: {
                            return DomainName.valueOf((String)((DomainLabels)value).toString());
                        }
                    }
                    break;
                }
                case 34: {
                    switch (castToType.getId()) {
                        case 12: {
                            return HostAddress.valueOf((DomainName)((DomainName)value));
                        }
                        case 30: {
                            return ((DomainName)value).toString() + '.';
                        }
                        case 33: {
                            return DomainLabels.valueOf((String)((DomainName)value).toString());
                        }
                    }
                    break;
                }
                case 35: {
                    break;
                }
                case 36: {
                    break;
                }
                case 37: {
                    break;
                }
                case 38: {
                    switch (castToType.getId()) {
                        case 1: {
                            return value == null ? null : Boolean.valueOf(((LinuxId)value).getId() != 0);
                        }
                        case 13: {
                            return value == null ? null : Integer.valueOf(((LinuxId)value).getId());
                        }
                    }
                    break;
                }
                case 39: {
                    break;
                }
                case 40: {
                    switch (castToType.getId()) {
                        case 31: {
                            return value == null ? null : ((Money)value).getValue();
                        }
                    }
                    break;
                }
                case 41: {
                    break;
                }
                case 42: {
                    break;
                }
                case 43: {
                    break;
                }
                case 44: {
                    switch (castToType.getId()) {
                        case 28: {
                            return value == null ? null : User.Name.valueOf(((User.Name)value).toString());
                        }
                        case 50: {
                            return value == null ? null : User.Name.valueOf(((User.Name)value).toString());
                        }
                    }
                    break;
                }
                case 45: {
                    switch (castToType.getId()) {
                        case 13: {
                            return value == null ? null : Integer.valueOf(((Port)value).getPort());
                        }
                    }
                    break;
                }
                case 46: {
                    break;
                }
                case 47: {
                    break;
                }
                case 48: {
                    switch (castToType.getId()) {
                        case 28: {
                            return value == null ? null : User.Name.valueOf(((User.Name)value).toString());
                        }
                        case 50: {
                            return value == null ? null : User.Name.valueOf(((User.Name)value).toString());
                        }
                    }
                    break;
                }
                case 49: {
                    break;
                }
                case 50: {
                    switch (castToType.getId()) {
                        case 28: {
                            return value == null ? null : User.Name.valueOf(((User.Name)value).toString());
                        }
                        case 44: {
                            return value == null ? null : User.Name.valueOf(((User.Name)value).toString());
                        }
                        case 48: {
                            return value == null ? null : User.Name.valueOf(((User.Name)value).toString());
                        }
                    }
                    break;
                }
                case 51: {
                    switch (castToType.getId()) {
                        case 31: {
                            if (value == null) {
                                return null;
                            }
                            Identifier identifier = (Identifier)value;
                            String hexHi = Long.toHexString(identifier.getHi());
                            String hexLo = Long.toHexString(identifier.getLo());
                            int combinedLen = hexHi.length() + 32;
                            StringBuilder combined = new StringBuilder(combinedLen);
                            combined.append(hexHi);
                            while (combined.length() < combinedLen - hexLo.length()) {
                                combined.append('0');
                            }
                            combined.append(hexLo);
                            assert (combined.length() == combinedLen);
                            return new BigDecimal(new BigInteger(combined.toString(), 16));
                        }
                    }
                    break;
                }
                case 52: {
                    switch (castToType.getId()) {
                        case 16: 
                        case 18: {
                            return value == null ? null : Long.valueOf(((SmallIdentifier)value).getValue());
                        }
                        case 31: {
                            return value == null ? null : new BigDecimal(new BigInteger(Long.toHexString(((SmallIdentifier)value).getValue()), 16));
                        }
                    }
                    break;
                }
                case 53: {
                    break;
                }
            }
            throw new IllegalArgumentException("Unable to cast from " + this.name + " to " + castToType.getName());
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage(), e);
        }
    }

    public static long getDaysFromMillis(long time) {
        long days = time / 86400000L;
        long remainder = time % 86400000L;
        return remainder < 0L ? days - 1L : days;
    }

    public static long getMillisFromDays(long days) {
        return days * 86400000L;
    }

    public static long roundToDate(long time) {
        return Type.getMillisFromDays(Type.getDaysFromMillis(time));
    }

    private static DomainName getDomainNameForZone(String zone) throws ValidationException {
        while (zone.endsWith(".")) {
            zone = zone.substring(0, zone.length() - 1);
        }
        return DomainName.valueOf((String)zone);
    }

    private static String getUsernameForEmail(Email email) {
        String localPart = email.getLocalPart();
        int plusPos = localPart.indexOf(43, 1);
        if (plusPos == -1) {
            return localPart;
        }
        return localPart.substring(0, plusPos);
    }

    private static String getZoneForDomainName(AoservConnector conn, DomainName domainName) throws IOException, IllegalArgumentException, SQLException {
        if (domainName == null) {
            return null;
        }
        return conn.getDns().getZone().getHostTld(domainName) + ".";
    }

    public int compareTo(Object value1, Object value2) throws IllegalArgumentException, SQLException, UnknownHostException {
        return Type.compareTo(value1, value2, this.pkey);
    }

    public static int compareTo(Object value1, Object value2, int id) throws IllegalArgumentException {
        if (value1 == null) {
            return value2 == null ? 0 : -1;
        }
        if (value2 == null) {
            return 1;
        }
        switch (id) {
            case 0: {
                return ((Account.Name)value1).compareTo((Account.Name)value2);
            }
            case 22: 
            case 25: 
            case 27: {
                return Strings.compareToIgnoreCaseCarefulEquals((String)((String)value1), (String)((String)value2));
            }
            case 28: {
                return ((User.Name)value1).compareTo((User.Name)value2);
            }
            case 21: {
                return ((PosixPath)value1).compareTo((PosixPath)value2);
            }
            case 1: {
                return ((Boolean)value1).compareTo((Boolean)value2);
            }
            case 5: {
                return Long.compare(Type.getDaysFromMillis(((Date)value1).getTime()), Type.getDaysFromMillis(((Date)value2).getTime()));
            }
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 20: {
                return ((Integer)value1).compareTo((Integer)value2);
            }
            case 8: {
                return ((Double)value1).compareTo((Double)value2);
            }
            case 9: {
                return ((Email)value1).compareTo((Email)value2);
            }
            case 11: {
                return ((Float)value1).compareTo((Float)value2);
            }
            case 12: {
                return ((HostAddress)value1).compareTo((HostAddress)value2);
            }
            case 30: {
                return DomainName.compareLabels((String)((String)value1), (String)((String)value2));
            }
            case 14: 
            case 16: 
            case 18: {
                return ((Long)value1).compareTo((Long)value2);
            }
            case 15: {
                return ((InetAddress)value1).compareTo((InetAddress)value2);
            }
            case 23: {
                return ((Short)value1).compareTo((Short)value2);
            }
            case 26: {
                return ((Timestamp)value1).compareTo((Timestamp)value2);
            }
            case 31: {
                return ((BigDecimal)value1).compareTo((BigDecimal)value2);
            }
            case 32: {
                return ((DomainLabel)value1).compareTo((DomainLabel)value2);
            }
            case 33: {
                return ((DomainLabels)value1).compareTo((DomainLabels)value2);
            }
            case 34: {
                return ((DomainName)value1).compareTo((DomainName)value2);
            }
            case 35: {
                return ((User.Gecos)value1).compareTo((User.Gecos)value2);
            }
            case 36: {
                return ((Group.Name)value1).compareTo((Group.Name)value2);
            }
            case 37: {
                return ((HashedPassword)value1).toString().compareTo(((HashedPassword)value2).toString());
            }
            case 38: {
                return ((LinuxId)value1).compareTo((LinuxId)value2);
            }
            case 39: {
                return ((MacAddress)value1).compareTo((MacAddress)value2);
            }
            case 40: {
                return ((Money)value1).compareTo((Money)value2);
            }
            case 41: {
                return ((Database.Name)value1).compareTo((Database.Name)value2);
            }
            case 42: {
                return ((Server.Name)value1).compareTo((Server.Name)value2);
            }
            case 43: {
                return ((TableName)value1).compareTo((TableName)value2);
            }
            case 44: {
                return ((User.Name)value1).compareTo((User.Name)value2);
            }
            case 45: {
                return ((Port)value1).compareTo((IPortRange)((Port)value2));
            }
            case 46: {
                return ((Database.Name)value1).compareTo((Database.Name)value2);
            }
            case 47: {
                return ((Server.Name)value1).compareTo((Server.Name)value2);
            }
            case 48: {
                return ((User.Name)value1).compareTo((User.Name)value2);
            }
            case 49: {
                return ((FirewallZone.Name)value1).compareTo((FirewallZone.Name)value2);
            }
            case 50: {
                return ((User.Name)value1).compareTo((User.Name)value2);
            }
            case 51: {
                return ((Identifier)value1).compareTo((Identifier)value2);
            }
            case 52: {
                return ((SmallIdentifier)value1).compareTo((SmallIdentifier)value2);
            }
            case 53: {
                return ((HashedKey)value1).compareTo((HashedKey)value2);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + id);
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.sinceVersion;
            }
            case 3: {
                return this.lastVersion;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getId() {
        return this.pkey;
    }

    public String getName() {
        return this.name;
    }

    public String getSinceVersion_version() {
        return this.sinceVersion;
    }

    public AoservProtocol getSinceVersion(AoservConnector connector) throws SQLException, IOException {
        AoservProtocol obj = connector.getSchema().getAoservProtocol().get(this.sinceVersion);
        if (obj == null) {
            throw new SQLException("Unable to find AoservProtocol: " + this.sinceVersion);
        }
        return obj;
    }

    public String getLastVersion_version() {
        return this.lastVersion;
    }

    public AoservProtocol getLastVersion(AoservConnector connector) throws SQLException, IOException {
        if (this.lastVersion == null) {
            return null;
        }
        AoservProtocol obj = connector.getSchema().getAoservProtocol().get(this.lastVersion);
        if (obj == null) {
            throw new SQLException("Unable to find AoservProtocol: " + this.lastVersion);
        }
        return obj;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SCHEMA_TYPES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        int pos = 1;
        this.pkey = result.getInt(pos++);
        this.name = result.getString(pos++);
        this.sinceVersion = result.getString(pos++);
        this.lastVersion = result.getString(pos++);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.name = in.readUTF().intern();
        this.sinceVersion = in.readUTF().intern();
        this.lastVersion = InternUtils.intern((String)in.readNullUTF());
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_17) <= 0) {
            out.writeUTF(this.name);
            out.writeCompressedInt(this.pkey);
        } else {
            out.writeCompressedInt(this.pkey);
            out.writeUTF(this.name);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_69) >= 0) {
            out.writeUTF(this.sinceVersion);
            out.writeNullUTF(this.lastVersion);
        }
    }

    @Override
    public String toStringImpl() {
        return this.name;
    }

    public boolean supportsPrecision() {
        return Type.supportsPrecision(this.pkey);
    }

    public static boolean supportsPrecision(int type) {
        return type == 26;
    }

    public int getMaxPrecision() {
        return Type.getMaxPrecision(this.pkey);
    }

    public static int getMaxPrecision(int type) {
        switch (type) {
            case 26: {
                return 29;
            }
        }
        return -1;
    }

    public int getPrecision(Object value) {
        return Type.getPrecision(value, this.pkey);
    }

    public static int getPrecision(Object value, int type) {
        if (value == null) {
            return -1;
        }
        switch (type) {
            case 26: {
                int nanos = ((Timestamp)value).getNanos();
                if (nanos == 0) {
                    return 19;
                }
                if (nanos % 1000000 == 0) {
                    return 23;
                }
                if (nanos % 1000 == 0) {
                    return 26;
                }
                return 29;
            }
        }
        return -1;
    }

    public String getString(Object value, int precision) {
        return Type.getString(value, precision, this.pkey);
    }

    public static String getString(Object value, int precision, int type) throws IllegalArgumentException {
        if (value == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return ((Account.Name)value).toString();
            }
            case 1: {
                return ((Boolean)value).toString();
            }
            case 5: {
                return SQLUtility.formatDate((java.util.Date)((Date)value), (TimeZone)DATE_TIME_ZONE);
            }
            case 6: {
                return SQLUtility.formatDecimal2((int)((Integer)value));
            }
            case 7: {
                return SQLUtility.formatDecimal3((int)((Integer)value));
            }
            case 8: {
                return ((Double)value).toString();
            }
            case 9: {
                return ((Email)value).toString();
            }
            case 10: {
                return ((Integer)value).toString();
            }
            case 11: {
                return ((Float)value).toString();
            }
            case 12: {
                return ((HostAddress)value).toString();
            }
            case 13: {
                return ((Integer)value).toString();
            }
            case 14: {
                return Strings.getDecimalTimeLengthString((long)((Long)value));
            }
            case 15: {
                return ((InetAddress)value).toString();
            }
            case 16: {
                return ((Long)value).toString();
            }
            case 18: {
                return Long.toOctalString((Long)value);
            }
            case 21: {
                return ((PosixPath)value).toString();
            }
            case 22: {
                return (String)value;
            }
            case 20: {
                return ((Integer)value).toString();
            }
            case 23: {
                return ((Short)value).toString();
            }
            case 25: {
                return (String)value;
            }
            case 26: {
                int endDigits;
                String end;
                Timestamp ts = (Timestamp)value;
                String seconds = SQLUtility.formatDateTime((java.util.Date)ts);
                int nanos = ts.getNanos();
                if (precision == 19 || precision == -1 && nanos == 0) {
                    return seconds;
                }
                if (precision == 23 || precision == -1 && nanos % 1000000 == 0) {
                    end = Integer.toString(nanos / 1000000);
                    endDigits = 3;
                } else if (precision == 26 || precision == -1 && nanos % 1000 == 0) {
                    end = Integer.toString(nanos / 1000);
                    endDigits = 6;
                } else if (precision == -1 || precision == 29) {
                    end = Integer.toString(nanos);
                    endDigits = 9;
                } else {
                    throw new IllegalArgumentException("Expected precision in (-1, 19, 23, 26, 29), got: " + precision);
                }
                int slen = seconds.length();
                StringBuilder formatted = new StringBuilder(slen + 1 + endDigits);
                formatted.append(seconds).append('.');
                while (formatted.length() + end.length() < slen + 1 + endDigits) {
                    formatted.append('0');
                }
                formatted.append(end);
                assert (formatted.length() == slen + 1 + endDigits);
                return formatted.toString();
            }
            case 27: {
                return (String)value;
            }
            case 28: {
                return ((User.Name)value).toString();
            }
            case 30: {
                return (String)value;
            }
            case 31: {
                return ((BigDecimal)value).toString();
            }
            case 32: {
                return ((DomainLabel)value).toString();
            }
            case 33: {
                return ((DomainLabels)value).toString();
            }
            case 34: {
                return ((DomainName)value).toString();
            }
            case 35: {
                return ((User.Gecos)value).toString();
            }
            case 36: {
                return ((Group.Name)value).toString();
            }
            case 37: {
                return ((HashedPassword)value).toString();
            }
            case 38: {
                return ((LinuxId)value).toString();
            }
            case 39: {
                return ((MacAddress)value).toString();
            }
            case 40: {
                return ((Money)value).toString();
            }
            case 41: {
                return ((Database.Name)value).toString();
            }
            case 42: {
                return ((Server.Name)value).toString();
            }
            case 43: {
                return ((TableName)value).toString();
            }
            case 44: {
                return ((User.Name)value).toString();
            }
            case 45: {
                return ((Port)value).toString();
            }
            case 46: {
                return ((Database.Name)value).toString();
            }
            case 47: {
                return ((Server.Name)value).toString();
            }
            case 48: {
                return ((User.Name)value).toString();
            }
            case 49: {
                return ((FirewallZone.Name)value).toString();
            }
            case 50: {
                return ((User.Name)value).toString();
            }
            case 51: {
                return ((Identifier)value).toString();
            }
            case 52: {
                return ((SmallIdentifier)value).toString();
            }
            case 53: {
                return ((HashedKey)value).toString();
            }
        }
        throw new IllegalArgumentException("Unknown SchemaType: " + type);
    }

    public Object parseString(String s) throws IllegalArgumentException {
        return Type.parseString(s, this.pkey);
    }

    public static Object parseString(String s, int id) throws IllegalArgumentException {
        try {
            if (s == null) {
                return null;
            }
            switch (id) {
                case 0: {
                    return Account.Name.valueOf(s);
                }
                case 9: {
                    return Email.valueOf((String)s);
                }
                case 22: 
                case 25: 
                case 27: 
                case 30: {
                    return s;
                }
                case 28: {
                    return User.Name.valueOf(s);
                }
                case 21: {
                    return PosixPath.valueOf(s);
                }
                case 12: {
                    return HostAddress.valueOf((String)s);
                }
                case 15: {
                    return InetAddress.valueOf((String)s);
                }
                case 1: {
                    if ("y".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s) || "t".equalsIgnoreCase(s) || "true".equalsIgnoreCase(s)) {
                        return Boolean.TRUE;
                    }
                    if ("n".equalsIgnoreCase(s) || "no".equalsIgnoreCase(s) || "f".equalsIgnoreCase(s) || "false".equalsIgnoreCase(s)) {
                        return Boolean.FALSE;
                    }
                    throw new IllegalArgumentException("Unable to parse boolean: " + s);
                }
                case 5: {
                    return SQLUtility.parseDate((String)s, (TimeZone)DATE_TIME_ZONE);
                }
                case 6: {
                    return SQLUtility.parseDecimal2((String)s);
                }
                case 7: {
                    return SQLUtility.parseDecimal3((String)s);
                }
                case 8: {
                    return Double.parseDouble(s);
                }
                case 10: 
                case 13: 
                case 20: {
                    return Integer.parseInt(s);
                }
                case 11: {
                    return Float.valueOf(s);
                }
                case 14: {
                    throw new UnsupportedOperationException("Interval parsing not yet supported");
                }
                case 16: {
                    return Long.valueOf(s);
                }
                case 18: {
                    return Long.parseLong(s, 8);
                }
                case 23: {
                    return Short.valueOf(s);
                }
                case 26: {
                    return SQLUtility.parseDateTime((String)s);
                }
                case 31: {
                    return new BigDecimal(s);
                }
                case 32: {
                    return DomainLabel.valueOf((String)s);
                }
                case 33: {
                    return DomainLabels.valueOf((String)s);
                }
                case 34: {
                    return DomainName.valueOf((String)s);
                }
                case 35: {
                    return User.Gecos.valueOf(s);
                }
                case 36: {
                    return Group.Name.valueOf(s);
                }
                case 37: {
                    return HashedPassword.valueOf((String)s);
                }
                case 38: {
                    return LinuxId.valueOf(Integer.parseInt(s));
                }
                case 39: {
                    return MacAddress.valueOf((String)s);
                }
                case 40: {
                    throw new IllegalArgumentException("Parsing from String to Money is not supported.");
                }
                case 41: {
                    return Database.Name.valueOf(s);
                }
                case 42: {
                    return Server.Name.valueOf(s);
                }
                case 43: {
                    return TableName.valueOf(s);
                }
                case 44: {
                    return User.Name.valueOf(s);
                }
                case 45: {
                    int slashPos = s.indexOf(47);
                    if (slashPos == -1) {
                        throw new IllegalArgumentException("Slash (/) not found for Port: " + s);
                    }
                    return Port.valueOf((int)Integer.parseInt(s.substring(0, slashPos)), (Protocol)Protocol.valueOf((String)s.substring(slashPos + 1).toUpperCase(Locale.ROOT)));
                }
                case 46: {
                    return Database.Name.valueOf(s);
                }
                case 47: {
                    return Server.Name.valueOf(s);
                }
                case 48: {
                    return User.Name.valueOf(s);
                }
                case 49: {
                    return FirewallZone.Name.valueOf(s);
                }
                case 50: {
                    return User.Name.valueOf(s);
                }
                case 51: {
                    return new Identifier(s);
                }
                case 52: {
                    return new Identifier(s);
                }
                case 53: {
                    return HashedKey.valueOf((String)s);
                }
            }
            throw new IllegalArgumentException("Unknown SchemaType: " + id);
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage(), e);
        }
    }
}

