/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.scm;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Disablable;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.DisableLog;
import com.aoindustries.aoserv.client.linux.GroupServer;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;

public final class CvsRepository
extends CachedObjectIntegerKey<CvsRepository>
implements Removable,
Disablable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_LINUX_SERVER_ACCOUNT = 2;
    static final String COLUMN_LINUX_SERVER_ACCOUNT_name = "linux_server_account";
    static final String COLUMN_PATH_name = "path";
    public static final PosixPath DEFAULT_CVS_DIRECTORY;
    public static final long DEFAULT_MODE = 1528L;
    private PosixPath path;
    private int linuxServerAccount;
    private int linuxServerGroup;
    private long mode;
    private UnmodifiableTimestamp created;
    private int disableLog;

    public static long[] getValidModes() {
        return new long[]{448L, 488L, 504L, 493L, 509L, 1528L, 2040L};
    }

    public static boolean isValidPath(PosixPath path) {
        if (path == null) {
            return false;
        }
        String pathStr = path.toString();
        int len = pathStr.length();
        for (int c = 1; c < len; ++c) {
            char ch = pathStr.charAt(c);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '.' || ch == '-' || ch == '/') continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public CvsRepository() {
    }

    @Override
    public boolean canDisable() {
        return this.disableLog == -1;
    }

    @Override
    public boolean canEnable() throws SQLException, IOException {
        DisableLog dl = this.getDisableLog();
        if (dl == null) {
            return false;
        }
        return dl.canEnable() && !this.getLinuxServerAccount().isDisabled();
    }

    @Override
    public void disable(DisableLog dl) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.DISABLE, new Object[]{Table.TableId.CVS_REPOSITORIES, dl.getPkey(), this.pkey});
    }

    @Override
    public void enable() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.ENABLE, new Object[]{Table.TableId.CVS_REPOSITORIES, this.pkey});
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.path;
            }
            case 2: {
                return this.linuxServerAccount;
            }
            case 3: {
                return this.linuxServerGroup;
            }
            case 4: {
                return this.mode;
            }
            case 5: {
                return this.created;
            }
            case 6: {
                return this.disableLog == -1 ? null : Integer.valueOf(this.disableLog);
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public boolean isDisabled() {
        return this.disableLog != -1;
    }

    @Override
    public DisableLog getDisableLog() throws SQLException, IOException {
        if (this.disableLog == -1) {
            return null;
        }
        DisableLog obj = this.table.getConnector().getAccount().getDisableLog().get(this.disableLog);
        if (obj == null) {
            throw new SQLException("Unable to find DisableLog: " + this.disableLog);
        }
        return obj;
    }

    public PosixPath getPath() {
        return this.path;
    }

    public int getLinuxServerAccount_pkey() {
        return this.linuxServerAccount;
    }

    public UserServer getLinuxServerAccount() throws SQLException, IOException {
        UserServer lsa = this.table.getConnector().getLinux().getUserServer().get(this.linuxServerAccount);
        if (lsa == null) {
            throw new SQLException("Unable to find LinuxServerAccount: " + this.linuxServerAccount);
        }
        return lsa;
    }

    public int getLinuxServerGroup_pkey() {
        return this.linuxServerGroup;
    }

    public GroupServer getLinuxServerGroup() throws SQLException, IOException {
        GroupServer lsg = this.table.getConnector().getLinux().getGroupServer().get(this.linuxServerGroup);
        if (lsg == null) {
            throw new SQLException("Unable to find LinuxServerGroup: " + this.linuxServerGroup);
        }
        return lsg;
    }

    public long getMode() {
        return this.mode;
    }

    public UnmodifiableTimestamp getCreated() {
        return this.created;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.CVS_REPOSITORIES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.path = PosixPath.valueOf(result.getString(2));
            this.linuxServerAccount = result.getInt(3);
            this.linuxServerGroup = result.getInt(4);
            this.mode = result.getLong(5);
            this.created = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(6));
            this.disableLog = result.getInt(7);
            if (result.wasNull()) {
                this.disableLog = -1;
            }
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.path = PosixPath.valueOf(in.readUTF());
            this.linuxServerAccount = in.readCompressedInt();
            this.linuxServerGroup = in.readCompressedInt();
            this.mode = in.readLong();
            this.created = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.disableLog = in.readCompressedInt();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() {
        return Collections.emptyList();
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.CVS_REPOSITORIES, this.pkey});
    }

    public void setMode(long mode) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_CVS_REPOSITORY_MODE, this.pkey, mode);
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.path.toString());
        out.writeCompressedInt(this.linuxServerAccount);
        out.writeCompressedInt(this.linuxServerGroup);
        out.writeLong(this.mode);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.created.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.created, (DataOutputStream)out);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeShort(0);
            out.writeShort(7);
        }
        out.writeCompressedInt(this.disableLog);
    }

    static {
        try {
            DEFAULT_CVS_DIRECTORY = PosixPath.valueOf("/var/cvs").intern();
        }
        catch (ValidationException e) {
            throw new AssertionError("These hard-coded values are valid", e);
        }
    }
}

