/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.scm;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.linux.GroupServer;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.scm.CvsRepository;
import com.aoindustries.aoserv.client.web.Site;
import com.aoindustries.aoserv.client.web.tomcat.SharedTomcat;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public final class CvsRepositoryTable
extends CachedTableIntegerKey<CvsRepository> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("linux_server_account.ao_server.hostname", true), new AoservTable.OrderBy("path", true)};

    CvsRepositoryTable(AoservConnector connector) {
        super(connector, CvsRepository.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public int addCvsRepository(Server ao, PosixPath path, UserServer lsa, GroupServer lsg, long mode) throws IOException, SQLException {
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.CVS_REPOSITORIES, ao.getPkey(), path, lsa.getPkey(), lsg.getPkey(), mode});
    }

    @Override
    public CvsRepository get(int pkey) throws IOException, SQLException {
        return (CvsRepository)this.getUniqueRow(0, pkey);
    }

    public CvsRepository getCvsRepository(Server aoServer, PosixPath path) throws IOException, SQLException {
        int aoPkey = aoServer.getPkey();
        List cached = this.getRows();
        int size = cached.size();
        for (int c = 0; c < size; ++c) {
            CvsRepository cr = (CvsRepository)cached.get(c);
            if (!cr.getPath().equals(path) || cr.getLinuxServerAccount().getAoServer_server_id() != aoPkey) continue;
            return cr;
        }
        return null;
    }

    public List<CvsRepository> getCvsRepositories(Server aoServer) throws IOException, SQLException {
        int aoPkey = aoServer.getPkey();
        List cached = this.getRows();
        int size = cached.size();
        ArrayList<CvsRepository> matches = new ArrayList<CvsRepository>(size);
        for (int c = 0; c < size; ++c) {
            CvsRepository cr = (CvsRepository)cached.get(c);
            if (cr.getLinuxServerAccount().getAoServer_server_id() != aoPkey) continue;
            matches.add(cr);
        }
        return matches;
    }

    public List<CvsRepository> getCvsRepositories(Package pk) throws IOException, SQLException {
        Account.Name pkname = pk.getName();
        List cached = this.getRows();
        int size = cached.size();
        ArrayList<CvsRepository> matches = new ArrayList<CvsRepository>(size);
        for (int c = 0; c < size; ++c) {
            CvsRepository cr = (CvsRepository)cached.get(c);
            if (!cr.getLinuxServerAccount().getLinuxAccount().getUsername().getPackage_name().equals(pkname)) continue;
            matches.add(cr);
        }
        return matches;
    }

    public List<CvsRepository> getCvsRepositories(UserServer lsa) throws IOException, SQLException {
        return this.getIndexedRows(2, lsa.getPkey());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.CVS_REPOSITORIES;
    }

    public SortedSet<PosixPath> getValidPrefixes() throws IOException, SQLException {
        try {
            TreeSet<PosixPath> prefixes = new TreeSet<PosixPath>();
            for (UserServer lsa : this.connector.getLinux().getUserServer().getRows()) {
                if (!lsa.getLinuxAccount().getType().getName().equals("user") || lsa.isDisabled()) continue;
                prefixes.add(lsa.getHome());
            }
            for (Site site : this.connector.getWeb().getSite().getRows()) {
                if (site.isDisabled()) continue;
                prefixes.add(site.getInstallDirectory());
            }
            for (SharedTomcat tomcat : this.connector.getWeb_tomcat().getSharedTomcat().getRows()) {
                if (tomcat.isDisabled()) continue;
                prefixes.add(PosixPath.valueOf(tomcat.getLinuxServer().getHost().getOperatingSystemVersion().getHttpdSharedTomcatsDirectory().toString() + '/' + tomcat.getName()));
            }
            prefixes.add(CvsRepository.DEFAULT_CVS_DIRECTORY);
            return prefixes;
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_cvs_repository")) {
            if (Aosh.checkParamCount("add_cvs_repository", args, 5, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addCvsRepository(args[1], Aosh.parseUnixPath(args[2], "path"), Aosh.parseLinuxUserName(args[3], "username"), Aosh.parseGroupName(args[4], "group"), Aosh.parseOctalLong(args[5], "mode")));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("disable_cvs_repository")) {
            if (Aosh.checkParamCount("disable_cvs_repository", args, 2, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().disableCvsRepository(Aosh.parseInt(args[1], "pkey"), args[2]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("enable_cvs_repository")) {
            if (Aosh.checkParamCount("enable_cvs_repository", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().enableCvsRepository(Aosh.parseInt(args[1], "pkey"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_cvs_repository")) {
            if (Aosh.checkParamCount("add_cvs_repository", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeCvsRepository(args[1], Aosh.parseUnixPath(args[2], "path"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_cvs_repository_mode")) {
            if (Aosh.checkParamCount("set_cvs_repository_mode", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setCvsRepositoryMode(args[1], Aosh.parseUnixPath(args[2], "path"), Aosh.parseOctalLong(args[3], "mode"));
            }
            return true;
        }
        return false;
    }
}

