/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.signup;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.Strings;
import com.aoapps.lang.util.InternUtils;
import com.aoapps.lang.util.Internable;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.Email;
import com.aoapps.net.InetAddress;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.billing.PackageDefinition;
import com.aoindustries.aoserv.client.pki.EncryptionKey;
import com.aoindustries.aoserv.client.reseller.Brand;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Objects;

public final class Request
extends CachedObjectIntegerKey<Request> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_BRAND = 1;
    static final String COLUMN_BRAND_name = "brand";
    static final String COLUMN_TIME_name = "time";
    private Account.Name brand;
    private UnmodifiableTimestamp time;
    private InetAddress ipAddress;
    private int packageDefinition;
    private String businessName;
    private String businessPhone;
    private String businessFax;
    private String businessAddress1;
    private String businessAddress2;
    private String businessCity;
    private String businessState;
    private String businessCountry;
    private String businessZip;
    private String baName;
    private String baTitle;
    private String baWorkPhone;
    private String baCellPhone;
    private String baHomePhone;
    private String baFax;
    private Email baEmail;
    private String baAddress1;
    private String baAddress2;
    private String baCity;
    private String baState;
    private String baCountry;
    private String baZip;
    private User.Name baUsername;
    private String billingContact;
    private Email billingEmail;
    private boolean billingUseMonthly;
    private boolean billingPayOneYear;
    private String encryptedData;
    private int encryptionFrom;
    private int encryptionRecipient;
    private User.Name completedBy;
    private UnmodifiableTimestamp completedTime;
    private String decryptPassphrase;
    private String baPassword;
    private String billingCardholderName;
    private String billingCardNumber;
    private String billingExpirationMonth;
    private String billingExpirationYear;
    private String billingStreetAddress;
    private String billingCity;
    private String billingState;
    private String billingZip;

    @Deprecated
    public Request() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.brand;
            }
            case 2: {
                return this.time;
            }
            case 3: {
                return this.ipAddress;
            }
            case 4: {
                return this.packageDefinition;
            }
            case 5: {
                return this.businessName;
            }
            case 6: {
                return this.businessPhone;
            }
            case 7: {
                return this.businessFax;
            }
            case 8: {
                return this.businessAddress1;
            }
            case 9: {
                return this.businessAddress2;
            }
            case 10: {
                return this.businessCity;
            }
            case 11: {
                return this.businessState;
            }
            case 12: {
                return this.businessCountry;
            }
            case 13: {
                return this.businessZip;
            }
            case 14: {
                return this.baName;
            }
            case 15: {
                return this.baTitle;
            }
            case 16: {
                return this.baWorkPhone;
            }
            case 17: {
                return this.baCellPhone;
            }
            case 18: {
                return this.baHomePhone;
            }
            case 19: {
                return this.baFax;
            }
            case 20: {
                return this.baEmail;
            }
            case 21: {
                return this.baAddress1;
            }
            case 22: {
                return this.baAddress2;
            }
            case 23: {
                return this.baCity;
            }
            case 24: {
                return this.baState;
            }
            case 25: {
                return this.baCountry;
            }
            case 26: {
                return this.baZip;
            }
            case 27: {
                return this.baUsername;
            }
            case 28: {
                return this.billingContact;
            }
            case 29: {
                return this.billingEmail;
            }
            case 30: {
                return this.billingUseMonthly;
            }
            case 31: {
                return this.billingPayOneYear;
            }
            case 32: {
                return this.encryptedData;
            }
            case 33: {
                return this.encryptionFrom;
            }
            case 34: {
                return this.encryptionRecipient;
            }
            case 35: {
                return this.completedBy;
            }
            case 36: {
                return this.completedTime;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SIGNUP_REQUESTS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.brand = Account.Name.valueOf(result.getString(pos++));
            this.time = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(pos++));
            this.ipAddress = InetAddress.valueOf((String)result.getString(pos++));
            this.packageDefinition = result.getInt(pos++);
            this.businessName = result.getString(pos++);
            this.businessPhone = result.getString(pos++);
            this.businessFax = result.getString(pos++);
            this.businessAddress1 = result.getString(pos++);
            this.businessAddress2 = result.getString(pos++);
            this.businessCity = result.getString(pos++);
            this.businessState = result.getString(pos++);
            this.businessCountry = result.getString(pos++);
            this.businessZip = result.getString(pos++);
            this.baName = result.getString(pos++);
            this.baTitle = result.getString(pos++);
            this.baWorkPhone = result.getString(pos++);
            this.baCellPhone = result.getString(pos++);
            this.baHomePhone = result.getString(pos++);
            this.baFax = result.getString(pos++);
            this.baEmail = Email.valueOf((String)result.getString(pos++));
            this.baAddress1 = result.getString(pos++);
            this.baAddress2 = result.getString(pos++);
            this.baCity = result.getString(pos++);
            this.baState = result.getString(pos++);
            this.baCountry = result.getString(pos++);
            this.baZip = result.getString(pos++);
            this.baUsername = User.Name.valueOf(result.getString(pos++));
            this.billingContact = result.getString(pos++);
            this.billingEmail = Email.valueOf((String)result.getString(pos++));
            this.billingUseMonthly = result.getBoolean(pos++);
            this.billingPayOneYear = result.getBoolean(pos++);
            this.encryptedData = result.getString(pos++);
            this.encryptionFrom = result.getInt(pos++);
            this.encryptionRecipient = result.getInt(pos++);
            this.completedBy = User.Name.valueOf(result.getString(pos++));
            this.completedTime = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(pos++));
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.brand = Account.Name.valueOf(in.readUTF()).intern();
            this.time = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.ipAddress = InetAddress.valueOf((String)in.readUTF());
            this.packageDefinition = in.readCompressedInt();
            this.businessName = in.readUTF();
            this.businessPhone = in.readUTF();
            this.businessFax = in.readNullUTF();
            this.businessAddress1 = in.readUTF();
            this.businessAddress2 = in.readNullUTF();
            this.businessCity = in.readUTF();
            this.businessState = InternUtils.intern((String)in.readNullUTF());
            this.businessCountry = in.readUTF().intern();
            this.businessZip = in.readNullUTF();
            this.baName = in.readUTF();
            this.baTitle = in.readNullUTF();
            this.baWorkPhone = in.readUTF();
            this.baCellPhone = in.readNullUTF();
            this.baHomePhone = in.readNullUTF();
            this.baFax = in.readNullUTF();
            this.baEmail = Email.valueOf((String)in.readUTF());
            this.baAddress1 = in.readNullUTF();
            this.baAddress2 = in.readNullUTF();
            this.baCity = in.readNullUTF();
            this.baState = InternUtils.intern((String)in.readNullUTF());
            this.baCountry = InternUtils.intern((String)in.readNullUTF());
            this.baZip = in.readNullUTF();
            this.baUsername = User.Name.valueOf(in.readUTF()).intern();
            this.billingContact = in.readUTF();
            this.billingEmail = Email.valueOf((String)in.readUTF());
            this.billingUseMonthly = in.readBoolean();
            this.billingPayOneYear = in.readBoolean();
            this.encryptedData = in.readUTF();
            this.encryptionFrom = in.readCompressedInt();
            this.encryptionRecipient = in.readCompressedInt();
            this.completedBy = (User.Name)InternUtils.intern((Internable)User.Name.valueOf(in.readNullUTF()));
            this.completedTime = SQLStreamables.readNullUnmodifiableTimestamp((DataInputStream)in);
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.brand.toString());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.time.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.time, (DataOutputStream)out);
        }
        out.writeUTF(this.ipAddress.toString());
        out.writeCompressedInt(this.packageDefinition);
        out.writeUTF(this.businessName);
        out.writeUTF(this.businessPhone);
        out.writeNullUTF(this.businessFax);
        out.writeUTF(this.businessAddress1);
        out.writeNullUTF(this.businessAddress2);
        out.writeUTF(this.businessCity);
        out.writeNullUTF(this.businessState);
        out.writeUTF(this.businessCountry);
        out.writeNullUTF(this.businessZip);
        out.writeUTF(this.baName);
        out.writeNullUTF(this.baTitle);
        out.writeUTF(this.baWorkPhone);
        out.writeNullUTF(this.baCellPhone);
        out.writeNullUTF(this.baHomePhone);
        out.writeNullUTF(this.baFax);
        out.writeUTF(this.baEmail.toString());
        out.writeNullUTF(this.baAddress1);
        out.writeNullUTF(this.baAddress2);
        out.writeNullUTF(this.baCity);
        out.writeNullUTF(this.baState);
        out.writeNullUTF(this.baCountry);
        out.writeNullUTF(this.baZip);
        out.writeUTF(this.baUsername.toString());
        out.writeUTF(this.billingContact);
        out.writeUTF(this.billingEmail.toString());
        out.writeBoolean(this.billingUseMonthly);
        out.writeBoolean(this.billingPayOneYear);
        out.writeUTF(this.encryptedData);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_31) >= 0) {
            out.writeCompressedInt(this.encryptionFrom);
        }
        out.writeCompressedInt(this.encryptionRecipient);
        out.writeNullUTF(Objects.toString(this.completedBy, null));
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.completedTime == null ? -1L : this.completedTime.getTime());
        } else {
            SQLStreamables.writeNullTimestamp((Timestamp)this.completedTime, (DataOutputStream)out);
        }
    }

    public Brand getBrand() throws SQLException, IOException {
        Brand br = this.table.getConnector().getReseller().getBrand().get(this.brand);
        if (br == null) {
            throw new SQLException("Unable to find Brand: " + this.brand);
        }
        return br;
    }

    public UnmodifiableTimestamp getTime() {
        return this.time;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public PackageDefinition getPackageDefinition() throws SQLException, IOException {
        PackageDefinition pd = this.table.getConnector().getBilling().getPackageDefinition().get(this.packageDefinition);
        if (pd == null) {
            throw new SQLException("Unable to find PackageDefinition: " + this.packageDefinition);
        }
        return pd;
    }

    public String getBusinessName() {
        return this.businessName;
    }

    public String getBusinessPhone() {
        return this.businessPhone;
    }

    public String getBusinessFax() {
        return this.businessFax;
    }

    public String getBusinessAddress1() {
        return this.businessAddress1;
    }

    public String getBusinessAddress2() {
        return this.businessAddress2;
    }

    public String getBusinessCity() {
        return this.businessCity;
    }

    public String getBusinessState() {
        return this.businessState;
    }

    public String getBusinessCountry() {
        return this.businessCountry;
    }

    public String getBusinessZip() {
        return this.businessZip;
    }

    public String getBaName() {
        return this.baName;
    }

    public String getBaTitle() {
        return this.baTitle;
    }

    public String getBaWorkPhone() {
        return this.baWorkPhone;
    }

    public String getBaCellPhone() {
        return this.baCellPhone;
    }

    public String getBaHomePhone() {
        return this.baHomePhone;
    }

    public String getBaFax() {
        return this.baFax;
    }

    public Email getBaEmail() {
        return this.baEmail;
    }

    public String getBaAddress1() {
        return this.baAddress1;
    }

    public String getBaAddress2() {
        return this.baAddress2;
    }

    public String getBaCity() {
        return this.baCity;
    }

    public String getBaState() {
        return this.baState;
    }

    public String getBaCountry() {
        return this.baCountry;
    }

    public String getBaZip() {
        return this.baZip;
    }

    public User.Name getBaUsername() {
        return this.baUsername;
    }

    public String getBillingContact() {
        return this.billingContact;
    }

    public Email getBillingEmail() {
        return this.billingEmail;
    }

    public boolean getBillingUseMonthly() {
        return this.billingUseMonthly;
    }

    public boolean getBillingPayOneYear() {
        return this.billingPayOneYear;
    }

    public EncryptionKey getEncryptionFrom() throws SQLException, IOException {
        EncryptionKey ek = this.table.getConnector().getPki().getEncryptionKey().get(this.encryptionFrom);
        if (ek == null) {
            throw new SQLException("Unable to find EncryptionKey: " + this.encryptionFrom);
        }
        return ek;
    }

    public EncryptionKey getEncryptionRecipient() throws SQLException, IOException {
        EncryptionKey er = this.table.getConnector().getPki().getEncryptionKey().get(this.encryptionRecipient);
        if (er == null) {
            throw new SQLException("Unable to find EncryptionKey: " + this.encryptionRecipient);
        }
        return er;
    }

    public Administrator getCompletedBy() throws IOException, SQLException {
        if (this.completedBy == null) {
            return null;
        }
        return this.table.getConnector().getAccount().getAdministrator().get(this.completedBy);
    }

    public UnmodifiableTimestamp getCompletedTime() {
        return this.completedTime;
    }

    public synchronized String getBaPassword(String passphrase) throws IOException, SQLException {
        this.decrypt(passphrase);
        return this.baPassword;
    }

    public synchronized String getBillingCardholderName(String passphrase) throws IOException, SQLException {
        this.decrypt(passphrase);
        return this.billingCardholderName;
    }

    public synchronized String getBillingCardNumber(String passphrase) throws IOException, SQLException {
        this.decrypt(passphrase);
        return this.billingCardNumber;
    }

    public synchronized String getBillingExpirationMonth(String passphrase) throws IOException, SQLException {
        this.decrypt(passphrase);
        return this.billingExpirationMonth;
    }

    public synchronized String getBillingExpirationYear(String passphrase) throws IOException, SQLException {
        this.decrypt(passphrase);
        return this.billingExpirationYear;
    }

    public synchronized String getBillingStreetAddress(String passphrase) throws IOException, SQLException {
        this.decrypt(passphrase);
        return this.billingStreetAddress;
    }

    public synchronized String getBillingCity(String passphrase) throws IOException, SQLException {
        this.decrypt(passphrase);
        return this.billingCity;
    }

    public synchronized String getBillingState(String passphrase) throws IOException, SQLException {
        this.decrypt(passphrase);
        return this.billingState;
    }

    public synchronized String getBillingZip(String passphrase) throws IOException, SQLException {
        this.decrypt(passphrase);
        return this.billingZip;
    }

    private synchronized void decrypt(String passphrase) throws IOException, SQLException {
        if (this.decryptPassphrase == null || !passphrase.equals(this.decryptPassphrase)) {
            this.decryptPassphrase = null;
            this.baPassword = null;
            this.billingCardholderName = null;
            this.billingCardNumber = null;
            this.billingExpirationMonth = null;
            this.billingExpirationYear = null;
            this.billingStreetAddress = null;
            this.billingCity = null;
            this.billingState = null;
            this.billingZip = null;
            String decrypted = this.getEncryptionRecipient().decrypt(this.encryptedData, passphrase);
            List lines = Strings.splitLines((String)decrypted);
            if (lines.size() != 9) {
                throw new IOException("Unexpected number of lines after decryption: " + lines.size());
            }
            this.baPassword = (String)lines.get(0);
            this.billingCardholderName = (String)lines.get(1);
            this.billingCardNumber = (String)lines.get(2);
            this.billingExpirationMonth = (String)lines.get(3);
            this.billingExpirationYear = (String)lines.get(4);
            this.billingStreetAddress = (String)lines.get(5);
            this.billingCity = (String)lines.get(6);
            this.billingState = (String)lines.get(7);
            this.billingZip = (String)lines.get(8);
            this.decryptPassphrase = passphrase;
        }
    }
}

