/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.signup;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.net.Email;
import com.aoapps.net.InetAddress;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.billing.PackageDefinition;
import com.aoindustries.aoserv.client.payment.CountryCode;
import com.aoindustries.aoserv.client.pki.EncryptionKey;
import com.aoindustries.aoserv.client.reseller.Brand;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.signup.Request;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;

public final class RequestTable
extends CachedTableIntegerKey<Request> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("brand", true), new AoservTable.OrderBy("time", true)};

    RequestTable(AoservConnector connector) {
        super(connector, Request.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public Request get(int pkey) throws IOException, SQLException {
        return (Request)this.getUniqueRow(0, pkey);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.SIGNUP_REQUESTS;
    }

    public int addSignupRequest(final Brand brand, final InetAddress ipAddress, final PackageDefinition packageDefinition, final String businessName, final String businessPhone, final String businessFax, final String businessAddress1, final String businessAddress2, final String businessCity, final String businessState, final CountryCode businessCountry, final String businessZip, final String baName, final String baTitle, final String baWorkPhone, final String baCellPhone, final String baHomePhone, final String baFax, final Email baEmail, final String baAddress1, final String baAddress2, final String baCity, final String baState, final CountryCode baCountry, final String baZip, final User.Name baUsername, final String billingContact, final Email billingEmail, final boolean billingUseMonthly, final boolean billingPayOneYear, String baPassword, String billingCardholderName, String billingCardNumber, String billingExpirationMonth, String billingExpirationYear, String billingStreetAddress, String billingCity, String billingState, String billingZip, final Map<String, String> options) throws IOException, SQLException {
        if (baPassword == null) {
            throw new NullPointerException("ba_password is null");
        }
        if (baPassword.indexOf(10) != -1) {
            throw new IllegalArgumentException("ba_password may not contain '\n'");
        }
        if (billingCardholderName == null) {
            throw new NullPointerException("billing_cardholder_name is null");
        }
        if (billingCardholderName.indexOf(10) != -1) {
            throw new IllegalArgumentException("billing_cardholder_name may not contain '\n'");
        }
        if (billingCardNumber == null) {
            throw new NullPointerException("billing_card_number is null");
        }
        if (billingCardNumber.indexOf(10) != -1) {
            throw new IllegalArgumentException("billing_card_number may not contain '\n'");
        }
        if (billingExpirationMonth == null) {
            throw new NullPointerException("billing_expiration_month is null");
        }
        if (billingExpirationMonth.indexOf(10) != -1) {
            throw new IllegalArgumentException("billing_expiration_month may not contain '\n'");
        }
        if (billingExpirationYear == null) {
            throw new NullPointerException("billing_expiration_year is null");
        }
        if (billingExpirationYear.indexOf(10) != -1) {
            throw new IllegalArgumentException("billing_expiration_year may not contain '\n'");
        }
        if (billingStreetAddress == null) {
            throw new NullPointerException("billing_street_address is null");
        }
        if (billingStreetAddress.indexOf(10) != -1) {
            throw new IllegalArgumentException("billing_street_address may not contain '\n'");
        }
        if (billingCity == null) {
            throw new NullPointerException("billing_city is null");
        }
        if (billingCity.indexOf(10) != -1) {
            throw new IllegalArgumentException("billing_city may not contain '\n'");
        }
        if (billingState == null) {
            throw new NullPointerException("billing_state is null");
        }
        if (billingState.indexOf(10) != -1) {
            throw new IllegalArgumentException("billing_state may not contain '\n'");
        }
        if (billingZip == null) {
            throw new NullPointerException("billing_zip is null");
        }
        if (billingZip.indexOf(10) != -1) {
            throw new IllegalArgumentException("billing_zip may not contain '\n'");
        }
        final EncryptionKey from = brand.getSignupEncryptionFrom();
        final EncryptionKey recipient = brand.getSignupEncryptionRecipient();
        String plaintext = baPassword + "\n" + billingCardholderName + "\n" + billingCardNumber + "\n" + billingExpirationMonth + "\n" + billingExpirationYear + "\n" + billingStreetAddress + "\n" + billingCity + "\n" + billingState + "\n" + billingZip + "\n";
        final String ciphertext = from.encrypt(recipient, plaintext);
        return this.connector.requestResult(true, AoservProtocol.CommandId.ADD, new AoservConnector.ResultRequest<Integer>(){
            private int pkey;
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Table.TableId.SIGNUP_REQUESTS.ordinal());
                out.writeUTF(brand.getAccount_name().toString());
                out.writeUTF(ipAddress.toString());
                out.writeCompressedInt(packageDefinition.getPkey());
                out.writeUTF(businessName);
                out.writeUTF(businessPhone);
                out.writeBoolean(businessFax != null);
                if (businessFax != null) {
                    out.writeUTF(businessFax);
                }
                out.writeUTF(businessAddress1);
                out.writeBoolean(businessAddress2 != null);
                if (businessAddress2 != null) {
                    out.writeUTF(businessAddress2);
                }
                out.writeUTF(businessCity);
                out.writeBoolean(businessState != null);
                if (businessState != null) {
                    out.writeUTF(businessState);
                }
                out.writeUTF(businessCountry.getCode());
                out.writeBoolean(businessZip != null);
                if (businessZip != null) {
                    out.writeUTF(businessZip);
                }
                out.writeUTF(baName);
                out.writeBoolean(baTitle != null);
                if (baTitle != null) {
                    out.writeUTF(baTitle);
                }
                out.writeUTF(baWorkPhone);
                out.writeBoolean(baCellPhone != null);
                if (baCellPhone != null) {
                    out.writeUTF(baCellPhone);
                }
                out.writeBoolean(baHomePhone != null);
                if (baHomePhone != null) {
                    out.writeUTF(baHomePhone);
                }
                out.writeBoolean(baFax != null);
                if (baFax != null) {
                    out.writeUTF(baFax);
                }
                out.writeUTF(baEmail.toString());
                out.writeBoolean(baAddress1 != null);
                if (baAddress1 != null) {
                    out.writeUTF(baAddress1);
                }
                out.writeBoolean(baAddress2 != null);
                if (baAddress2 != null) {
                    out.writeUTF(baAddress2);
                }
                out.writeBoolean(baCity != null);
                if (baCity != null) {
                    out.writeUTF(baCity);
                }
                out.writeBoolean(baState != null);
                if (baState != null) {
                    out.writeUTF(baState);
                }
                out.writeBoolean(baCountry != null);
                if (baCountry != null) {
                    out.writeUTF(baCountry.getCode());
                }
                out.writeBoolean(baZip != null);
                if (baZip != null) {
                    out.writeUTF(baZip);
                }
                out.writeUTF(baUsername.toString());
                out.writeUTF(billingContact);
                out.writeUTF(billingEmail.toString());
                out.writeBoolean(billingUseMonthly);
                out.writeBoolean(billingPayOneYear);
                out.writeCompressedInt(from.getPkey());
                out.writeCompressedInt(recipient.getPkey());
                out.writeUTF(ciphertext);
                int numOptions = options.size();
                out.writeCompressedInt(numOptions);
                int optionCount = 0;
                for (String name : options.keySet()) {
                    out.writeUTF(name);
                    String value = (String)options.get(name);
                    out.writeBoolean(value != null);
                    if (value != null) {
                        out.writeUTF(value);
                    }
                    ++optionCount;
                }
                if (optionCount != numOptions) {
                    throw new IOException("options modified while writing to master");
                }
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.pkey = in.readCompressedInt();
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public Integer afterRelease() {
                RequestTable.this.connector.tablesUpdated(this.invalidateList);
                return this.pkey;
            }
        });
    }
}

