/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.sql;

import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.schema.Column;
import com.aoindustries.aoserv.client.schema.ForeignKey;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.schema.Type;
import com.aoindustries.aoserv.client.sql.SqlCast;
import com.aoindustries.aoserv.client.sql.SqlColumnJoin;
import com.aoindustries.aoserv.client.sql.SqlColumnValue;
import com.aoindustries.aoserv.client.sql.SqlExpression;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public final class Parser {
    private Parser() {
        throw new AssertionError();
    }

    public static int indexOfNotQuoted(String expr, char ch, int fromIndex) {
        boolean quoted = false;
        int end = expr.length();
        for (int i = fromIndex; i < end; ++i) {
            char c = expr.charAt(i);
            if (!quoted && c == ch) {
                return i;
            }
            if (c != '\"') continue;
            if (quoted) {
                if (i < end - 1 && expr.charAt(i + 1) == '\"') {
                    ++i;
                    continue;
                }
                quoted = false;
                continue;
            }
            quoted = true;
        }
        return -1;
    }

    public static int indexOfNotQuoted(String expr, char ch) {
        return Parser.indexOfNotQuoted(expr, ch, 0);
    }

    public static int indexOfNotQuoted(String expr, String str, int fromIndex) {
        boolean quoted = false;
        int strLen = str.length();
        int end = expr.length() - strLen;
        for (int i = fromIndex; i < end; ++i) {
            char c = expr.charAt(i);
            if (!quoted && expr.regionMatches(i, str, 0, strLen)) {
                return i;
            }
            if (c != '\"') continue;
            if (quoted) {
                if (i < end - 1 && expr.charAt(i + 1) == '\"') {
                    ++i;
                    continue;
                }
                quoted = false;
                continue;
            }
            quoted = true;
        }
        return -1;
    }

    public static int indexOfNotQuoted(String expr, String str) {
        return Parser.indexOfNotQuoted(expr, str, 0);
    }

    public static String unquote(String str) {
        int strLen = str.length();
        StringBuilder unquoted = new StringBuilder(strLen);
        boolean quoted = false;
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            if (c == '\"') {
                if (quoted) {
                    if (i < strLen - 1 && str.charAt(i + 1) == '\"') {
                        unquoted.append('\"');
                        ++i;
                        continue;
                    }
                    quoted = false;
                    continue;
                }
                quoted = true;
                continue;
            }
            unquoted.append(c);
        }
        return unquoted.length() == strLen ? str : unquoted.toString();
    }

    public static String quote(String str) {
        int strLen = str.length();
        if (strLen == 0) {
            return "\"\"";
        }
        int quotedLen = strLen + 2;
        boolean needsQuote = false;
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            if (c <= ' ' || c > '~' || c == '.') {
                needsQuote = true;
                continue;
            }
            if (c != '\"') continue;
            needsQuote = true;
            ++quotedLen;
        }
        if (needsQuote) {
            char[] quoted = new char[quotedLen];
            int quotedPos = 0;
            quoted[quotedPos++] = 34;
            for (int i = 0; i < strLen; ++i) {
                char c = str.charAt(i);
                quoted[quotedPos++] = c;
                if (c != '\"') continue;
                quoted[quotedPos++] = 34;
            }
            quoted[quotedPos++] = 34;
            assert (quotedPos == quotedLen);
            return new String(quoted);
        }
        return str;
    }

    public static SqlExpression parseSqlExpression(AoservTable<?, ?> table, String expr) throws SQLException, IOException {
        int castPos;
        AoservConnector connector = table.getConnector();
        int joinPos = Parser.indexOfNotQuoted(expr, '.');
        if (joinPos == -1) {
            joinPos = expr.length();
        }
        if ((castPos = Parser.indexOfNotQuoted(expr, "::")) == -1) {
            castPos = expr.length();
        }
        int columnNameEnd = Math.min(joinPos, castPos);
        String columnName = Parser.unquote(expr.substring(0, columnNameEnd));
        Table tableSchema = table.getTableSchema();
        Column lastColumn = tableSchema.getSchemaColumn(connector, columnName);
        if (lastColumn == null) {
            throw new IllegalArgumentException("Unable to find column: " + Parser.quote(tableSchema.getName()) + '.' + Parser.quote(columnName));
        }
        SqlExpression sql = new SqlColumnValue(connector, lastColumn);
        expr = expr.substring(columnNameEnd);
        while (!expr.isEmpty()) {
            if (expr.charAt(0) == '.') {
                List<ForeignKey> keys = lastColumn.getReferences(connector);
                if (keys.size() != 1) {
                    throw new IllegalArgumentException("Column " + Parser.quote(lastColumn.getTable(connector).getName()) + '.' + Parser.quote(lastColumn.getName()) + " should reference precisely one column, references " + keys.size());
                }
                joinPos = Parser.indexOfNotQuoted(expr, '.', 1);
                if (joinPos == -1) {
                    joinPos = expr.length();
                }
                if ((castPos = Parser.indexOfNotQuoted(expr, "::", 1)) == -1) {
                    castPos = expr.length();
                }
                int joinNameEnd = Math.min(joinPos, castPos);
                columnName = Parser.unquote(expr.substring(1, joinNameEnd));
                Column keyColumn = keys.get(0).getForeignColumn(connector);
                Table valueTable = keyColumn.getTable(connector);
                Column valueColumn = valueTable.getSchemaColumn(connector, columnName);
                if (valueColumn == null) {
                    throw new IllegalArgumentException("Unable to find column: " + Parser.quote(valueTable.getName()) + '.' + Parser.quote(columnName) + " referenced from " + Parser.quote(tableSchema.getName()));
                }
                sql = new SqlColumnJoin(connector, sql, keyColumn, valueColumn);
                expr = expr.substring(joinNameEnd);
                lastColumn = valueColumn;
                continue;
            }
            if (expr.charAt(0) == ':' && expr.length() >= 2 && expr.charAt(1) == ':') {
                joinPos = Parser.indexOfNotQuoted(expr, '.', 2);
                if (joinPos == -1) {
                    joinPos = expr.length();
                }
                if ((castPos = Parser.indexOfNotQuoted(expr, "::", 2)) == -1) {
                    castPos = expr.length();
                }
                int typeNameEnd = Math.min(joinPos, castPos);
                String typeName = Parser.unquote(expr.substring(2, typeNameEnd));
                Type type = connector.getSchema().getType().get(typeName);
                if (type == null) {
                    throw new IllegalArgumentException("Unable to find SchemaType: " + Parser.quote(typeName));
                }
                sql = new SqlCast(sql, type);
                expr = expr.substring(typeNameEnd);
                continue;
            }
            throw new IllegalArgumentException("Unable to parse: " + expr);
        }
        return sql;
    }
}

