/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.sql;

import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservObject;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.schema.Type;
import com.aoindustries.aoserv.client.sql.Parser;
import com.aoindustries.aoserv.client.sql.SqlExpression;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public final class SqlCast
implements SqlExpression {
    private final SqlExpression expression;
    private final Type castToType;

    public SqlCast(SqlExpression expression, Type castToType) {
        this.expression = expression;
        this.castToType = castToType;
    }

    public String toString() {
        return this.expression.toString() + "::" + Parser.quote(this.castToType.getName());
    }

    @Override
    public String getColumnName() {
        return this.castToType.getName();
    }

    @Override
    public Object evaluate(AoservConnector conn, AoservObject<?, ?> obj) throws IOException, SQLException {
        return this.expression.getType().cast(conn, this.expression.evaluate(conn, obj), this.castToType);
    }

    @Override
    public Type getType() {
        return this.castToType;
    }

    @Override
    public void getReferencedTables(AoservConnector conn, List<Table> tables) throws IOException, SQLException {
        this.expression.getReferencedTables(conn, tables);
    }
}

