/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.sql;

import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservObject;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.schema.Column;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.schema.Type;
import com.aoindustries.aoserv.client.sql.Parser;
import com.aoindustries.aoserv.client.sql.SqlExpression;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public final class SqlColumnJoin
implements SqlExpression {
    private final SqlExpression expression;
    private final Column keyColumn;
    private final int keyIndex;
    private final Column valueColumn;
    private final Type type;
    private final AoservTable<?, ?> table;
    private final int valueIndex;

    public SqlColumnJoin(AoservConnector conn, SqlExpression expression, Column keyColumn, Column valueColumn) throws SQLException, IOException {
        this.expression = expression;
        this.keyColumn = keyColumn;
        this.keyIndex = keyColumn.getIndex();
        this.valueColumn = valueColumn;
        this.type = valueColumn.getType(conn);
        this.table = keyColumn.getTable(conn).getAoservTable(conn);
        this.valueIndex = valueColumn.getIndex();
    }

    public String toString() {
        return this.expression.toString() + "." + Parser.quote(this.valueColumn.getName());
    }

    @Override
    public String getColumnName() {
        return this.valueColumn.getName();
    }

    @Override
    public Object evaluate(AoservConnector conn, AoservObject<?, ?> obj) throws IOException, SQLException {
        Object row;
        Object keyValue = this.expression.evaluate(conn, obj);
        if (keyValue != null && (row = this.table.getUniqueRow(this.keyIndex, keyValue)) != null) {
            return ((AoservObject)row).getColumn(this.valueIndex);
        }
        return null;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void getReferencedTables(AoservConnector conn, List<Table> tables) throws IOException, SQLException {
        this.expression.getReferencedTables(conn, tables);
        Table t = this.keyColumn.getTable(conn);
        if (!tables.contains(t)) {
            tables.add(t);
        }
    }
}

