/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.sql;

import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservObject;
import com.aoindustries.aoserv.client.schema.Column;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.schema.Type;
import com.aoindustries.aoserv.client.sql.Parser;
import com.aoindustries.aoserv.client.sql.SqlExpression;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public final class SqlColumnValue
implements SqlExpression {
    private final Column column;
    private final Type columnType;

    public SqlColumnValue(AoservConnector conn, Column column) throws SQLException, IOException {
        if (column == null) {
            throw new NullPointerException("column is null");
        }
        this.column = column;
        this.columnType = column.getType(conn);
    }

    public String toString() {
        return Parser.quote(this.column.getName());
    }

    @Override
    public String getColumnName() {
        return this.column.getName();
    }

    @Override
    public Object evaluate(AoservConnector conn, AoservObject<?, ?> obj) {
        return obj.getColumn(this.column.getIndex());
    }

    @Override
    public Type getType() {
        return this.columnType;
    }

    @Override
    public void getReferencedTables(AoservConnector conn, List<Table> tables) throws SQLException, IOException {
        Table table = this.column.getTable(conn);
        if (!tables.contains(table)) {
            tables.add(table);
        }
    }
}

