/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.sql;

import com.aoapps.lang.exception.WrappedException;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservObject;
import com.aoindustries.aoserv.client.sql.SqlExpression;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Comparator;

public final class SqlComparator<T>
implements Comparator<T> {
    private final AoservConnector connector;
    private final SqlExpression[] exprs;
    private final boolean[] sortOrders;

    public SqlComparator(AoservConnector connector, SqlExpression[] exprs, boolean[] sortOrders) {
        this.connector = connector;
        this.exprs = exprs;
        this.sortOrders = sortOrders;
    }

    @Override
    public int compare(T o1, T o2) {
        try {
            if (o1 instanceof AoservObject) {
                AoservObject ao1 = (AoservObject)o1;
                if (o2 instanceof AoservObject) {
                    AoservObject ao2 = (AoservObject)o2;
                    return ao1.compareTo(this.connector, ao2, this.exprs, this.sortOrders);
                }
                if (o2 instanceof Object[]) {
                    return ao1.compareTo(this.connector, (Object[])o2, this.exprs, this.sortOrders);
                }
                if (o2 instanceof Comparable) {
                    return ao1.compareTo(this.connector, (Comparable)o2, this.exprs, this.sortOrders);
                }
                throw new IllegalArgumentException("O2 must be either AoservObject, Object[], or Comparable");
            }
            if (o1 instanceof Object[]) {
                Object[] oa1 = (Object[])o1;
                if (o2 instanceof AoservObject) {
                    AoservObject ao2 = (AoservObject)o2;
                    return -ao2.compareTo(this.connector, oa1, this.exprs, this.sortOrders);
                }
                if (o2 instanceof Object[]) {
                    Object[] oa2 = (Object[])o2;
                    return this.compare(oa1, oa2);
                }
                if (o2 instanceof Comparable) {
                    throw new IllegalArgumentException("Comparing of Object[] and Comparable not supported.");
                }
                throw new IllegalArgumentException("O2 must be either AoservObject, Object[], or Comparable");
            }
            if (o1 instanceof Comparable) {
                Comparable c1 = (Comparable)o1;
                if (o2 instanceof AoservObject) {
                    AoservObject ao2 = (AoservObject)o2;
                    return -ao2.compareTo(this.connector, c1, this.exprs, this.sortOrders);
                }
                if (o2 instanceof Object[]) {
                    throw new IllegalArgumentException("Comparing of Comparable and Object[] not supported.");
                }
                if (o2 instanceof Comparable) {
                    return c1.compareTo(o2);
                }
                throw new IllegalArgumentException("O2 must be either AoservObject or Comparable");
            }
            throw new IllegalArgumentException("O1 must be either AoservObject or Comparable");
        }
        catch (IOException | SQLException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    @Override
    public int compare(T[] oa1, T[] oa2) {
        int oa1Len = oa1.length;
        int oa2Len = oa2.length;
        if (oa1Len != oa2Len) {
            throw new IllegalArgumentException("Mismatched array lengths when comparing two Object[]s: OA1.length=" + oa1Len + ", OA2.length=" + oa2Len);
        }
        for (int c = 0; c < oa1Len; ++c) {
            int diff = this.compare(oa1[c], oa2[c]);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }
}

