/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.ticket;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.i18n.Resources;
import com.aoapps.lang.util.InternUtils;
import com.aoapps.lang.util.Internable;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.Email;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.reseller.Category;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.ticket.ActionType;
import com.aoindustries.aoserv.client.ticket.Priority;
import com.aoindustries.aoserv.client.ticket.Status;
import com.aoindustries.aoserv.client.ticket.Ticket;
import com.aoindustries.aoserv.client.ticket.TicketType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.ResourceBundle;

public final class Action
extends CachedObjectIntegerKey<Action> {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, Action.class);
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_TICKET = 1;
    static final int COLUMN_ADMINISTRATOR = 2;
    static final int COLUMN_TIME = 3;
    static final String COLUMN_TICKET_name = "ticket";
    static final String COLUMN_TIME_name = "time";
    static final String COLUMN_PKEY_name = "pkey";
    private int ticket;
    private User.Name administrator;
    private UnmodifiableTimestamp time;
    private String actionType;
    private Account.Name oldAccounting;
    private Account.Name newAccounting;
    private String oldPriority;
    private String newPriority;
    private String oldType;
    private String newType;
    private String oldStatus;
    private String newStatus;
    private User.Name oldAssignedTo;
    private User.Name newAssignedTo;
    private int oldCategory;
    private int newCategory;
    private boolean oldValueLoaded;
    private String oldValue;
    private boolean newValueLoaded;
    private String newValue;
    private Email fromAddress;
    private String summary;
    private boolean detailsLoaded;
    private String details;
    private boolean rawEmailLoaded;
    private String rawEmail;

    @Deprecated
    public Action() {
    }

    @Override
    protected Object getColumnImpl(int i) throws IOException, SQLException {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.ticket;
            }
            case 2: {
                return this.administrator;
            }
            case 3: {
                return this.time;
            }
            case 4: {
                return this.actionType;
            }
            case 5: {
                return this.oldAccounting;
            }
            case 6: {
                return this.newAccounting;
            }
            case 7: {
                return this.oldPriority;
            }
            case 8: {
                return this.newPriority;
            }
            case 9: {
                return this.oldType;
            }
            case 10: {
                return this.newType;
            }
            case 11: {
                return this.oldStatus;
            }
            case 12: {
                return this.newStatus;
            }
            case 13: {
                return this.oldAssignedTo;
            }
            case 14: {
                return this.newAssignedTo;
            }
            case 15: {
                return this.oldCategory == -1 ? null : Integer.valueOf(this.oldCategory);
            }
            case 16: {
                return this.newCategory == -1 ? null : Integer.valueOf(this.newCategory);
            }
            case 17: {
                return this.getOldValue();
            }
            case 18: {
                return this.getNewValue();
            }
            case 19: {
                return this.fromAddress;
            }
            case 20: {
                return this.summary;
            }
            case 21: {
                return this.getDetails();
            }
            case 22: {
                return this.getRawEmail();
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Ticket getTicket() throws IOException, SQLException {
        Ticket t = this.table.getConnector().getTicket().getTicket().get(this.ticket);
        if (t == null) {
            throw new SQLException("Unable to find Ticket: " + this.ticket);
        }
        return t;
    }

    public Administrator getAdministrator() throws IOException, SQLException {
        if (this.administrator == null) {
            return null;
        }
        return this.table.getConnector().getAccount().getAdministrator().get(this.administrator);
    }

    public UnmodifiableTimestamp getTime() {
        return this.time;
    }

    public ActionType getTicketActionType() throws SQLException, IOException {
        ActionType type = this.table.getConnector().getTicket().getActionType().get(this.actionType);
        if (type == null) {
            throw new SQLException("Unable to find TicketActionType: " + this.actionType);
        }
        return type;
    }

    public Account getOldAccount() throws IOException, SQLException {
        if (this.oldAccounting == null) {
            return null;
        }
        return this.table.getConnector().getAccount().getAccount().get(this.oldAccounting);
    }

    public Account getNewAccount() throws IOException, SQLException {
        if (this.newAccounting == null) {
            return null;
        }
        return this.table.getConnector().getAccount().getAccount().get(this.newAccounting);
    }

    public Priority getOldPriority() throws IOException, SQLException {
        if (this.oldPriority == null) {
            return null;
        }
        Priority tp = this.table.getConnector().getTicket().getPriority().get(this.oldPriority);
        if (tp == null) {
            throw new SQLException("Unable to find TicketPriority: " + this.oldPriority);
        }
        return tp;
    }

    public Priority getNewPriority() throws IOException, SQLException {
        if (this.newPriority == null) {
            return null;
        }
        Priority tp = this.table.getConnector().getTicket().getPriority().get(this.newPriority);
        if (tp == null) {
            throw new SQLException("Unable to find TicketPriority: " + this.newPriority);
        }
        return tp;
    }

    public TicketType getOldType() throws IOException, SQLException {
        if (this.oldType == null) {
            return null;
        }
        TicketType tt = this.table.getConnector().getTicket().getTicketType().get(this.oldType);
        if (tt == null) {
            throw new SQLException("Unable to find TicketType: " + this.oldType);
        }
        return tt;
    }

    public TicketType getNewType() throws IOException, SQLException {
        if (this.newType == null) {
            return null;
        }
        TicketType tt = this.table.getConnector().getTicket().getTicketType().get(this.newType);
        if (tt == null) {
            throw new SQLException("Unable to find TicketType: " + this.newType);
        }
        return tt;
    }

    public Status getOldStatus() throws IOException, SQLException {
        if (this.oldStatus == null) {
            return null;
        }
        Status ts = this.table.getConnector().getTicket().getStatus().get(this.oldStatus);
        if (ts == null) {
            throw new SQLException("Unable to find TicketStatus: " + this.oldStatus);
        }
        return ts;
    }

    public Status getNewStatus() throws IOException, SQLException {
        if (this.newStatus == null) {
            return null;
        }
        Status ts = this.table.getConnector().getTicket().getStatus().get(this.newStatus);
        if (ts == null) {
            throw new SQLException("Unable to find TicketStatus: " + this.newStatus);
        }
        return ts;
    }

    public Administrator getOldAssignedTo() throws IOException, SQLException {
        if (this.oldAssignedTo == null) {
            return null;
        }
        return this.table.getConnector().getAccount().getAdministrator().get(this.oldAssignedTo);
    }

    public Administrator getNewAssignedTo() throws IOException, SQLException {
        if (this.newAssignedTo == null) {
            return null;
        }
        return this.table.getConnector().getAccount().getAdministrator().get(this.newAssignedTo);
    }

    public Category getOldCategory() throws IOException, SQLException {
        if (this.oldCategory == -1) {
            return null;
        }
        Category tc = this.table.getConnector().getReseller().getCategory().get(this.oldCategory);
        if (tc == null) {
            throw new SQLException("Unable to find TicketCategory: " + this.oldCategory);
        }
        return tc;
    }

    public Category getNewCategory() throws IOException, SQLException {
        if (this.newCategory == -1) {
            return null;
        }
        Category tc = this.table.getConnector().getReseller().getCategory().get(this.newCategory);
        if (tc == null) {
            throw new SQLException("Unable to find TicketCategory: " + this.newCategory);
        }
        return tc;
    }

    public synchronized String getOldValue() throws IOException, SQLException {
        if (!this.oldValueLoaded) {
            this.oldValue = this.actionType.equals("set_contact_emails") || this.actionType.equals("set_contact_phone_numbers") || this.actionType.equals("set_summary") || this.actionType.equals("set_internal_notes") ? this.table.getConnector().requestNullLongStringQuery(true, AoservProtocol.CommandId.GET_TICKET_ACTION_OLD_VALUE, this.pkey) : null;
            this.oldValueLoaded = true;
        }
        return this.oldValue;
    }

    public synchronized String getNewValue() throws IOException, SQLException {
        if (!this.newValueLoaded) {
            this.newValue = this.actionType.equals("set_contact_emails") || this.actionType.equals("set_contact_phone_numbers") || this.actionType.equals("set_summary") || this.actionType.equals("set_internal_notes") ? this.table.getConnector().requestNullLongStringQuery(true, AoservProtocol.CommandId.GET_TICKET_ACTION_NEW_VALUE, this.pkey) : null;
            this.newValueLoaded = true;
        }
        return this.newValue;
    }

    public Email getFromAddress() {
        return this.fromAddress;
    }

    public String getSummary() throws IOException, SQLException {
        String newValue;
        String oldValue;
        if (this.summary != null) {
            return this.summary;
        }
        switch (this.actionType) {
            case "set_business": {
                oldValue = Objects.toString(this.oldAccounting, null);
                newValue = Objects.toString(this.newAccounting, null);
                break;
            }
            case "set_client_priority": 
            case "set_admin_priority": {
                oldValue = this.oldPriority;
                newValue = this.newPriority;
                break;
            }
            case "set_type": {
                oldValue = this.getOldType().toStringImpl();
                newValue = this.getNewType().toStringImpl();
                break;
            }
            case "set_status": {
                oldValue = this.getOldStatus().toStringImpl();
                newValue = this.getNewStatus().toStringImpl();
                break;
            }
            case "assign": {
                Administrator oldAssignedTo = this.getOldAssignedTo();
                Administrator newAssignedTo = this.getNewAssignedTo();
                String string = oldAssignedTo != null ? oldAssignedTo.getName() : (oldValue = oldAssignedTo != null ? RESOURCES.getMessage("old_assigned_to.filtered") : null);
                newValue = newAssignedTo != null ? newAssignedTo.getName() : (newAssignedTo != null ? RESOURCES.getMessage("new_assigned_to.filtered") : null);
                break;
            }
            case "set_category": {
                Category oldCategory = this.getOldCategory();
                Category newCategory = this.getNewCategory();
                oldValue = oldCategory != null ? oldCategory.toStringImpl() : null;
                newValue = newCategory != null ? newCategory.toStringImpl() : null;
                break;
            }
            case "set_contact_emails": 
            case "set_contact_phone_numbers": 
            case "set_summary": 
            case "set_internal_notes": 
            case "add_annotation": {
                oldValue = this.getOldValue();
                newValue = this.getNewValue();
                break;
            }
            default: {
                throw new SQLException("Unexpected value for action_type: " + this.actionType);
            }
        }
        return this.getTicketActionType().generateSummary(this.table.getConnector(), oldValue, newValue);
    }

    public synchronized String getDetails() throws IOException, SQLException {
        if (!this.detailsLoaded) {
            this.details = this.actionType.equals("add_annotation") ? this.table.getConnector().requestNullLongStringQuery(true, AoservProtocol.CommandId.GET_TICKET_ACTION_DETAILS, this.pkey) : null;
            this.detailsLoaded = true;
        }
        return this.details;
    }

    public synchronized String getRawEmail() throws IOException, SQLException {
        if (!this.rawEmailLoaded) {
            this.rawEmail = this.actionType.equals("add_annotation") ? this.table.getConnector().requestNullLongStringQuery(true, AoservProtocol.CommandId.GET_TICKET_ACTION_RAW_EMAIL, this.pkey) : null;
            this.rawEmailLoaded = true;
        }
        return this.rawEmail;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.TICKET_ACTIONS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.ticket = result.getInt(pos++);
            this.administrator = User.Name.valueOf(result.getString(pos++));
            this.time = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(pos++));
            this.actionType = result.getString(pos++);
            this.oldAccounting = Account.Name.valueOf(result.getString(pos++));
            this.newAccounting = Account.Name.valueOf(result.getString(pos++));
            this.oldPriority = result.getString(pos++);
            this.newPriority = result.getString(pos++);
            this.oldType = result.getString(pos++);
            this.newType = result.getString(pos++);
            this.oldStatus = result.getString(pos++);
            this.newStatus = result.getString(pos++);
            this.oldAssignedTo = User.Name.valueOf(result.getString(pos++));
            this.newAssignedTo = User.Name.valueOf(result.getString(pos++));
            this.oldCategory = result.getInt(pos++);
            if (result.wasNull()) {
                this.oldCategory = -1;
            }
            this.newCategory = result.getInt(pos++);
            if (result.wasNull()) {
                this.newCategory = -1;
            }
            this.fromAddress = Email.valueOf((String)result.getString(pos++));
            this.summary = result.getString(pos++);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.ticket = in.readCompressedInt();
            this.administrator = (User.Name)InternUtils.intern((Internable)User.Name.valueOf(in.readNullUTF()));
            this.time = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.actionType = in.readUTF().intern();
            this.oldAccounting = (Account.Name)InternUtils.intern((Internable)Account.Name.valueOf(in.readNullUTF()));
            this.newAccounting = (Account.Name)InternUtils.intern((Internable)Account.Name.valueOf(in.readNullUTF()));
            this.oldPriority = InternUtils.intern((String)in.readNullUTF());
            this.newPriority = InternUtils.intern((String)in.readNullUTF());
            this.oldType = InternUtils.intern((String)in.readNullUTF());
            this.newType = InternUtils.intern((String)in.readNullUTF());
            this.oldStatus = InternUtils.intern((String)in.readNullUTF());
            this.newStatus = InternUtils.intern((String)in.readNullUTF());
            this.oldAssignedTo = (User.Name)InternUtils.intern((Internable)User.Name.valueOf(in.readNullUTF()));
            this.newAssignedTo = (User.Name)InternUtils.intern((Internable)User.Name.valueOf(in.readNullUTF()));
            this.oldCategory = in.readCompressedInt();
            this.newCategory = in.readCompressedInt();
            this.fromAddress = Email.valueOf((String)in.readNullUTF());
            this.summary = in.readNullUTF();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String toStringImpl() {
        return this.ticket + "|" + this.pkey + '|' + this.actionType + '|' + this.administrator;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.ticket);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_50) >= 0) {
            out.writeNullUTF(Objects.toString(this.administrator, null));
        } else {
            out.writeUTF(this.administrator == null ? "aoadmin" : this.administrator.toString());
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.time.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.time, (DataOutputStream)out);
        }
        out.writeUTF(this.actionType);
        out.writeNullUTF(Objects.toString(this.oldAccounting, null));
        out.writeNullUTF(Objects.toString(this.newAccounting, null));
        out.writeNullUTF(this.oldPriority);
        out.writeNullUTF(this.newPriority);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_49) >= 0) {
            out.writeNullUTF(this.oldType);
            out.writeNullUTF(this.newType);
        }
        out.writeNullUTF(this.oldStatus);
        out.writeNullUTF(this.newStatus);
        out.writeNullUTF(Objects.toString(this.oldAssignedTo, null));
        out.writeNullUTF(Objects.toString(this.newAssignedTo, null));
        out.writeCompressedInt(this.oldCategory);
        out.writeCompressedInt(this.newCategory);
        out.writeNullUTF(Objects.toString(this.fromAddress, null));
        out.writeNullUTF(this.summary);
    }
}

