/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.ticket;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.i18n.Resources;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.GlobalObjectStringKey;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;

public final class ActionType
extends GlobalObjectStringKey<ActionType> {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, ActionType.class);
    static final int COLUMN_TYPE = 0;
    static final String COLUMN_TYPE_name = "type";
    private boolean visibleAdminOnly;
    public static final String SET_BUSINESS = "set_business";
    public static final String SET_CONTACT_EMAILS = "set_contact_emails";
    public static final String SET_CONTACT_PHONE_NUMBERS = "set_contact_phone_numbers";
    public static final String SET_CLIENT_PRIORITY = "set_client_priority";
    public static final String SET_SUMMARY = "set_summary";
    public static final String ADD_ANNOTATION = "add_annotation";
    public static final String SET_STATUS = "set_status";
    public static final String SET_ADMIN_PRIORITY = "set_admin_priority";
    public static final String ASSIGN = "assign";
    public static final String SET_CATEGORY = "set_category";
    public static final String SET_INTERNAL_NOTES = "set_internal_notes";
    public static final String SET_TYPE = "set_type";

    @Deprecated
    public ActionType() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.visibleAdminOnly;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.TICKET_ACTION_TYPES;
    }

    public String getType() {
        return this.pkey;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getString(1);
        this.visibleAdminOnly = result.getBoolean(2);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readUTF().intern();
        this.visibleAdminOnly = in.readBoolean();
    }

    @Override
    public String toStringImpl() {
        return RESOURCES.getMessage(this.pkey + ".toString");
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey);
        out.writeBoolean(this.visibleAdminOnly);
    }

    String generateSummary(AoservConnector connector, String oldValue, String newValue) {
        if (oldValue == null) {
            if (newValue == null) {
                return RESOURCES.getMessage(this.pkey + ".generatedSummary.null.null");
            }
            return RESOURCES.getMessage(this.pkey + ".generatedSummary.null.notNull", new Object[]{newValue});
        }
        if (newValue == null) {
            return RESOURCES.getMessage(this.pkey + ".generatedSummary.notNull.null", new Object[]{oldValue});
        }
        return RESOURCES.getMessage(this.pkey + ".generatedSummary.notNull.notNull", new Object[]{oldValue, newValue});
    }
}

