/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.ticket;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.reseller.Reseller;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.ticket.Ticket;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class Assignment
extends CachedObjectIntegerKey<Assignment> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_TICKET = 1;
    static final int COLUMN_RESELLER = 2;
    static final int COLUMN_ADMINISTRATOR = 3;
    static final String COLUMN_PKEY_name = "pkey";
    static final String COLUMN_TICKET_name = "ticket";
    static final String COLUMN_RESELLER_name = "reseller";
    static final String COLUMN_ADMINISTRATOR_name = "administrator";
    private int ticket;
    private Account.Name reseller;
    private User.Name administrator;

    @Deprecated
    public Assignment() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.ticket;
            }
            case 2: {
                return this.reseller;
            }
            case 3: {
                return this.administrator;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Ticket getTicket() throws IOException, SQLException {
        Ticket t = this.table.getConnector().getTicket().getTicket().get(this.ticket);
        if (t == null) {
            throw new SQLException("Unable to find Ticket: " + this.ticket);
        }
        return t;
    }

    public Reseller getReseller() throws IOException, SQLException {
        Reseller r = this.table.getConnector().getReseller().getReseller().get(this.reseller);
        if (r == null) {
            throw new SQLException("Unable to find Reseller: " + this.reseller);
        }
        return r;
    }

    public Administrator getAdministrator() throws IOException, SQLException {
        Administrator obj = this.table.getConnector().getAccount().getAdministrator().get(this.administrator);
        if (obj == null) {
            throw new SQLException("Unable to find Administrator: " + this.administrator);
        }
        return obj;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.TICKET_ASSIGNMENTS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.ticket = result.getInt(2);
            this.reseller = Account.Name.valueOf(result.getString(3));
            this.administrator = User.Name.valueOf(result.getString(4));
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.ticket = in.readCompressedInt();
            this.reseller = Account.Name.valueOf(in.readUTF()).intern();
            this.administrator = User.Name.valueOf(in.readUTF()).intern();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String toStringImpl() {
        return this.ticket + "|" + this.pkey + '|' + this.reseller + '|' + this.administrator;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.ticket);
        out.writeUTF(this.reseller.toString());
        out.writeUTF(this.administrator.toString());
    }
}

