/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.ticket;

import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.reseller.Reseller;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.ticket.Assignment;
import com.aoindustries.aoserv.client.ticket.Ticket;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public final class AssignmentTable
extends CachedTableIntegerKey<Assignment> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("ticket", true), new AoservTable.OrderBy("reseller", true)};

    AssignmentTable(AoservConnector connector) {
        super(connector, Assignment.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public Assignment get(int pkey) throws IOException, SQLException {
        return (Assignment)this.getUniqueRow(0, pkey);
    }

    List<Assignment> getTicketAssignments(Ticket ticket) throws IOException, SQLException {
        return this.getIndexedRows(1, ticket.getTicketId());
    }

    public List<Assignment> getTicketAssignments(Reseller reseller) throws IOException, SQLException {
        return this.getIndexedRows(2, reseller.getBrand_business_accounting());
    }

    public List<Assignment> getTicketAssignments(Administrator ba) throws IOException, SQLException {
        return this.getIndexedRows(3, ba.getUsername_userId());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.TICKET_ASSIGNMENTS;
    }
}

