/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.ticket;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.i18n.Resources;
import com.aoindustries.aoserv.client.GlobalObjectStringKey;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;

public final class Status
extends GlobalObjectStringKey<Status>
implements Comparable<Status> {
    private static final Resources RESOURCES = Resources.getResources(ResourceBundle::getBundle, Status.class);
    static final int COLUMN_STATUS = 0;
    static final int COLUMN_SORT_ORDER = 1;
    static final String COLUMN_STATUS_name = "status";
    static final String COLUMN_SORT_ORDER_name = "sort_order";
    public static final String JUNK = "junk";
    public static final String DELETED = "deleted";
    public static final String CLOSED = "closed";
    public static final String BOUNCED = "bounced";
    public static final String HOLD = "hold";
    public static final String OPEN = "open";
    private short sortOrder;

    @Deprecated
    public Status() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        if (i == 0) {
            return this.pkey;
        }
        if (i == 1) {
            return this.sortOrder;
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public short getSortOrder() {
        return this.sortOrder;
    }

    public String getStatus() {
        return this.pkey;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.TICKET_STATI;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getString(1);
        this.sortOrder = result.getShort(2);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readUTF().intern();
        this.sortOrder = in.readShort();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeUTF(this.pkey);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_43) <= 0) {
            out.writeUTF(this.pkey);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_44) >= 0) {
            out.writeShort((int)this.sortOrder);
        }
    }

    @Override
    public String toStringImpl() {
        return RESOURCES.getMessage(this.pkey + ".toString");
    }

    public String getDescription() {
        return RESOURCES.getMessage(this.pkey + ".description");
    }

    @Override
    public int compareTo(Status o) {
        short sortOrder1 = this.sortOrder;
        short sortOrder2 = o.sortOrder;
        if (sortOrder1 < sortOrder2) {
            return -1;
        }
        if (sortOrder1 > sortOrder2) {
            return 1;
        }
        return 0;
    }
}

