/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.ticket;

import com.aoapps.collections.AoCollections;
import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.Strings;
import com.aoapps.lang.util.InternUtils;
import com.aoapps.lang.util.Internable;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.Email;
import com.aoapps.sql.SQLStreamables;
import com.aoapps.sql.UnmodifiableTimestamp;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.account.Profile;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.reseller.Brand;
import com.aoindustries.aoserv.client.reseller.Category;
import com.aoindustries.aoserv.client.reseller.Reseller;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.ticket.Action;
import com.aoindustries.aoserv.client.ticket.Assignment;
import com.aoindustries.aoserv.client.ticket.Language;
import com.aoindustries.aoserv.client.ticket.Priority;
import com.aoindustries.aoserv.client.ticket.Status;
import com.aoindustries.aoserv.client.ticket.TicketType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class Ticket
extends CachedObjectIntegerKey<Ticket> {
    private Account.Name brand;
    private Account.Name reseller;
    private Account.Name accounting;
    private String language;
    private User.Name createdBy;
    private int category;
    private String ticketType;
    private Email fromAddress;
    private String summary;
    private boolean detailsLoaded;
    private String details;
    private boolean rawEmailLoaded;
    private String rawEmail;
    private UnmodifiableTimestamp openDate;
    private String clientPriority;
    private String adminPriority;
    private String status;
    private UnmodifiableTimestamp statusTimeout;
    private Set<Email> contactEmails;
    private String contactPhoneNumbers;
    private boolean internalNotesLoaded;
    private String internalNotes;
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_ACCOUNTING = 3;
    static final int COLUMN_CREATED_BY = 5;
    static final int COLUMN_OPEN_DATE = 12;
    static final String COLUMN_PKEY_name = "pkey";
    static final String COLUMN_OPEN_DATE_name = "open_date";

    @Deprecated
    public Ticket() {
    }

    @Override
    public String toStringImpl() {
        if (this.reseller != null) {
            return this.pkey + "|" + this.brand + '/' + this.accounting + '|' + this.status + "->" + this.reseller;
        }
        return this.pkey + "|" + this.brand + '/' + this.accounting + '|' + this.status;
    }

    @Override
    protected Object getColumnImpl(int i) throws IOException, SQLException {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.brand;
            }
            case 2: {
                return this.reseller;
            }
            case 3: {
                return this.accounting;
            }
            case 4: {
                return this.language;
            }
            case 5: {
                return this.createdBy;
            }
            case 6: {
                return this.category == -1 ? null : Integer.valueOf(this.category);
            }
            case 7: {
                return this.ticketType;
            }
            case 8: {
                return this.fromAddress;
            }
            case 9: {
                return this.summary;
            }
            case 10: {
                return this.getDetails();
            }
            case 11: {
                return this.getRawEmail();
            }
            case 12: {
                return this.openDate;
            }
            case 13: {
                return this.clientPriority;
            }
            case 14: {
                return this.adminPriority;
            }
            case 15: {
                return this.status;
            }
            case 16: {
                return this.statusTimeout;
            }
            case 17: {
                return Strings.join(this.contactEmails, (String)", ");
            }
            case 18: {
                return this.contactPhoneNumbers;
            }
            case 19: {
                return this.getInternalNotes();
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.TICKETS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.brand = Account.Name.valueOf(result.getString(pos++));
            this.reseller = Account.Name.valueOf(result.getString(pos++));
            this.accounting = Account.Name.valueOf(result.getString(pos++));
            this.language = result.getString(pos++);
            this.createdBy = User.Name.valueOf(result.getString(pos++));
            this.category = result.getInt(pos++);
            if (result.wasNull()) {
                this.category = -1;
            }
            this.ticketType = result.getString(pos++);
            this.fromAddress = Email.valueOf((String)result.getString(pos++));
            this.summary = result.getString(pos++);
            this.openDate = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(pos++));
            this.clientPriority = result.getString(pos++);
            this.adminPriority = result.getString(pos++);
            this.status = result.getString(pos++);
            this.statusTimeout = UnmodifiableTimestamp.valueOf((Timestamp)result.getTimestamp(pos++));
            String str = result.getString(pos++);
            try {
                this.contactEmails = Profile.splitEmails(str);
            }
            catch (ValidationException e) {
                throw new SQLException("contact_emails = " + str, e);
            }
            this.contactPhoneNumbers = result.getString(pos++);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.brand = Account.Name.valueOf(in.readUTF()).intern();
            String resellerStr = in.readUTF();
            this.reseller = "*".equals(resellerStr) ? null : Account.Name.valueOf(resellerStr).intern();
            this.accounting = (Account.Name)InternUtils.intern((Internable)Account.Name.valueOf(in.readNullUTF()));
            this.language = in.readUTF().intern();
            this.createdBy = (User.Name)InternUtils.intern((Internable)User.Name.valueOf(in.readNullUTF()));
            this.category = in.readCompressedInt();
            this.ticketType = in.readUTF().intern();
            this.fromAddress = Email.valueOf((String)in.readNullUTF());
            this.summary = in.readUTF();
            this.openDate = SQLStreamables.readUnmodifiableTimestamp((DataInputStream)in);
            this.clientPriority = in.readUTF().intern();
            this.adminPriority = InternUtils.intern((String)in.readNullUTF());
            this.status = in.readUTF().intern();
            this.statusTimeout = SQLStreamables.readNullUnmodifiableTimestamp((DataInputStream)in);
            int size = in.readCompressedInt();
            LinkedHashSet emails = AoCollections.newLinkedHashSet((int)size);
            for (int i = 0; i < size; ++i) {
                emails.add(Email.valueOf((String)in.readUTF()));
            }
            this.contactEmails = AoCollections.optimalUnmodifiableSet((Set)emails);
            this.contactPhoneNumbers = in.readUTF();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_46) >= 0) {
            out.writeUTF(this.brand.toString());
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_44) >= 0) {
            out.writeUTF(this.reseller == null ? "*" : this.reseller.toString());
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_125) <= 0) {
            out.writeUTF(this.accounting == null ? "" : this.accounting.toString());
        } else {
            out.writeNullUTF(Objects.toString(this.accounting, null));
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_44) >= 0) {
            out.writeUTF(this.language);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_125) <= 0) {
            out.writeUTF(this.createdBy == null ? "" : this.createdBy.toString());
        } else {
            out.writeNullUTF(Objects.toString(this.createdBy, null));
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_44) >= 0) {
            out.writeCompressedInt(this.category);
        }
        out.writeUTF(this.ticketType);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_44) >= 0) {
            out.writeNullUTF(Objects.toString(this.fromAddress, null));
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_44) >= 0) {
            out.writeUTF(this.summary);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_14) <= 0) {
            out.writeUTF("");
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_15) >= 0 && protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_43) <= 0) {
            out.writeCompressedInt(0);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
            out.writeLong(this.openDate.getTime());
        } else {
            SQLStreamables.writeTimestamp((Timestamp)this.openDate, (DataOutputStream)out);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_43) <= 0) {
            out.writeLong(-1L);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_43) <= 0) {
            out.writeLong(-1L);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_43) <= 0) {
            out.writeNullUTF(null);
        }
        out.writeUTF(this.clientPriority);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_10) < 0) {
            out.writeUTF(this.adminPriority == null ? this.clientPriority : this.adminPriority);
        } else {
            out.writeNullUTF(this.adminPriority);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_43) <= 0) {
            out.writeNullUTF(null);
        }
        out.writeUTF(this.status);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_44) >= 0) {
            if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_0) < 0) {
                out.writeLong(this.statusTimeout == null ? -1L : this.statusTimeout.getTime());
            } else {
                SQLStreamables.writeNullTimestamp((Timestamp)this.statusTimeout, (DataOutputStream)out);
            }
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_125) >= 0 && protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_43) <= 0) {
            out.writeNullUTF(null);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_125) >= 0) {
            if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_22) < 0) {
                out.writeUTF(Strings.join(this.contactEmails, (String)", "));
            } else {
                int size = this.contactEmails.size();
                out.writeCompressedInt(size);
                for (Email email : this.contactEmails) {
                    out.writeUTF(email.toString());
                }
            }
            out.writeUTF(this.contactPhoneNumbers);
        }
    }

    public int getTicketId() {
        return this.pkey;
    }

    public Brand getBrand() throws IOException, SQLException {
        return this.table.getConnector().getReseller().getBrand().get(this.brand);
    }

    public Reseller getReseller() throws SQLException, IOException {
        if (this.reseller == null) {
            return null;
        }
        return this.table.getConnector().getReseller().getReseller().get(this.reseller);
    }

    public Account.Name getAccount_name() {
        return this.accounting;
    }

    public Account getAccount() throws SQLException, IOException {
        if (this.accounting == null) {
            return null;
        }
        return this.table.getConnector().getAccount().getAccount().get(this.accounting);
    }

    public Language getLanguage() throws SQLException, IOException {
        Language la = this.table.getConnector().getTicket().getLanguage().get(this.language);
        if (la == null) {
            throw new SQLException("Unable to find Language: " + this.language);
        }
        return la;
    }

    public Administrator getCreatedBy() throws IOException, SQLException {
        if (this.createdBy == null) {
            return null;
        }
        return this.table.getConnector().getAccount().getAdministrator().get(this.createdBy);
    }

    public Category getCategory() throws IOException, SQLException {
        if (this.category == -1) {
            return null;
        }
        Category tc = this.table.getConnector().getReseller().getCategory().get(this.category);
        if (tc == null) {
            throw new SQLException("Unable to find TicketCategory: " + this.category);
        }
        return tc;
    }

    public TicketType getTicketType() throws IOException, SQLException {
        TicketType ticketTypeObject = this.table.getConnector().getTicket().getTicketType().get(this.ticketType);
        if (ticketTypeObject == null) {
            throw new SQLException("Unable to find TicketType: " + this.ticketType);
        }
        return ticketTypeObject;
    }

    public Email getFromAddress() {
        return this.fromAddress;
    }

    public String getSummary() {
        return this.summary;
    }

    public synchronized String getDetails() throws IOException, SQLException {
        if (!this.detailsLoaded) {
            this.details = this.table.getConnector().requestNullLongStringQuery(true, AoservProtocol.CommandId.GET_TICKET_DETAILS, this.pkey);
            this.detailsLoaded = true;
        }
        return this.details;
    }

    public synchronized String getRawEmail() throws IOException, SQLException {
        if (!this.rawEmailLoaded) {
            this.rawEmail = this.table.getConnector().requestNullLongStringQuery(true, AoservProtocol.CommandId.GET_TICKET_RAW_EMAIL, this.pkey);
            this.rawEmailLoaded = true;
        }
        return this.rawEmail;
    }

    public UnmodifiableTimestamp getOpenDate() {
        return this.openDate;
    }

    public Priority getClientPriority() throws IOException, SQLException {
        Priority clientPriorityObject = this.table.getConnector().getTicket().getPriority().get(this.clientPriority);
        if (clientPriorityObject == null) {
            throw new SQLException("Unable to find Priority: " + this.clientPriority);
        }
        return clientPriorityObject;
    }

    public Priority getAdminPriority() throws IOException, SQLException {
        if (this.adminPriority == null) {
            return null;
        }
        Priority adminPriorityObject = this.table.getConnector().getTicket().getPriority().get(this.adminPriority);
        if (adminPriorityObject == null) {
            throw new SQLException("Unable to find Priority: " + this.adminPriority);
        }
        return adminPriorityObject;
    }

    public Status getStatus() throws IOException, SQLException {
        Status statusObject = this.table.getConnector().getTicket().getStatus().get(this.status);
        if (statusObject == null) {
            throw new SQLException("Unable to find status: " + this.status);
        }
        return statusObject;
    }

    public UnmodifiableTimestamp getStatusTimeout() {
        return this.statusTimeout;
    }

    public Set<Email> getContactEmails() {
        return this.contactEmails;
    }

    public String getContactPhoneNumbers() {
        return this.contactPhoneNumbers;
    }

    public synchronized String getInternalNotes() throws IOException, SQLException {
        if (!this.internalNotesLoaded) {
            this.internalNotes = this.table.getConnector().requestLongStringQuery(true, AoservProtocol.CommandId.GET_TICKET_INTERNAL_NOTES, this.pkey);
            this.internalNotesLoaded = true;
        }
        return this.internalNotes;
    }

    public List<Action> getTicketActions() throws IOException, SQLException {
        return this.table.getConnector().getTicket().getAction().getActions(this);
    }

    public List<Assignment> getTicketAssignments() throws IOException, SQLException {
        return this.table.getConnector().getTicket().getAssignment().getTicketAssignments(this);
    }

    public void actChangeAdminPriority(Priority priority, Administrator administrator, String comments) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.CHANGE_TICKET_ADMIN_PRIORITY, this.pkey, priority == null ? "" : priority.getPriority(), administrator.getUsername_userId(), comments);
    }

    public void setClientPriority(Priority clientPriority) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.CHANGE_TICKET_CLIENT_PRIORITY, this.pkey, clientPriority.getPriority());
    }

    public void setSummary(String summary) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_TICKET_SUMMARY, this.pkey, summary);
    }

    public void addAnnotation(final String summary, final String details) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.ADD_TICKET_ANNOTATION, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Ticket.this.pkey);
                out.writeUTF(summary);
                out.writeNullLongUTF(details);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                Ticket.this.table.getConnector().tablesUpdated(this.invalidateList);
            }
        });
    }

    public void actAssignTo(Administrator assignedTo, Administrator administrator, String comments) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_TICKET_ASSIGNED_TO, this.pkey, assignedTo == null ? "" : assignedTo.getUsername().getUsername(), administrator.getUsername_userId(), comments);
    }

    public void setContactEmails(final Set<Email> contactEmails) throws IOException, SQLException {
        final AoservConnector connector = this.table.getConnector();
        connector.requestUpdate(true, AoservProtocol.CommandId.SET_TICKET_CONTACT_EMAILS, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Ticket.this.pkey);
                out.writeCompressedInt(contactEmails.size());
                for (Email email : contactEmails) {
                    out.writeUTF(email.toString());
                }
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                connector.tablesUpdated(this.invalidateList);
            }
        });
    }

    public void setContactPhoneNumbers(String contactPhoneNumbers) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_TICKET_CONTACT_PHONE_NUMBERS, this.pkey, contactPhoneNumbers);
    }

    public void actWorkEntry(Administrator administrator, String comments) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.TICKET_WORK, this.pkey, administrator.getUsername_userId(), comments);
    }

    public boolean setAccount(Account oldAccount, Account newAccount) throws IOException, SQLException {
        return this.table.getConnector().requestBooleanQueryInvalidating(true, AoservProtocol.CommandId.SET_TICKET_BUSINESS, this.pkey, oldAccount == null ? "" : oldAccount.getName().toString(), newAccount == null ? "" : newAccount.getName().toString());
    }

    public boolean setTicketType(TicketType oldType, TicketType newType) throws IOException, SQLException {
        return this.table.getConnector().requestBooleanQueryInvalidating(true, AoservProtocol.CommandId.CHANGE_TICKET_TYPE, this.pkey, oldType.getType(), newType.getType());
    }

    public boolean setStatus(Status oldStatus, Status newStatus, long statusTimeout) throws IOException, SQLException {
        return this.table.getConnector().requestBooleanQueryInvalidating(true, AoservProtocol.CommandId.SET_TICKET_STATUS, this.pkey, oldStatus.getStatus(), newStatus.getStatus(), statusTimeout);
    }

    public boolean setInternalNotes(final String oldInternalNotes, final String newInternalNotes) throws IOException, SQLException {
        return this.table.getConnector().requestResult(true, AoservProtocol.CommandId.SET_TICKET_INTERNAL_NOTES, new AoservConnector.ResultRequest<Boolean>(){
            private boolean result;
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Ticket.this.pkey);
                out.writeLongUTF(oldInternalNotes);
                out.writeLongUTF(newInternalNotes);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.result = in.readBoolean();
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public Boolean afterRelease() {
                Ticket.this.table.getConnector().tablesUpdated(this.invalidateList);
                return this.result;
            }
        });
    }
}

