/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.ticket;

import com.aoapps.hodgepodge.logging.QueuedHandler;
import com.aoapps.lang.Strings;
import com.aoapps.lang.exception.ConfigurationException;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.AoservClientConfiguration;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.User;
import com.aoindustries.aoserv.client.reseller.Brand;
import com.aoindustries.aoserv.client.reseller.Category;
import com.aoindustries.aoserv.client.ticket.Language;
import com.aoindustries.aoserv.client.ticket.Priority;
import com.aoindustries.aoserv.client.ticket.Ticket;
import com.aoindustries.aoserv.client.ticket.TicketType;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class TicketLoggingHandler
extends QueuedHandler {
    private static final boolean DEBUG = false;
    private static final List<WeakReference<TicketLoggingHandler>> handlers = new ArrayList<WeakReference<TicketLoggingHandler>>();
    private static ExecutorService executor;
    private final String summaryPrefix;
    private final AoservConnector connector;
    private final String categoryDotPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExecutorService getExecutor() {
        List<WeakReference<TicketLoggingHandler>> list = handlers;
        synchronized (list) {
            if (executor == null) {
                executor = Executors.newSingleThreadExecutor(r -> {
                    Thread thread = new Thread(r);
                    thread.setName("Ticket Logger");
                    thread.setDaemon(true);
                    thread.setPriority(4);
                    return thread;
                });
            }
            return executor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TicketLoggingHandler getHandler(String summaryPrefix, AoservConnector connector, String categoryDotPath) {
        List<WeakReference<TicketLoggingHandler>> list = handlers;
        synchronized (list) {
            TicketLoggingHandler handler = null;
            Iterator<WeakReference<TicketLoggingHandler>> iter = handlers.iterator();
            while (iter.hasNext()) {
                WeakReference<TicketLoggingHandler> ref = iter.next();
                TicketLoggingHandler h = (TicketLoggingHandler)((Object)ref.get());
                if (h == null) {
                    iter.remove();
                    continue;
                }
                if (handler != null || h.connector != connector || !Objects.equals(h.summaryPrefix, summaryPrefix) || !Objects.equals(h.categoryDotPath, categoryDotPath)) continue;
                handler = h;
            }
            if (handler == null) {
                handler = new TicketLoggingHandler(summaryPrefix, connector, categoryDotPath);
            }
            return handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TicketLoggingHandler(String summaryPrefix, AoservConnector connector, String categoryDotPath) {
        super(TicketLoggingHandler.getExecutor());
        List<WeakReference<TicketLoggingHandler>> list = handlers;
        synchronized (list) {
            handlers.add(new WeakReference<TicketLoggingHandler>(this));
        }
        this.summaryPrefix = Strings.nullIfEmpty((String)summaryPrefix);
        this.connector = connector;
        this.categoryDotPath = Strings.nullIfEmpty((String)categoryDotPath);
        this.debug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TicketLoggingHandler() throws ConfigurationException {
        super(TicketLoggingHandler.getExecutor());
        List<WeakReference<TicketLoggingHandler>> list = handlers;
        synchronized (list) {
            handlers.add(new WeakReference<TicketLoggingHandler>(this));
        }
        try {
            String password;
            LogManager manager = LogManager.getLogManager();
            String cname = ((Object)((Object)this)).getClass().getName();
            this.summaryPrefix = Strings.trimNullIfEmpty((String)manager.getProperty(cname + ".summaryPrefix"));
            User.Name username = User.Name.valueOf(Strings.trimNullIfEmpty((String)manager.getProperty(cname + ".username")));
            if (username == null) {
                username = AoservClientConfiguration.getUsername();
            }
            if ((password = Strings.trimNullIfEmpty((String)manager.getProperty(cname + ".password"))) == null) {
                password = AoservClientConfiguration.getPassword();
            }
            this.connector = AoservConnector.getConnector(username, password);
            this.categoryDotPath = Strings.trimNullIfEmpty((String)manager.getProperty(cname + ".categoryDotPath"));
        }
        catch (ValidationException e) {
            throw new ConfigurationException((Throwable)e);
        }
        this.debug();
    }

    private void debug() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SecurityException {
        super.close();
        List<WeakReference<TicketLoggingHandler>> list = handlers;
        synchronized (list) {
            boolean hasHandler = false;
            Iterator<WeakReference<TicketLoggingHandler>> iter = handlers.iterator();
            while (iter.hasNext()) {
                WeakReference<TicketLoggingHandler> ref = iter.next();
                TicketLoggingHandler handler = (TicketLoggingHandler)((Object)ref.get());
                if (handler == null || handler == this) {
                    iter.remove();
                    continue;
                }
                hasHandler = true;
            }
            if (!hasHandler) {
                assert (handlers.isEmpty());
                if (executor != null) {
                    TicketLoggingHandler.shutdownExecutor((ExecutorService)executor);
                    executor = null;
                }
            }
        }
    }

    protected void backgroundPublish(Formatter formatter, LogRecord rec, String fullReport) throws IOException, SQLException {
        Category category;
        Account account = this.connector.getCurrentAdministrator().getUsername().getPackage().getAccount();
        Brand brand = account.getBrand();
        if (brand == null) {
            throw new SQLException("Unable to find Brand for connector: " + this.connector);
        }
        Language language = this.connector.getTicket().getLanguage().get("en");
        if (language == null) {
            throw new SQLException("Unable to find Language: en");
        }
        TicketType ticketType = this.connector.getTicket().getTicketType().get("logs");
        if (ticketType == null) {
            throw new SQLException("Unable to find TicketType: logs");
        }
        if (this.categoryDotPath != null) {
            category = this.connector.getReseller().getCategory().getTicketCategoryByDotPath(this.categoryDotPath);
            if (category == null) {
                throw new SQLException("Unable to find Category: " + this.categoryDotPath);
            }
        } else {
            category = null;
        }
        Level level = rec.getLevel();
        StringBuilder tempSb = new StringBuilder();
        tempSb.append('[').append(level).append(']');
        if (this.summaryPrefix != null) {
            tempSb.append(' ').append(this.summaryPrefix);
        }
        tempSb.append(" - ").append(rec.getSourceClassName()).append(" - ").append(rec.getSourceMethodName());
        String summary = tempSb.toString();
        Ticket existingTicket = null;
        for (Ticket ticket : this.connector.getTicket().getTicket()) {
            String status = ticket.getStatus().getStatus();
            if (!"open".equals(status) && !"hold".equals(status) && !"bounced".equals(status) || !brand.equals(ticket.getBrand()) || !account.equals(ticket.getAccount()) || !language.equals(ticket.getLanguage()) || !ticketType.equals(ticket.getTicketType()) || !ticket.getSummary().equals(summary) || !Objects.equals(category, ticket.getCategory())) continue;
            existingTicket = ticket;
            break;
        }
        if (existingTicket != null) {
            existingTicket.addAnnotation(TicketLoggingHandler.generateActionSummary(formatter, rec), fullReport);
        } else {
            String priorityName = TicketLoggingHandler.getPriorityName(level);
            Priority priority = this.connector.getTicket().getPriority().get(priorityName);
            if (priority == null) {
                throw new SQLException("Unable to find TicketPriority: " + priorityName);
            }
            this.connector.getTicket().getTicket().addTicket(brand, account, language, category, ticketType, null, summary, fullReport, priority, Collections.emptySet(), "");
        }
    }

    public static String generateActionSummary(Formatter formatter, LogRecord rec) {
        Throwable thrown;
        StringBuilder tempSb = new StringBuilder();
        String message = formatter.formatMessage(rec);
        if (message != null) {
            message = message.trim();
            int eol = message.indexOf(10);
            boolean doEllipsis = false;
            if (eol != -1) {
                message = message.substring(0, eol).trim();
                doEllipsis = true;
            }
            if (message.length() > 0) {
                tempSb.append(message);
                if (doEllipsis) {
                    tempSb.append('\u2026');
                }
            }
        }
        if ((thrown = rec.getThrown()) != null) {
            int eol;
            if (tempSb.length() > 0) {
                tempSb.append(" - ");
            }
            String thrownMessage = thrown.getMessage();
            boolean doEllipsis = false;
            if (thrownMessage != null && (eol = (thrownMessage = thrownMessage.trim()).indexOf(10)) != -1) {
                thrownMessage = thrownMessage.substring(0, eol).trim();
                doEllipsis = true;
            }
            if (thrownMessage != null && thrownMessage.length() > 0) {
                tempSb.append(thrownMessage);
                if (doEllipsis) {
                    tempSb.append('\u2026');
                }
            } else {
                tempSb.append(thrown.toString());
            }
        }
        return tempSb.toString();
    }

    public static String getPriorityName(Level level) {
        int intLevel = level.intValue();
        String priorityName = intLevel <= Level.CONFIG.intValue() ? "0-Low" : (intLevel <= Level.INFO.intValue() ? "1-Normal" : (intLevel <= Level.WARNING.intValue() ? "2-High" : "3-Urgent"));
        return priorityName;
    }
}

