/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.ticket;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.net.Email;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.Administrator;
import com.aoindustries.aoserv.client.reseller.Brand;
import com.aoindustries.aoserv.client.reseller.Category;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.ticket.Language;
import com.aoindustries.aoserv.client.ticket.Priority;
import com.aoindustries.aoserv.client.ticket.Ticket;
import com.aoindustries.aoserv.client.ticket.TicketType;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class TicketTable
extends CachedTableIntegerKey<Ticket> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("open_date", false), new AoservTable.OrderBy("pkey", false)};

    TicketTable(AoservConnector connector) {
        super(connector, Ticket.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public int addTicket(final Brand brand, final Account business, final Language language, final Category category, final TicketType ticketType, final Email fromAddress, final String summary, final String details, final Priority clientPriority, final Set<Email> contactEmails, final String contactPhoneNumbers) throws IOException, SQLException {
        return this.connector.requestResult(true, AoservProtocol.CommandId.ADD, new AoservConnector.ResultRequest<Integer>(){
            private int pkey;
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Table.TableId.TICKETS.ordinal());
                out.writeUTF(brand.getAccount_name().toString());
                out.writeNullUTF(business == null ? null : business.getName().toString());
                out.writeUTF(language.getCode());
                out.writeCompressedInt(category == null ? -1 : category.getPkey());
                out.writeUTF(ticketType.getType());
                out.writeNullUTF(Objects.toString(fromAddress, null));
                out.writeUTF(summary);
                out.writeNullLongUTF(details);
                out.writeUTF(clientPriority.getPriority());
                int size = contactEmails.size();
                out.writeCompressedInt(size);
                for (Email email : contactEmails) {
                    out.writeUTF(email.toString());
                }
                out.writeUTF(contactPhoneNumbers);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.pkey = in.readCompressedInt();
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public Integer afterRelease() {
                TicketTable.this.connector.tablesUpdated(this.invalidateList);
                return this.pkey;
            }
        });
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.TICKETS;
    }

    @Override
    public Ticket get(int pkey) throws IOException, SQLException {
        return (Ticket)this.getUniqueRow(0, pkey);
    }

    public List<Ticket> getTickets(Account business) throws IOException, SQLException {
        return this.getIndexedRows(3, business.getName());
    }

    public List<Ticket> getCreatedTickets(Administrator ba) throws IOException, SQLException {
        return this.getIndexedRows(5, ba.getUsername_userId());
    }
}

