/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.util;

public final class ApacheEscape {
    public static final String DEFAULT_DOLLAR_VARIABLE = "$";

    private ApacheEscape() {
        throw new AssertionError();
    }

    public static String escape(String dollarVariable, String value) {
        return ApacheEscape.escape(dollarVariable, value, false);
    }

    public static String escape(String dollarVariable, String value, boolean allowVariables) {
        int len = value.length();
        if (len == 0) {
            return "\"\"";
        }
        StringBuilder sb = null;
        boolean quoted = false;
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch == '\u0000') {
                throw new IllegalArgumentException("Null character not allowed in Apache directives");
            }
            if (ch == '\b') {
                throw new IllegalArgumentException("Backspace character not allowed in Apache directives");
            }
            if (ch == '\f') {
                throw new IllegalArgumentException("Form feed character not allowed in Apache directives");
            }
            if (ch == '\n') {
                throw new IllegalArgumentException("Newline character not allowed in Apache directives");
            }
            if (ch == '\r') {
                throw new IllegalArgumentException("Carriage return character not allowed in Apache directives");
            }
            if (ch == ' ' || ch == '\t' || ch == '\'' || ch == '<' || ch == '>') {
                if (sb == null) {
                    sb = new StringBuilder(len * 2).append(value, 0, i);
                }
                if (!quoted) {
                    sb.insert(0, '\"');
                    quoted = true;
                }
                sb.append(ch);
                continue;
            }
            if (ch < ' ') {
                throw new IllegalArgumentException("Control character not allowed in Apache directives: " + ch);
            }
            if (ch == '$' && !allowVariables && i < len - 1 && value.charAt(i + 1) == '{') {
                int endPos = value.indexOf(125, i + 2);
                if (endPos == -1 || endPos == i + 2) {
                    if (sb == null) continue;
                    sb.append('$');
                    continue;
                }
                int colonPos = value.indexOf(58, i + 2);
                if (colonPos != -1 && colonPos < endPos) {
                    if (sb == null) continue;
                    sb.append('$');
                    continue;
                }
                if (dollarVariable == null) {
                    throw new IllegalArgumentException("Unable to escape \"${\", no dollarVariable: " + value);
                }
                if (sb == null) {
                    sb = new StringBuilder(len * 2).append(value, 0, i);
                }
                sb.append("${").append(dollarVariable).append('}');
                continue;
            }
            if (ch == '\\') {
                if (i == len - 1) {
                    if (sb == null) {
                        sb = new StringBuilder(len * 2).append(value, 0, i);
                    }
                    if (!quoted) {
                        sb.insert(0, '\"');
                        quoted = true;
                    }
                    sb.append("\\\\");
                    continue;
                }
                char next = value.charAt(i + 1);
                if (next == '\\' || next == '\"') {
                    if (sb == null) {
                        sb = new StringBuilder(len * 2).append(value, 0, i);
                    }
                    sb.append("\\\\");
                    continue;
                }
                if (sb == null) continue;
                sb.append(ch);
                continue;
            }
            if (ch == '\"') {
                if (sb == null) {
                    sb = new StringBuilder(len * 2).append(value, 0, i);
                }
                if (!quoted) {
                    sb.insert(0, '\"');
                    quoted = true;
                }
                sb.append('\\').append(ch);
                continue;
            }
            if (sb == null) continue;
            sb.append(ch);
        }
        if (sb == null) {
            assert (!quoted);
            return value;
        }
        if (quoted) {
            sb.append('\"');
        }
        return sb.toString();
    }
}

