/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.util;

import com.aoapps.lang.Strings;
import java.nio.charset.StandardCharsets;

public final class SystemdUtil {
    private SystemdUtil() {
        throw new AssertionError();
    }

    public static String encode(String value) {
        if (value == null) {
            return null;
        }
        byte[] utf8 = value.getBytes(StandardCharsets.UTF_8);
        StringBuilder escaped = new StringBuilder(utf8.length);
        for (int i = 0; i < utf8.length; ++i) {
            byte b = utf8[i];
            if (b == 47) {
                escaped.append('-');
                continue;
            }
            if (b == 95 || b >= 65 && b <= 90 || b >= 97 && b <= 122 || b >= 48 && b <= 57 || b == 46 && i > 0) {
                escaped.append((char)b);
                continue;
            }
            if (b == 0) {
                throw new IllegalStateException("Illegal null character in systemd encoding");
            }
            char ch1 = Strings.getHexChar((int)(b >>> 4));
            char ch2 = Strings.getHexChar((int)b);
            escaped.append('\\').append('x').append(ch1).append(ch2);
        }
        return escaped.toString();
    }
}

