/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.util.ApacheEscape;
import com.aoindustries.aoserv.client.web.VirtualHost;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class Header
extends CachedObjectIntegerKey<Header> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_HTTPD_SITE_BIND = 1;
    static final String COLUMN_HTTPD_SITE_BIND_name = "httpd_site_bind";
    static final String COLUMN_SORT_ORDER_name = "sort_order";
    private int httpdSiteBind;
    private short sortOrder;
    private Type type;
    private boolean always;
    private String action;
    private String header;
    private String value;
    private String replacement;
    private String when;
    private String comment;

    @Deprecated
    public Header() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.httpdSiteBind;
            }
            case 2: {
                return this.sortOrder;
            }
            case 3: {
                return this.type.name();
            }
            case 4: {
                return this.always;
            }
            case 5: {
                return this.action;
            }
            case 6: {
                return this.header;
            }
            case 7: {
                return this.value;
            }
            case 8: {
                return this.replacement;
            }
            case 9: {
                return this.when;
            }
            case 10: {
                return this.comment;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public VirtualHost getHttpdSiteBind() throws SQLException, IOException {
        VirtualHost obj = this.table.getConnector().getWeb().getVirtualHost().get(this.httpdSiteBind);
        if (obj == null) {
            throw new SQLException("Unable to find HttpdSiteBind: " + this.httpdSiteBind);
        }
        return obj;
    }

    public short getSortOrder() {
        return this.sortOrder;
    }

    public Type getType() {
        return this.type;
    }

    public boolean getAlways() {
        return this.always;
    }

    public String getAction() {
        return this.action;
    }

    public String getHeader() {
        return this.header;
    }

    public String getValue() {
        return this.value;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public String getWhen() {
        return this.when;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_SITE_BIND_HEADERS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        int pos = 1;
        this.pkey = result.getInt(pos++);
        this.httpdSiteBind = result.getInt(pos++);
        this.sortOrder = result.getShort(pos++);
        this.type = Type.valueOf(result.getString(pos++));
        this.always = result.getBoolean(pos++);
        this.action = result.getString(pos++);
        this.header = result.getString(pos++);
        this.value = result.getString(pos++);
        this.replacement = result.getString(pos++);
        this.when = result.getString(pos++);
        this.comment = result.getString(pos++);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.httpdSiteBind = in.readCompressedInt();
        this.sortOrder = in.readShort();
        this.type = (Type)in.readEnum(Type.class);
        this.always = in.readBoolean();
        this.action = in.readUTF();
        this.header = in.readUTF();
        this.value = in.readNullUTF();
        this.replacement = in.readNullUTF();
        this.when = in.readNullUTF();
        this.comment = in.readNullUTF();
    }

    public String getApacheDirective(String dollarVariable) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.type);
        if (this.always) {
            sb.append(" always");
        }
        sb.append(' ').append(this.action).append(' ').append(ApacheEscape.escape(dollarVariable, this.header));
        if (this.value != null) {
            sb.append(' ').append(ApacheEscape.escape(dollarVariable, this.value, true));
        }
        if (this.replacement != null) {
            sb.append(' ').append(ApacheEscape.escape(dollarVariable, this.replacement, true));
        }
        if (this.when != null) {
            sb.append(' ').append(ApacheEscape.escape(dollarVariable, this.when, true));
        }
        return sb.toString();
    }

    @Override
    public String toStringImpl() {
        return this.getApacheDirective("$");
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.httpdSiteBind);
        out.writeShort((int)this.sortOrder);
        out.writeEnum((Enum)this.type);
        out.writeBoolean(this.always);
        out.writeUTF(this.action);
        out.writeUTF(this.header);
        out.writeNullUTF(this.value);
        out.writeNullUTF(this.replacement);
        out.writeNullUTF(this.when);
        out.writeNullUTF(this.comment);
    }

    public static enum Type {
        Header,
        RequestHeader;

    }
}

