/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.distribution.SoftwareVersion;
import com.aoindustries.aoserv.client.linux.GroupServer;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.util.SystemdUtil;
import com.aoindustries.aoserv.client.web.HttpdBind;
import com.aoindustries.aoserv.client.web.Site;
import com.aoindustries.aoserv.client.web.tomcat.Worker;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public final class HttpdServer
extends CachedObjectIntegerKey<HttpdServer> {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_AO_SERVER = 1;
    static final int COLUMN_PACKAGE = 8;
    static final String COLUMN_AO_SERVER_name = "ao_server";
    static final String COLUMN_NAME_name = "name";
    private int aoServer;
    private String name;
    private boolean canAddSites;
    private int linuxServerAccount;
    private int linuxServerGroup;
    private int modPhpVersion;
    private boolean useSuexec;
    private int packageNum;
    private boolean isShared;
    private boolean useModPerl;
    private int timeout;
    private int maxConcurrency;
    private int monitoringConcurrencyLow;
    private int monitoringConcurrencyMedium;
    private int monitoringConcurrencyHigh;
    private int monitoringConcurrencyCritical;
    private Boolean modAccessCompat;
    private Boolean modActions;
    private Boolean modAlias;
    private Boolean modAuthBasic;
    private Boolean modAuthnCore;
    private Boolean modAuthnFile;
    private Boolean modAuthzCore;
    private Boolean modAuthzGroupfile;
    private Boolean modAuthzHost;
    private Boolean modAuthzUser;
    private Boolean modAutoindex;
    private Boolean modDeflate;
    private Boolean modDir;
    private Boolean modFilter;
    private Boolean modHeaders;
    private Boolean modInclude;
    private Boolean modJk;
    private Boolean modLogConfig;
    private Boolean modMime;
    private Boolean modMimeMagic;
    private Boolean modNegotiation;
    private Boolean modProxy;
    private Boolean modProxyHttp;
    private Boolean modReqtimeout;
    private Boolean modRewrite;
    private Boolean modSetenvif;
    private Boolean modSocacheShmcb;
    private Boolean modSsl;
    private Boolean modStatus;
    private Boolean modWsgi;

    @Deprecated
    public HttpdServer() {
    }

    public boolean canAddSites() {
        return this.canAddSites;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.aoServer;
            }
            case 2: {
                return this.name;
            }
            case 3: {
                return this.canAddSites;
            }
            case 4: {
                return this.linuxServerAccount;
            }
            case 5: {
                return this.linuxServerGroup;
            }
            case 6: {
                return this.modPhpVersion == -1 ? null : Integer.valueOf(this.modPhpVersion);
            }
            case 7: {
                return this.useSuexec;
            }
            case 8: {
                return this.packageNum;
            }
            case 9: {
                return this.isShared;
            }
            case 10: {
                return this.useModPerl;
            }
            case 11: {
                return this.timeout;
            }
            case 12: {
                return this.maxConcurrency;
            }
            case 13: {
                return this.monitoringConcurrencyLow == -1 ? null : Integer.valueOf(this.monitoringConcurrencyLow);
            }
            case 14: {
                return this.monitoringConcurrencyMedium == -1 ? null : Integer.valueOf(this.monitoringConcurrencyMedium);
            }
            case 15: {
                return this.monitoringConcurrencyHigh == -1 ? null : Integer.valueOf(this.monitoringConcurrencyHigh);
            }
            case 16: {
                return this.monitoringConcurrencyCritical == -1 ? null : Integer.valueOf(this.monitoringConcurrencyCritical);
            }
            case 17: {
                return this.modAccessCompat;
            }
            case 18: {
                return this.modActions;
            }
            case 19: {
                return this.modAlias;
            }
            case 20: {
                return this.modAuthBasic;
            }
            case 21: {
                return this.modAuthnCore;
            }
            case 22: {
                return this.modAuthnFile;
            }
            case 23: {
                return this.modAuthzCore;
            }
            case 24: {
                return this.modAuthzGroupfile;
            }
            case 25: {
                return this.modAuthzHost;
            }
            case 26: {
                return this.modAuthzUser;
            }
            case 27: {
                return this.modAutoindex;
            }
            case 28: {
                return this.modDeflate;
            }
            case 29: {
                return this.modDir;
            }
            case 30: {
                return this.modFilter;
            }
            case 31: {
                return this.modHeaders;
            }
            case 32: {
                return this.modInclude;
            }
            case 33: {
                return this.modJk;
            }
            case 34: {
                return this.modLogConfig;
            }
            case 35: {
                return this.modMime;
            }
            case 36: {
                return this.modMimeMagic;
            }
            case 37: {
                return this.modNegotiation;
            }
            case 38: {
                return this.modProxy;
            }
            case 39: {
                return this.modProxyHttp;
            }
            case 40: {
                return this.modReqtimeout;
            }
            case 41: {
                return this.modRewrite;
            }
            case 42: {
                return this.modSetenvif;
            }
            case 43: {
                return this.modSocacheShmcb;
            }
            case 44: {
                return this.modSsl;
            }
            case 45: {
                return this.modStatus;
            }
            case 46: {
                return this.modWsgi;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public List<HttpdBind> getHttpdBinds() throws IOException, SQLException {
        return this.table.getConnector().getWeb().getHttpdBind().getHttpdBinds(this);
    }

    public List<Site> getHttpdSites() throws IOException, SQLException {
        return this.table.getConnector().getWeb().getSite().getHttpdSites(this);
    }

    public List<Worker> getHttpdWorkers() throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getWorker().getHttpdWorkers(this);
    }

    public int getLinuxServerAccount_pkey() {
        return this.linuxServerAccount;
    }

    public UserServer getLinuxServerAccount() throws SQLException, IOException {
        UserServer lsa = this.table.getConnector().getLinux().getUserServer().get(this.linuxServerAccount);
        if (lsa == null) {
            throw new SQLException("Unable to find LinuxServerAccount: " + this.linuxServerAccount);
        }
        return lsa;
    }

    public int getLinuxServerGroup_pkey() {
        return this.linuxServerGroup;
    }

    public GroupServer getLinuxServerGroup() throws SQLException, IOException {
        GroupServer lsg = this.table.getConnector().getLinux().getGroupServer().get(this.linuxServerGroup);
        if (lsg == null) {
            throw new SQLException("Unable to find LinuxServerGroup: " + this.linuxServerGroup);
        }
        return lsg;
    }

    public SoftwareVersion getModPhpVersion() throws SQLException, IOException {
        if (this.modPhpVersion == -1) {
            return null;
        }
        SoftwareVersion tv = this.table.getConnector().getDistribution().getSoftwareVersion().get(this.modPhpVersion);
        if (tv == null) {
            throw new SQLException("Unable to find TechnologyVersion: " + this.modPhpVersion);
        }
        if (tv.getOperatingSystemVersion(this.table.getConnector()).getPkey() != this.getLinuxServer().getHost().getOperatingSystemVersion_id()) {
            throw new SQLException("mod_php/operating system version mismatch on HttpdServer: #" + this.pkey);
        }
        return tv;
    }

    public boolean useSuexec() {
        return this.useSuexec;
    }

    public Package getPackage() throws IOException, SQLException {
        return this.table.getConnector().getBilling().getPackage().get(this.packageNum);
    }

    public boolean isShared() {
        return this.isShared;
    }

    public boolean useModPerl() {
        return this.useModPerl;
    }

    public int getTimeOut() {
        return this.timeout;
    }

    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public int getMonitoringConcurrencyLow() {
        return this.monitoringConcurrencyLow;
    }

    public int getMonitoringConcurrencyMedium() {
        return this.monitoringConcurrencyMedium;
    }

    public int getMonitoringConcurrencyHigh() {
        return this.monitoringConcurrencyHigh;
    }

    public int getMonitoringConcurrencyCritical() {
        return this.monitoringConcurrencyCritical;
    }

    public String getName() {
        return this.name;
    }

    public String getSystemdEscapedName() {
        return SystemdUtil.encode(this.name);
    }

    public Server getLinuxServer() throws SQLException, IOException {
        Server obj = this.table.getConnector().getLinux().getServer().get(this.aoServer);
        if (obj == null) {
            throw new SQLException("Unable to find linux.Server: " + this.aoServer);
        }
        return obj;
    }

    public Boolean getModAccessCompat() {
        return this.modAccessCompat;
    }

    public Boolean getModActions() {
        return this.modActions;
    }

    public Boolean getModAlias() {
        return this.modAlias;
    }

    public Boolean getModAuthBasic() {
        return this.modAuthBasic;
    }

    public Boolean getModAuthnCore() {
        return this.modAuthnCore;
    }

    public Boolean getModAuthnFile() {
        return this.modAuthnFile;
    }

    public Boolean getModAuthzCore() {
        return this.modAuthzCore;
    }

    public Boolean getModAuthzGroupfile() {
        return this.modAuthzGroupfile;
    }

    public Boolean getModAuthzHost() {
        return this.modAuthzHost;
    }

    public Boolean getModAuthzUser() {
        return this.modAuthzUser;
    }

    public Boolean getModAutoindex() {
        return this.modAutoindex;
    }

    public Boolean getModDeflate() {
        return this.modDeflate;
    }

    public Boolean getModDir() {
        return this.modDir;
    }

    public Boolean getModFilter() {
        return this.modFilter;
    }

    public Boolean getModHeaders() {
        return this.modHeaders;
    }

    public Boolean getModInclude() {
        return this.modInclude;
    }

    public Boolean getModJk() {
        return this.modJk;
    }

    public Boolean getModLogConfig() {
        return this.modLogConfig;
    }

    public Boolean getModMime() {
        return this.modMime;
    }

    public Boolean getModMimeMagic() {
        return this.modMimeMagic;
    }

    public Boolean getModNegotiation() {
        return this.modNegotiation;
    }

    public Boolean getModProxy() {
        return this.modProxy;
    }

    public Boolean getModProxyHttp() {
        return this.modProxyHttp;
    }

    public Boolean getModReqtimeout() {
        return this.modReqtimeout;
    }

    public Boolean getModRewrite() {
        return this.modRewrite;
    }

    public Boolean getModSetenvif() {
        return this.modSetenvif;
    }

    public Boolean getModSocacheShmcb() {
        return this.modSocacheShmcb;
    }

    public Boolean getModSsl() {
        return this.modSsl;
    }

    public Boolean getModStatus() {
        return this.modStatus;
    }

    public Boolean getModWsgi() {
        return this.modWsgi;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_SERVERS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        int pos = 1;
        this.pkey = result.getInt(pos++);
        this.aoServer = result.getInt(pos++);
        this.name = result.getString(pos++);
        this.canAddSites = result.getBoolean(pos++);
        this.linuxServerAccount = result.getInt(pos++);
        this.linuxServerGroup = result.getInt(pos++);
        this.modPhpVersion = result.getInt(pos++);
        if (result.wasNull()) {
            this.modPhpVersion = -1;
        }
        this.useSuexec = result.getBoolean(pos++);
        this.packageNum = result.getInt(pos++);
        this.isShared = result.getBoolean(pos++);
        this.useModPerl = result.getBoolean(pos++);
        this.timeout = result.getInt(pos++);
        this.maxConcurrency = result.getInt(pos++);
        this.monitoringConcurrencyLow = result.getInt(pos++);
        if (result.wasNull()) {
            this.monitoringConcurrencyLow = -1;
        }
        this.monitoringConcurrencyMedium = result.getInt(pos++);
        if (result.wasNull()) {
            this.monitoringConcurrencyMedium = -1;
        }
        this.monitoringConcurrencyHigh = result.getInt(pos++);
        if (result.wasNull()) {
            this.monitoringConcurrencyHigh = -1;
        }
        this.monitoringConcurrencyCritical = result.getInt(pos++);
        if (result.wasNull()) {
            this.monitoringConcurrencyCritical = -1;
        }
        this.modAccessCompat = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modAccessCompat = null;
        }
        this.modActions = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modActions = null;
        }
        this.modAlias = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modAlias = null;
        }
        this.modAuthBasic = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modAuthBasic = null;
        }
        this.modAuthnCore = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modAuthnCore = null;
        }
        this.modAuthnFile = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modAuthnFile = null;
        }
        this.modAuthzCore = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modAuthzCore = null;
        }
        this.modAuthzGroupfile = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modAuthzGroupfile = null;
        }
        this.modAuthzHost = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modAuthzHost = null;
        }
        this.modAuthzUser = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modAuthzUser = null;
        }
        this.modAutoindex = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modAutoindex = null;
        }
        this.modDeflate = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modDeflate = null;
        }
        this.modDir = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modDir = null;
        }
        this.modFilter = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modFilter = null;
        }
        this.modHeaders = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modHeaders = null;
        }
        this.modInclude = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modInclude = null;
        }
        this.modJk = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modJk = null;
        }
        this.modLogConfig = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modLogConfig = null;
        }
        this.modMime = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modMime = null;
        }
        this.modMimeMagic = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modMimeMagic = null;
        }
        this.modNegotiation = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modNegotiation = null;
        }
        this.modProxy = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modProxy = null;
        }
        this.modProxyHttp = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modProxyHttp = null;
        }
        this.modReqtimeout = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modReqtimeout = null;
        }
        this.modRewrite = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modRewrite = null;
        }
        this.modSetenvif = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modSetenvif = null;
        }
        this.modSocacheShmcb = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modSocacheShmcb = null;
        }
        this.modSsl = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modSsl = null;
        }
        this.modStatus = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modStatus = null;
        }
        this.modWsgi = result.getBoolean(pos++);
        if (result.wasNull()) {
            this.modWsgi = null;
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.aoServer = in.readCompressedInt();
        this.name = in.readNullUTF();
        this.canAddSites = in.readBoolean();
        this.linuxServerAccount = in.readCompressedInt();
        this.linuxServerGroup = in.readCompressedInt();
        this.modPhpVersion = in.readCompressedInt();
        this.useSuexec = in.readBoolean();
        this.packageNum = in.readCompressedInt();
        this.isShared = in.readBoolean();
        this.useModPerl = in.readBoolean();
        this.timeout = in.readCompressedInt();
        this.maxConcurrency = in.readCompressedInt();
        this.monitoringConcurrencyLow = in.readCompressedInt();
        this.monitoringConcurrencyMedium = in.readCompressedInt();
        this.monitoringConcurrencyHigh = in.readCompressedInt();
        this.monitoringConcurrencyCritical = in.readCompressedInt();
        this.modAccessCompat = in.readNullBoolean();
        this.modActions = in.readNullBoolean();
        this.modAlias = in.readNullBoolean();
        this.modAuthBasic = in.readNullBoolean();
        this.modAuthnCore = in.readNullBoolean();
        this.modAuthnFile = in.readNullBoolean();
        this.modAuthzCore = in.readNullBoolean();
        this.modAuthzGroupfile = in.readNullBoolean();
        this.modAuthzHost = in.readNullBoolean();
        this.modAuthzUser = in.readNullBoolean();
        this.modAutoindex = in.readNullBoolean();
        this.modDeflate = in.readNullBoolean();
        this.modDir = in.readNullBoolean();
        this.modFilter = in.readNullBoolean();
        this.modHeaders = in.readNullBoolean();
        this.modInclude = in.readNullBoolean();
        this.modJk = in.readNullBoolean();
        this.modLogConfig = in.readNullBoolean();
        this.modMime = in.readNullBoolean();
        this.modMimeMagic = in.readNullBoolean();
        this.modNegotiation = in.readNullBoolean();
        this.modProxy = in.readNullBoolean();
        this.modProxyHttp = in.readNullBoolean();
        this.modReqtimeout = in.readNullBoolean();
        this.modRewrite = in.readNullBoolean();
        this.modSetenvif = in.readNullBoolean();
        this.modSocacheShmcb = in.readNullBoolean();
        this.modSsl = in.readNullBoolean();
        this.modStatus = in.readNullBoolean();
        this.modWsgi = in.readNullBoolean();
    }

    @Override
    public String toStringImpl() {
        return this.name == null ? "httpd" : "httpd(" + this.name + ')';
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.aoServer);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_8) < 0) {
            out.writeCompressedInt(this.name == null ? 1 : Integer.parseInt(this.name));
        } else {
            out.writeNullUTF(this.name);
        }
        out.writeBoolean(this.canAddSites);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_9) <= 0) {
            out.writeBoolean(true);
            out.writeCompressedInt(128);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_102) >= 0) {
            out.writeCompressedInt(this.linuxServerAccount);
            out.writeCompressedInt(this.linuxServerGroup);
            out.writeCompressedInt(this.modPhpVersion);
            out.writeBoolean(this.useSuexec);
            out.writeCompressedInt(this.packageNum);
            if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_122) <= 0) {
                out.writeCompressedInt(-1);
            }
            out.writeBoolean(this.isShared);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_103) >= 0) {
            out.writeBoolean(this.useModPerl);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_130) >= 0) {
            out.writeCompressedInt(this.timeout);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_68) >= 0) {
            out.writeCompressedInt(this.maxConcurrency);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_11) >= 0) {
            out.writeCompressedInt(this.monitoringConcurrencyLow);
            out.writeCompressedInt(this.monitoringConcurrencyMedium);
            out.writeCompressedInt(this.monitoringConcurrencyHigh);
            out.writeCompressedInt(this.monitoringConcurrencyCritical);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_7) >= 0) {
            out.writeNullBoolean(this.modAccessCompat);
            out.writeNullBoolean(this.modActions);
            out.writeNullBoolean(this.modAlias);
            out.writeNullBoolean(this.modAuthBasic);
            out.writeNullBoolean(this.modAuthnCore);
            out.writeNullBoolean(this.modAuthnFile);
            out.writeNullBoolean(this.modAuthzCore);
            out.writeNullBoolean(this.modAuthzGroupfile);
            out.writeNullBoolean(this.modAuthzHost);
            out.writeNullBoolean(this.modAuthzUser);
            out.writeNullBoolean(this.modAutoindex);
            out.writeNullBoolean(this.modDeflate);
            out.writeNullBoolean(this.modDir);
            out.writeNullBoolean(this.modFilter);
            out.writeNullBoolean(this.modHeaders);
            out.writeNullBoolean(this.modInclude);
            out.writeNullBoolean(this.modJk);
            out.writeNullBoolean(this.modLogConfig);
            out.writeNullBoolean(this.modMime);
            out.writeNullBoolean(this.modMimeMagic);
            out.writeNullBoolean(this.modNegotiation);
            out.writeNullBoolean(this.modProxy);
            out.writeNullBoolean(this.modProxyHttp);
            out.writeNullBoolean(this.modReqtimeout);
            out.writeNullBoolean(this.modRewrite);
            out.writeNullBoolean(this.modSetenvif);
            out.writeNullBoolean(this.modSocacheShmcb);
            out.writeNullBoolean(this.modSsl);
            out.writeNullBoolean(this.modStatus);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_10) >= 0) {
            out.writeNullBoolean(this.modWsgi);
        }
    }

    public int getConcurrency() throws IOException, SQLException {
        return this.table.getConnector().requestIntQuery(true, AoservProtocol.CommandId.GET_HTTPD_SERVER_CONCURRENCY, this.pkey);
    }
}

