/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.HttpdServer;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;

public final class HttpdServerTable
extends CachedTableIntegerKey<HttpdServer> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("ao_server.hostname", true), new AoservTable.OrderBy("name", true)};

    HttpdServerTable(AoservConnector connector) {
        super(connector, HttpdServer.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public HttpdServer get(int pkey) throws IOException, SQLException {
        return (HttpdServer)this.getUniqueRow(0, pkey);
    }

    public List<HttpdServer> getHttpdServers(Server ao) throws IOException, SQLException {
        return this.getIndexedRows(1, ao.getPkey());
    }

    public List<HttpdServer> getHttpdServers(Package pk) throws IOException, SQLException {
        return this.getIndexedRows(8, pk.getPkey());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_SERVERS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("get_httpd_server_concurrency")) {
            if (Aosh.checkParamCount("get_httpd_server_concurrency", args, 2, (PrintWriter)err)) {
                out.write(Integer.toString(this.connector.getSimpleClient().getHttpdServerConcurrency(args[1], args[2].isEmpty() ? null : args[2])));
                out.flush();
            }
            return true;
        }
        return false;
    }
}

