/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.Site;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public final class Location
extends CachedObjectIntegerKey<Location>
implements Removable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_HTTPD_SITE = 1;
    static final String COLUMN_HTTPD_SITE_name = "httpd_site";
    private int httpdSite;
    private String path;
    private boolean isRegularExpression;
    private String authName;
    private PosixPath authGroupFile;
    private PosixPath authUserFile;
    private String require;
    private String handler;

    private static String validateNonQuoteAscii(String s, String label) {
        for (int c = 0; c < s.length(); ++c) {
            char ch = s.charAt(c);
            if (ch >= ' ' && ch <= '~' && ch != '\"') continue;
            return "Invalid character in " + label + ": " + ch;
        }
        return null;
    }

    public static String validatePath(String path) {
        if (path.length() == 0) {
            return "Location required";
        }
        return Location.validateNonQuoteAscii(path, "Location");
    }

    public static String validateAuthName(String authName) {
        return Location.validateNonQuoteAscii(authName, "AuthName");
    }

    public static String validateAuthGroupFile(PosixPath authGroupFile) {
        if (authGroupFile == null) {
            return null;
        }
        return Location.validateNonQuoteAscii(authGroupFile.toString(), "AuthGroupFile");
    }

    public static String validateAuthUserFile(PosixPath authUserFile) {
        if (authUserFile == null) {
            return null;
        }
        return Location.validateNonQuoteAscii(authUserFile.toString(), "AuthUserFile");
    }

    public static String validateRequire(String require) {
        return Location.validateNonQuoteAscii(require, "Require");
    }

    @Deprecated
    public Location() {
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() {
        return Collections.emptyList();
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.httpdSite;
            }
            case 2: {
                return this.path;
            }
            case 3: {
                return this.isRegularExpression;
            }
            case 4: {
                return this.authName;
            }
            case 5: {
                return this.authGroupFile;
            }
            case 6: {
                return this.authUserFile;
            }
            case 7: {
                return this.require;
            }
            case 8: {
                return this.handler;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Site getHttpdSite() throws SQLException, IOException {
        Site obj = this.table.getConnector().getWeb().getSite().get(this.httpdSite);
        if (obj == null) {
            throw new SQLException("Unable to find HttpdSite: " + this.httpdSite);
        }
        return obj;
    }

    public String getPath() {
        return this.path;
    }

    public boolean getIsRegularExpression() {
        return this.isRegularExpression;
    }

    public String getAuthName() {
        return this.authName;
    }

    public PosixPath getAuthGroupFile() {
        return this.authGroupFile;
    }

    public PosixPath getAuthUserFile() {
        return this.authUserFile;
    }

    public String getRequire() {
        return this.require;
    }

    public String getHandler() {
        return this.handler;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_SITE_AUTHENTICATED_LOCATIONS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.httpdSite = result.getInt(2);
            this.path = result.getString(3);
            this.isRegularExpression = result.getBoolean(4);
            this.authName = result.getString(5);
            String s = result.getString(6);
            this.authGroupFile = s.isEmpty() ? null : PosixPath.valueOf(s);
            s = result.getString(7);
            this.authUserFile = s.isEmpty() ? null : PosixPath.valueOf(s);
            this.require = result.getString(8);
            this.handler = result.getString(9);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.httpdSite = in.readCompressedInt();
            this.path = in.readCompressedUTF();
            this.isRegularExpression = in.readBoolean();
            this.authName = in.readCompressedUTF();
            String s = in.readCompressedUTF();
            this.authGroupFile = s.isEmpty() ? null : PosixPath.valueOf(s);
            s = in.readCompressedUTF();
            this.authUserFile = s.isEmpty() ? null : PosixPath.valueOf(s);
            this.require = in.readCompressedUTF().intern();
            this.handler = in.readBoolean() ? in.readCompressedUTF().intern() : null;
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.HTTPD_SITE_AUTHENTICATED_LOCATIONS, this.pkey});
    }

    public void setAttributes(String path, boolean isRegularExpression, String authName, PosixPath authGroupFile, PosixPath authUserFile, String require, String handler) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_SITE_AUTHENTICATED_LOCATION_ATTRIBUTES, this.pkey, path, isRegularExpression, authName, authGroupFile == null ? "" : authGroupFile.toString(), authUserFile == null ? "" : authUserFile.toString(), require, handler == null ? "" : handler);
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        Site site = this.getHttpdSite();
        return site.toStringImpl() + ':' + this.path;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.httpdSite);
        out.writeCompressedUTF(this.path, 0);
        out.writeBoolean(this.isRegularExpression);
        out.writeCompressedUTF(this.authName, 1);
        out.writeCompressedUTF(this.authGroupFile == null ? "" : this.authGroupFile.toString(), 2);
        out.writeCompressedUTF(this.authUserFile == null ? "" : this.authUserFile.toString(), 3);
        out.writeCompressedUTF(this.require, 4);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_13) >= 0) {
            out.writeBoolean(this.handler != null);
            if (this.handler != null) {
                out.writeCompressedUTF(this.handler, 5);
            }
        }
    }

    public static final class Handler {
        public static final String SERVER_STATUS = "server-status";
        public static final String CURRENT = "*";

        private Handler() {
            throw new AssertionError();
        }
    }
}

