/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.Location;
import com.aoindustries.aoserv.client.web.Site;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;

public final class LocationTable
extends CachedTableIntegerKey<Location> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("httpd_site.name", true), new AoservTable.OrderBy("httpd_site.ao_server.hostname", true)};

    LocationTable(AoservConnector connector) {
        super(connector, Location.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addHttpdSiteAuthenticatedLocation(Site hs, String path, boolean isRegularExpression, String authName, PosixPath authGroupFile, PosixPath authUserFile, String require, String handler) throws IOException, SQLException {
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.HTTPD_SITE_AUTHENTICATED_LOCATIONS, hs.getPkey(), path, isRegularExpression, authName, authGroupFile == null ? "" : authGroupFile.toString(), authUserFile == null ? "" : authUserFile.toString(), require, handler == null ? "" : handler});
    }

    @Override
    public Location get(int pkey) throws IOException, SQLException {
        return (Location)this.getUniqueRow(0, pkey);
    }

    List<Location> getHttpdSiteAuthenticatedLocations(Site site) throws IOException, SQLException {
        return this.getIndexedRows(1, site.getPkey());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_SITE_AUTHENTICATED_LOCATIONS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, SQLException, IOException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_httpd_site_authenticated_location")) {
            if (Aosh.checkParamCount("add_httpd_site_authenticated_location", args, 9, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addHttpdSiteAuthenticatedLocation(args[1], args[2], args[3], Aosh.parseBoolean(args[4], "is_regular_expression"), args[5], args[6].isEmpty() ? null : Aosh.parseUnixPath(args[6], "auth_group_file"), args[7].isEmpty() ? null : Aosh.parseUnixPath(args[7], "auth_user_file"), args[8], args[9].isEmpty() ? null : args[9]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_site_authenticated_location_attributes")) {
            if (Aosh.checkParamCount("set_httpd_site_authenticated_location_attributes", args, 9, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSiteAuthenticatedLocationAttributes(args[1], args[2], args[3], Aosh.parseBoolean(args[4], "is_regular_expression"), args[5], args[6].isEmpty() ? null : Aosh.parseUnixPath(args[6], "auth_group_file"), args[7].isEmpty() ? null : Aosh.parseUnixPath(args[7], "auth_user_file"), args[8], args[9].isEmpty() ? null : args[9]);
            }
            return true;
        }
        return false;
    }
}

