/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.util.ApacheEscape;
import com.aoindustries.aoserv.client.web.VirtualHost;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;

public final class RewriteRule
extends CachedObjectIntegerKey<RewriteRule> {
    static final int COLUMN_id = 0;
    static final int COLUMN_virtualHost = 1;
    static final String COLUMN_virtualHost_name = "virtualHost";
    static final String COLUMN_sortOrder_name = "sortOrder";
    private int virtualHost;
    private short sortOrder;
    private String pattern;
    private String substitution;
    private String flags;
    private String comment;

    @Deprecated
    public RewriteRule() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.virtualHost;
            }
            case 2: {
                return this.sortOrder;
            }
            case 3: {
                return this.pattern;
            }
            case 4: {
                return this.substitution;
            }
            case 5: {
                return this.flags;
            }
            case 6: {
                return this.comment;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getId() {
        return this.pkey;
    }

    public int getVirtualHost_id() {
        return this.virtualHost;
    }

    public VirtualHost getVirtualHost() throws SQLException, IOException {
        VirtualHost obj = this.table.getConnector().getWeb().getVirtualHost().get(this.virtualHost);
        if (obj == null) {
            throw new SQLException("Unable to find VirtualHost: " + this.virtualHost);
        }
        return obj;
    }

    public short getSortOrder() {
        return this.sortOrder;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getSubstitution() {
        return this.substitution;
    }

    public String getFlags() {
        return this.flags;
    }

    public boolean hasFlag(String flag) {
        String flagUpper;
        if (this.flags == null) {
            return false;
        }
        String flagsUpper = this.flags.toUpperCase(Locale.ROOT);
        return flagsUpper.equals(flagUpper = flag.toUpperCase(Locale.ROOT)) || flagsUpper.startsWith(flagUpper + ',') || flagsUpper.startsWith(flagUpper + '=') || flagsUpper.endsWith(',' + flagUpper) || flagsUpper.contains(',' + flagUpper + ',') || flagsUpper.contains(',' + flagUpper + '=');
    }

    public boolean hasFlag(String ... flags) {
        if (flags == null) {
            return false;
        }
        for (String flag : flags) {
            if (!this.hasFlag(flag)) continue;
            return true;
        }
        return false;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.RewriteRule;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        int pos = 1;
        this.pkey = result.getInt(pos++);
        this.virtualHost = result.getInt(pos++);
        this.sortOrder = result.getShort(pos++);
        this.pattern = result.getString(pos++);
        this.substitution = result.getString(pos++);
        this.flags = result.getString(pos++);
        this.comment = result.getString(pos++);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.virtualHost = in.readCompressedInt();
        this.sortOrder = in.readShort();
        this.pattern = in.readUTF();
        this.substitution = in.readUTF();
        this.flags = in.readNullUTF();
        this.comment = in.readNullUTF();
    }

    public String getApacheDirective(String dollarVariable) {
        StringBuilder sb = new StringBuilder();
        sb.append("RewriteRule ").append(ApacheEscape.escape(dollarVariable, this.pattern)).append(' ').append(ApacheEscape.escape(dollarVariable, this.substitution));
        if (this.flags != null) {
            sb.append(' ').append(ApacheEscape.escape(dollarVariable, '[' + this.flags + ']'));
        }
        return sb.toString();
    }

    @Override
    public String toStringImpl() {
        return this.getApacheDirective("$");
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.virtualHost);
        out.writeShort((int)this.sortOrder);
        out.writeUTF(this.pattern);
        out.writeUTF(this.substitution);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_21) >= 0) {
            out.writeNullUTF(this.flags);
        }
        out.writeNullUTF(this.comment);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_4) >= 0 && protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_20) <= 0) {
            out.writeBoolean(this.hasFlag("NE", "noescape"));
        }
    }
}

