/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.util.BufferManager;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.Email;
import com.aoapps.net.Port;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Disablable;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.account.DisableLog;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.distribution.SoftwareVersion;
import com.aoindustries.aoserv.client.linux.Group;
import com.aoindustries.aoserv.client.linux.GroupServer;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.HttpdServer;
import com.aoindustries.aoserv.client.web.Location;
import com.aoindustries.aoserv.client.web.StaticSite;
import com.aoindustries.aoserv.client.web.VirtualHost;
import com.aoindustries.aoserv.client.web.VirtualHostName;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public final class Site
extends CachedObjectIntegerKey<Site>
implements Disablable,
Removable {
    static final int COLUMN_ID = 0;
    static final int COLUMN_AO_SERVER = 1;
    static final int COLUMN_PACKAGE = 4;
    public static final String COLUMN_NAME_name = "name";
    public static final String COLUMN_AO_SERVER_name = "ao_server";
    public static final int MAX_NAME_LENGTH = 255;
    public static final String DISABLED = "disabled";
    private int aoServer;
    private String name;
    private boolean listFirst;
    private Account.Name packageName;
    private User.Name linuxAccount;
    private Group.Name linuxGroup;
    private Email serverAdmin;
    private int disableLog;
    private boolean isManual;
    private String awstatsSkipFiles;
    private int phpVersion;
    private boolean enableCgi;
    private boolean enableSsi;
    private boolean enableHtaccess;
    private boolean enableIndexes;
    private boolean enableFollowSymlinks;
    private boolean enableAnonymousFtp;
    private boolean blockTraceTrack;
    private boolean blockScm;
    private boolean blockCoreDumps;
    private boolean blockEditorBackups;

    @Deprecated
    public Site() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.aoServer;
            }
            case 2: {
                return this.name;
            }
            case 3: {
                return this.listFirst;
            }
            case 4: {
                return this.packageName;
            }
            case 5: {
                return this.linuxAccount;
            }
            case 6: {
                return this.linuxGroup;
            }
            case 7: {
                return this.serverAdmin;
            }
            case 8: {
                return this.disableLog == -1 ? null : Integer.valueOf(this.disableLog);
            }
            case 9: {
                return this.isManual;
            }
            case 10: {
                return this.awstatsSkipFiles;
            }
            case 11: {
                return this.phpVersion == -1 ? null : Integer.valueOf(this.phpVersion);
            }
            case 12: {
                return this.enableCgi;
            }
            case 13: {
                return this.enableSsi;
            }
            case 14: {
                return this.enableHtaccess;
            }
            case 15: {
                return this.enableIndexes;
            }
            case 16: {
                return this.enableFollowSymlinks;
            }
            case 17: {
                return this.enableAnonymousFtp;
            }
            case 18: {
                return this.blockTraceTrack;
            }
            case 19: {
                return this.blockScm;
            }
            case 20: {
                return this.blockCoreDumps;
            }
            case 21: {
                return this.blockEditorBackups;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getId() {
        return this.pkey;
    }

    public int getAoServer_server_pkey() {
        return this.aoServer;
    }

    public Server getLinuxServer() throws SQLException, IOException {
        Server obj = this.table.getConnector().getLinux().getServer().get(this.aoServer);
        if (obj == null) {
            throw new SQLException("Unable to find linux.Server: " + this.aoServer);
        }
        return obj;
    }

    public String getName() {
        return this.name;
    }

    public boolean getListFirst() {
        return this.listFirst;
    }

    public Account.Name getPackage_name() {
        return this.packageName;
    }

    public Package getPackage() throws SQLException, IOException {
        Package obj = this.table.getConnector().getBilling().getPackage().get(this.packageName);
        if (obj == null) {
            throw new SQLException("Unable to find Package: " + this.packageName);
        }
        return obj;
    }

    public User.Name getLinuxAccount_username() {
        return this.linuxAccount;
    }

    public UserServer getLinuxServerAccount() throws SQLException, IOException {
        User obj = this.table.getConnector().getLinux().getUser().get(this.linuxAccount);
        if (obj == null) {
            return null;
        }
        UserServer lsa = obj.getLinuxServerAccount(this.getLinuxServer());
        if (lsa == null) {
            throw new SQLException("Unable to find LinuxServerAccount: " + this.linuxAccount + " on " + this.aoServer);
        }
        return lsa;
    }

    public Group.Name getLinuxGroup_name() {
        return this.linuxGroup;
    }

    public GroupServer getLinuxServerGroup() throws SQLException, IOException {
        Group obj = this.table.getConnector().getLinux().getGroup().get(this.linuxGroup);
        if (obj == null) {
            throw new SQLException("Unable to find LinuxGroup: " + this.linuxGroup);
        }
        GroupServer lsg = obj.getLinuxServerGroup(this.getLinuxServer());
        if (lsg == null) {
            throw new SQLException("Unable to find LinuxServerGroup: " + this.linuxGroup + " on " + this.aoServer);
        }
        return lsg;
    }

    public Email getServerAdmin() {
        return this.serverAdmin;
    }

    public Integer getDisableLog_pkey() {
        return this.disableLog == -1 ? null : Integer.valueOf(this.disableLog);
    }

    @Override
    public DisableLog getDisableLog() throws SQLException, IOException {
        if (this.disableLog == -1) {
            return null;
        }
        DisableLog obj = this.table.getConnector().getAccount().getDisableLog().get(this.disableLog);
        if (obj == null) {
            throw new SQLException("Unable to find DisableLog: " + this.disableLog);
        }
        return obj;
    }

    public boolean isManual() {
        return this.isManual;
    }

    public String getAwstatsSkipFiles() {
        return this.awstatsSkipFiles;
    }

    public Integer getPhpVersion_pkey() {
        return this.phpVersion == -1 ? null : Integer.valueOf(this.phpVersion);
    }

    public SoftwareVersion getPhpVersion() throws IOException, SQLException {
        if (this.phpVersion == -1) {
            return null;
        }
        SoftwareVersion tv = this.table.getConnector().getDistribution().getSoftwareVersion().get(this.phpVersion);
        if (tv == null) {
            throw new SQLException("TechnologyVersion not found: " + this.phpVersion);
        }
        if (!tv.getTechnologyName_name().equals("php")) {
            throw new SQLException("Not a PHP version: " + tv.getTechnologyName_name() + " #" + tv.getPkey());
        }
        if (tv.getOperatingSystemVersion(this.table.getConnector()).getPkey() != this.getLinuxServer().getHost().getOperatingSystemVersion_id()) {
            throw new SQLException("php/operating system version mismatch on HttpdSite: #" + this.pkey);
        }
        return tv;
    }

    public boolean getEnableCgi() {
        return this.enableCgi;
    }

    public boolean getEnableSsi() {
        return this.enableSsi;
    }

    public boolean getEnableHtaccess() {
        return this.enableHtaccess;
    }

    public boolean getEnableIndexes() {
        return this.enableIndexes;
    }

    public boolean getEnableFollowSymlinks() {
        return this.enableFollowSymlinks;
    }

    public boolean getEnableAnonymousFtp() {
        return this.enableAnonymousFtp;
    }

    public boolean getBlockTraceTrack() {
        return this.blockTraceTrack;
    }

    public boolean getBlockScm() {
        return this.blockScm;
    }

    public boolean getBlockCoreDumps() {
        return this.blockCoreDumps;
    }

    public boolean getBlockEditorBackups() {
        return this.blockEditorBackups;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.aoServer = result.getInt(pos++);
            this.name = result.getString(pos++);
            this.listFirst = result.getBoolean(pos++);
            this.packageName = Account.Name.valueOf(result.getString(pos++));
            this.linuxAccount = User.Name.valueOf(result.getString(pos++));
            this.linuxGroup = Group.Name.valueOf(result.getString(pos++));
            this.serverAdmin = Email.valueOf((String)result.getString(pos++));
            this.disableLog = result.getInt(pos++);
            if (result.wasNull()) {
                this.disableLog = -1;
            }
            this.isManual = result.getBoolean(pos++);
            this.awstatsSkipFiles = result.getString(pos++);
            this.phpVersion = result.getInt(pos++);
            if (result.wasNull()) {
                this.phpVersion = -1;
            }
            this.enableCgi = result.getBoolean(pos++);
            this.enableSsi = result.getBoolean(pos++);
            this.enableHtaccess = result.getBoolean(pos++);
            this.enableIndexes = result.getBoolean(pos++);
            this.enableFollowSymlinks = result.getBoolean(pos++);
            this.enableAnonymousFtp = result.getBoolean(pos++);
            this.blockTraceTrack = result.getBoolean(pos++);
            this.blockScm = result.getBoolean(pos++);
            this.blockCoreDumps = result.getBoolean(pos++);
            this.blockEditorBackups = result.getBoolean(pos++);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.aoServer = in.readCompressedInt();
            this.name = in.readUTF();
            this.listFirst = in.readBoolean();
            this.packageName = Account.Name.valueOf(in.readUTF()).intern();
            this.linuxAccount = User.Name.valueOf(in.readUTF()).intern();
            this.linuxGroup = Group.Name.valueOf(in.readUTF()).intern();
            this.serverAdmin = Email.valueOf((String)in.readUTF());
            this.disableLog = in.readCompressedInt();
            this.isManual = in.readBoolean();
            this.awstatsSkipFiles = in.readNullUTF();
            this.phpVersion = in.readCompressedInt();
            this.enableCgi = in.readBoolean();
            this.enableSsi = in.readBoolean();
            this.enableHtaccess = in.readBoolean();
            this.enableIndexes = in.readBoolean();
            this.enableFollowSymlinks = in.readBoolean();
            this.enableAnonymousFtp = in.readBoolean();
            this.blockTraceTrack = in.readBoolean();
            this.blockScm = in.readBoolean();
            this.blockCoreDumps = in.readBoolean();
            this.blockEditorBackups = in.readBoolean();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.aoServer);
        out.writeUTF(this.name);
        out.writeBoolean(this.listFirst);
        out.writeUTF(this.packageName.toString());
        out.writeUTF(this.linuxAccount.toString());
        out.writeUTF(this.linuxGroup.toString());
        out.writeUTF(this.serverAdmin.toString());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_9) <= 0) {
            out.writeNullUTF(null);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeShort(0);
            out.writeShort(7);
            out.writeShort(0);
            out.writeShort(7);
            out.writeShort(0);
            out.writeShort(7);
            out.writeShort(0);
            out.writeShort(7);
        }
        out.writeCompressedInt(this.disableLog);
        out.writeBoolean(this.isManual);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_0_A_129) >= 0) {
            out.writeNullUTF(this.awstatsSkipFiles);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_78) >= 0) {
            out.writeCompressedInt(this.phpVersion);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_79) >= 0) {
            out.writeBoolean(this.enableCgi);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_80_1) >= 0) {
            out.writeBoolean(this.enableSsi);
            out.writeBoolean(this.enableHtaccess);
            out.writeBoolean(this.enableIndexes);
            out.writeBoolean(this.enableFollowSymlinks);
            out.writeBoolean(this.enableAnonymousFtp);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_6) >= 0) {
            out.writeBoolean(this.blockTraceTrack);
            out.writeBoolean(this.blockScm);
            out.writeBoolean(this.blockCoreDumps);
            out.writeBoolean(this.blockEditorBackups);
        }
    }

    public int addHttpdSiteAuthenticatedLocation(String path, boolean isRegularExpression, String authName, PosixPath authGroupFile, PosixPath authUserFile, String require, String handler) throws IOException, SQLException {
        return this.table.getConnector().getWeb().getLocation().addHttpdSiteAuthenticatedLocation(this, path, isRegularExpression, authName, authGroupFile, authUserFile, require, handler);
    }

    @Override
    public boolean canDisable() throws IOException, SQLException {
        if (this.disableLog != -1) {
            return false;
        }
        for (VirtualHost hsb : this.getHttpdSiteBinds()) {
            if (hsb.isDisabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canEnable() throws SQLException, IOException {
        DisableLog dl = this.getDisableLog();
        if (dl == null) {
            return false;
        }
        return dl.canEnable() && !this.getPackage().isDisabled() && !this.getLinuxServerAccount().isDisabled();
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() {
        return Collections.emptyList();
    }

    @Override
    public void disable(DisableLog dl) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.DISABLE, new Object[]{Table.TableId.HTTPD_SITES, dl.getPkey(), this.pkey});
    }

    @Override
    public void enable() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.ENABLE, new Object[]{Table.TableId.HTTPD_SITES, this.pkey});
    }

    public PosixPath getInstallDirectory() throws SQLException, IOException {
        try {
            return PosixPath.valueOf(this.getLinuxServer().getHost().getOperatingSystemVersion().getHttpdSitesDirectory() + "/" + this.name);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean isDisabled() {
        return this.disableLog != -1;
    }

    public List<Location> getHttpdSiteAuthenticatedLocations() throws IOException, SQLException {
        return this.table.getConnector().getWeb().getLocation().getHttpdSiteAuthenticatedLocations(this);
    }

    public List<VirtualHost> getHttpdSiteBinds() throws IOException, SQLException {
        return this.table.getConnector().getWeb().getVirtualHost().getHttpdSiteBinds(this);
    }

    public List<VirtualHost> getHttpdSiteBinds(HttpdServer server) throws SQLException, IOException {
        return this.table.getConnector().getWeb().getVirtualHost().getHttpdSiteBinds(this, server);
    }

    public StaticSite getHttpdStaticSite() throws IOException, SQLException {
        return this.table.getConnector().getWeb().getStaticSite().get(this.pkey);
    }

    public com.aoindustries.aoserv.client.web.tomcat.Site getHttpdTomcatSite() throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getSite().get(this.pkey);
    }

    public VirtualHostName getPrimaryVirtualHostName() throws SQLException, IOException {
        Bind nb;
        List<VirtualHost> binds = this.getHttpdSiteBinds();
        if (binds.isEmpty()) {
            return null;
        }
        Port httpPort = this.table.getConnector().getNet().getAppProtocol().get("HTTP").getPort();
        Port httpsPort = this.table.getConnector().getNet().getAppProtocol().get("HTTPS").getPort();
        for (VirtualHost bind : binds) {
            if (bind.getName() != null || !"HTTPS".equals((nb = bind.getHttpdBind().getNetBind()).getAppProtocol().getProtocol()) || !nb.getPort().equals((Object)httpsPort)) continue;
            return bind.getPrimaryVirtualHostName();
        }
        for (VirtualHost bind : binds) {
            if (bind.getName() != null || !"HTTP".equals((nb = bind.getHttpdBind().getNetBind()).getAppProtocol().getProtocol()) || !nb.getPort().equals((Object)httpPort)) continue;
            return bind.getPrimaryVirtualHostName();
        }
        for (VirtualHost bind : binds) {
            if (bind.getName() != null || !"HTTPS".equals((nb = bind.getHttpdBind().getNetBind()).getAppProtocol().getProtocol())) continue;
            return bind.getPrimaryVirtualHostName();
        }
        for (VirtualHost bind : binds) {
            if (bind.getName() != null || !"HTTP".equals((nb = bind.getHttpdBind().getNetBind()).getAppProtocol().getProtocol())) continue;
            return bind.getPrimaryVirtualHostName();
        }
        for (VirtualHost bind : binds) {
            nb = bind.getHttpdBind().getNetBind();
            if (!"HTTPS".equals(nb.getAppProtocol().getProtocol()) || !nb.getPort().equals((Object)httpsPort)) continue;
            return bind.getPrimaryVirtualHostName();
        }
        for (VirtualHost bind : binds) {
            nb = bind.getHttpdBind().getNetBind();
            if (!"HTTP".equals(nb.getAppProtocol().getProtocol()) || !nb.getPort().equals((Object)httpPort)) continue;
            return bind.getPrimaryVirtualHostName();
        }
        for (VirtualHost bind : binds) {
            nb = bind.getHttpdBind().getNetBind();
            if (!"HTTPS".equals(nb.getAppProtocol().getProtocol())) continue;
            return bind.getPrimaryVirtualHostName();
        }
        for (VirtualHost bind : binds) {
            nb = bind.getHttpdBind().getNetBind();
            if (!"HTTP".equals(nb.getAppProtocol().getProtocol())) continue;
            return bind.getPrimaryVirtualHostName();
        }
        return binds.get(0).getPrimaryVirtualHostName();
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_SITES;
    }

    public static boolean isValidSiteName(String name) {
        if (DISABLED.equals(name) || "cache".equals(name) || "fastcgi".equals(name) || "error".equals(name) || "icons".equals(name) || "cgi-bin".equals(name) || "html".equals(name) || "mrtg".equals(name) || "lost+found".equals(name) || "aquota.group".equals(name) || "aquota.user".equals(name)) {
            return false;
        }
        int len = name.length();
        if (len == 0 || len > 255) {
            return false;
        }
        char ch = name.charAt(0);
        if (!(ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9')) {
            return false;
        }
        for (int c = 1; c < len; ++c) {
            ch = name.charAt(c);
            if (ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '.' || ch == '-') continue;
            return false;
        }
        return true;
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.HTTPD_SITES, this.pkey});
    }

    public void setIsManual(boolean isManual) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_SITE_IS_MANUAL, this.pkey, isManual);
    }

    public void setServerAdmin(Email address) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_SITE_SERVER_ADMIN, this.pkey, address);
    }

    public void setPhpVersion(SoftwareVersion phpVersion) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_SITE_PHP_VERSION, this.pkey, phpVersion == null ? -1 : phpVersion.getPkey());
    }

    public void setEnableCgi(boolean enableCgi) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_SITE_ENABLE_CGI, this.pkey, enableCgi);
    }

    public void setEnableSsi(boolean enableSsi) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_SITE_ENABLE_SSI, this.pkey, enableSsi);
    }

    public void setEnableHtaccess(boolean enableHtaccess) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_SITE_ENABLE_HTACCESS, this.pkey, enableHtaccess);
    }

    public void setEnableIndexes(boolean enableIndexes) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_SITE_ENABLE_INDEXES, this.pkey, enableIndexes);
    }

    public void setEnableFollowSymlinks(boolean enableFollowSymlinks) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_SITE_ENABLE_FOLLOW_SYMLINKS, this.pkey, enableFollowSymlinks);
    }

    public void setEnableAnonymousFtp(boolean enableAnonymousFtp) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_SITE_ENABLE_ANONYMOUS_FTP, this.pkey, enableAnonymousFtp);
    }

    public void setBlockTraceTrack(boolean blockTraceTrack) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_SITE_BLOCK_TRACE_TRACK, this.pkey, blockTraceTrack);
    }

    public void setBlockScm(boolean blockScm) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_SITE_BLOCK_SCM, this.pkey, blockScm);
    }

    public void setBlockCoreDumps(boolean blockCoreDumps) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_SITE_BLOCK_CORE_DUMPS, this.pkey, blockCoreDumps);
    }

    public void setBlockEditorBackups(boolean blockEditorBackups) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_SITE_BLOCK_EDITOR_BACKUPS, this.pkey, blockEditorBackups);
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.name + " on " + this.getLinuxServer().getHostname();
    }

    public void getAwstatsFile(final String path, final String queryString, final OutputStream out) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(false, AoservProtocol.CommandId.GET_AWSTATS_FILE, new AoservConnector.UpdateRequest(){

            @Override
            public void writeRequest(StreamableOutput masterOut) throws IOException {
                masterOut.writeCompressedInt(Site.this.pkey);
                masterOut.writeUTF(path);
                masterOut.writeUTF(queryString == null ? "" : queryString);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte[] buff = BufferManager.getBytes();
                try {
                    byte code;
                    while ((code = in.readByte()) == 0) {
                        short len = in.readShort();
                        in.readFully(buff, 0, (int)len);
                        out.write(buff, 0, len);
                    }
                    AoservProtocol.checkResult(code, in);
                }
                finally {
                    BufferManager.release((byte[])buff, (boolean)false);
                }
            }

            @Override
            public void afterRelease() {
            }
        });
    }
}

