/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.lang.io.WriterOutputStream;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.SimpleAoservClient;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.HttpdServer;
import com.aoindustries.aoserv.client.web.Site;
import com.aoindustries.aoserv.client.web.VirtualHost;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class SiteTable
extends CachedTableIntegerKey<Site> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("name", true), new AoservTable.OrderBy("ao_server.hostname", true)};

    SiteTable(AoservConnector connector) {
        super(connector, Site.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public String generateSiteName(String template) throws IOException, SQLException {
        return this.connector.requestStringQuery(true, AoservProtocol.CommandId.GENERATE_SITE_NAME, template);
    }

    @Override
    public Site get(int id) throws IOException, SQLException {
        return (Site)this.getUniqueRow(0, id);
    }

    public Site getHttpdSite(String siteName, Server ao) throws IOException, SQLException {
        int aoPkey = ao.getPkey();
        List cached = this.getRows();
        int size = cached.size();
        for (int c = 0; c < size; ++c) {
            Site site = (Site)cached.get(c);
            if (site.getAoServer_server_pkey() != aoPkey || !site.getName().equals(siteName)) continue;
            return site;
        }
        return null;
    }

    List<Site> getHttpdSites(HttpdServer server) throws IOException, SQLException {
        int serverPkey = server.getPkey();
        List cached = this.getRows();
        int size = cached.size();
        ArrayList<Site> matches = new ArrayList<Site>(size);
        block0: for (int c = 0; c < size; ++c) {
            Site site = (Site)cached.get(c);
            for (VirtualHost bind : site.getHttpdSiteBinds()) {
                if (bind.getHttpdBind().getHttpdServer_pkey() != serverPkey) continue;
                matches.add(site);
                continue block0;
            }
        }
        return matches;
    }

    public List<Site> getHttpdSites(Server ao) throws IOException, SQLException {
        return this.getIndexedRows(1, ao.getPkey());
    }

    public List<Site> getHttpdSites(Package pk) throws IOException, SQLException {
        return this.getIndexedRows(4, pk.getName());
    }

    public List<Site> getHttpdSites(UserServer lsa) throws IOException, SQLException {
        User.Name lsaUsername = lsa.getLinuxAccount_username_id();
        int aoServer = lsa.getAoServer_server_id();
        List cached = this.getRows();
        int size = cached.size();
        ArrayList<Site> matches = new ArrayList<Site>(size);
        for (int c = 0; c < size; ++c) {
            Site site = (Site)cached.get(c);
            if (site.getAoServer_server_pkey() != aoServer || !site.getLinuxAccount_username().equals(lsaUsername)) continue;
            matches.add(site);
        }
        return matches;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_SITES;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, SQLException, IOException {
        String command = args[0];
        if (command.equalsIgnoreCase("check_site_name")) {
            if (Aosh.checkParamCount("check_site_name", args, 1, (PrintWriter)err)) {
                try {
                    SimpleAoservClient.checkSiteName(args[1]);
                    out.println("true");
                }
                catch (IllegalArgumentException iae) {
                    out.print("aosh: check_site_name: ");
                    out.println(iae.getMessage());
                }
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("disable_httpd_site")) {
            if (Aosh.checkParamCount("disable_httpd_site", args, 3, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().disableHttpdSite(args[1], args[2], args[3]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("enable_httpd_site")) {
            if (Aosh.checkParamCount("enable_httpd_site", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().enableHttpdSite(args[1], args[2]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("generate_site_name")) {
            if (Aosh.checkParamCount("generate_site_name", args, 1, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().generateSiteName(args[1]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("get_awstats_file")) {
            if (Aosh.checkParamCount("get_awstats_file", args, 4, (PrintWriter)err)) {
                this.connector.getSimpleClient().getAwstatsFile(args[1], args[2], args[3], args[4], (OutputStream)new WriterOutputStream((Writer)out));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("is_site_name_available")) {
            if (Aosh.checkParamCount("is_site_name_available", args, 1, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().isSiteNameAvailable(args[1]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_httpd_site")) {
            if (Aosh.checkParamCount("remove_httpd_site", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeHttpdSite(args[1], args[2]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_site_server_admin")) {
            if (Aosh.checkParamCount("set_httpd_site_server_admin", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSiteServerAdmin(args[1], args[2], Aosh.parseEmail(args[3], "email_address"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_site_is_manual")) {
            if (Aosh.checkParamCount("set_httpd_site_is_manual", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSiteIsManual(args[1], args[2], Aosh.parseBoolean(args[3], "is_manual"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("wait_for_httpd_site_rebuild")) {
            if (Aosh.checkParamCount("wait_for_httpd_site_rebuild", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().waitForHttpdSiteRebuild(args[1]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_site_php_version")) {
            if (Aosh.checkParamCount("set_httpd_site_php_version", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSitePhpVersion(args[1], args[2], args[3]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_site_enable_cgi")) {
            if (Aosh.checkParamCount("set_httpd_site_enable_cgi", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSiteEnableCgi(args[1], args[2], Aosh.parseBoolean(args[3], "enable_cgi"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_site_enable_ssi")) {
            if (Aosh.checkParamCount("set_httpd_site_enable_ssi", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSiteEnableSsi(args[1], args[2], Aosh.parseBoolean(args[3], "enable_ssi"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_site_enable_htaccess")) {
            if (Aosh.checkParamCount("set_httpd_site_enable_htaccess", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSiteEnableHtaccess(args[1], args[2], Aosh.parseBoolean(args[3], "enable_htaccess"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_site_enable_indexes")) {
            if (Aosh.checkParamCount("set_httpd_site_enable_indexes", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSiteEnableIndexes(args[1], args[2], Aosh.parseBoolean(args[3], "enable_indexes"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_site_enable_follow_symlinks")) {
            if (Aosh.checkParamCount("set_httpd_site_enable_follow_symlinks", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSiteEnableFollowSymlinks(args[1], args[2], Aosh.parseBoolean(args[3], "enable_follow_symlinks"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_site_enable_anonymous_ftp")) {
            if (Aosh.checkParamCount("set_httpd_site_enable_anonymous_ftp", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSiteEnableAnonymousFtp(args[1], args[2], Aosh.parseBoolean(args[3], "enable_anonymous_ftp"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_site_block_trace_track")) {
            if (Aosh.checkParamCount("set_httpd_site_block_trace_track", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSiteBlockTraceTrack(args[1], args[2], Aosh.parseBoolean(args[3], "block_trace_track"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_site_block_scm")) {
            if (Aosh.checkParamCount("set_httpd_site_block_scm", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSiteBlockScm(args[1], args[2], Aosh.parseBoolean(args[3], "block_scm"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_site_block_core_dumps")) {
            if (Aosh.checkParamCount("set_httpd_site_block_core_dumps", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSiteBlockCoreDumps(args[1], args[2], Aosh.parseBoolean(args[3], "block_core_dumps"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_site_block_editor_backups")) {
            if (Aosh.checkParamCount("set_httpd_site_block_editor_backups", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSiteBlockEditorBackups(args[1], args[2], Aosh.parseBoolean(args[3], "block_editor_backups"));
            }
            return true;
        }
        return false;
    }

    public boolean isSiteNameAvailable(String sitename) throws IOException, SQLException {
        return this.connector.requestBooleanQuery(true, AoservProtocol.CommandId.IS_SITE_NAME_AVAILABLE, sitename);
    }

    public void waitForRebuild(Server aoServer) throws IOException, SQLException {
        this.connector.requestUpdate(true, AoservProtocol.CommandId.WAIT_FOR_REBUILD, new Object[]{Table.TableId.HTTPD_SITES, aoServer.getPkey()});
    }
}

