/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.DomainName;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.Disablable;
import com.aoindustries.aoserv.client.account.DisableLog;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.pki.Certificate;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.util.SystemdUtil;
import com.aoindustries.aoserv.client.web.Header;
import com.aoindustries.aoserv.client.web.HttpdBind;
import com.aoindustries.aoserv.client.web.RewriteRule;
import com.aoindustries.aoserv.client.web.Site;
import com.aoindustries.aoserv.client.web.VirtualHostName;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;

public final class VirtualHost
extends CachedObjectIntegerKey<VirtualHost>
implements Disablable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_HTTPD_SITE = 1;
    static final int COLUMN_SSL_CERTIFICATE = 6;
    static final String COLUMN_HTTPD_SITE_name = "httpd_site";
    static final String COLUMN_HTTPD_BIND_name = "httpd_bind";
    static final String COLUMN_NAME_name = "name";
    private int httpdSite;
    private int httpdBind;
    private String name;
    private PosixPath accessLog;
    private PosixPath errorLog;
    private int certificate;
    private int disableLog;
    private String predisableConfig;
    private boolean isManual;
    private boolean redirectToPrimaryHostname;
    private String includeSiteConfig;
    private PosixPath oldSslCertFile;
    private PosixPath oldSslCertKeyFile;
    private PosixPath oldSslCertChainFile;

    @Deprecated
    public VirtualHost() {
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        Site site = this.getHttpdSite();
        HttpdBind bind = this.getHttpdBind();
        if (this.name == null) {
            return site.toStringImpl() + '|' + bind.toStringImpl();
        }
        return site.toStringImpl() + '|' + bind.toStringImpl() + '(' + this.name + ')';
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.httpdSite;
            }
            case 2: {
                return this.httpdBind;
            }
            case 3: {
                return this.name;
            }
            case 4: {
                return this.accessLog;
            }
            case 5: {
                return this.errorLog;
            }
            case 6: {
                return this.certificate == -1 ? null : Integer.valueOf(this.certificate);
            }
            case 7: {
                return this.disableLog == -1 ? null : Integer.valueOf(this.disableLog);
            }
            case 8: {
                return this.predisableConfig;
            }
            case 9: {
                return this.isManual;
            }
            case 10: {
                return this.redirectToPrimaryHostname;
            }
            case 11: {
                return this.includeSiteConfig;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_SITE_BINDS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            int pos = 1;
            this.pkey = result.getInt(pos++);
            this.httpdSite = result.getInt(pos++);
            this.httpdBind = result.getInt(pos++);
            this.name = result.getString(pos++);
            this.accessLog = PosixPath.valueOf(result.getString(pos++));
            this.errorLog = PosixPath.valueOf(result.getString(pos++));
            this.certificate = result.getInt(pos++);
            if (result.wasNull()) {
                this.certificate = -1;
            }
            this.disableLog = result.getInt(pos++);
            if (result.wasNull()) {
                this.disableLog = -1;
            }
            this.predisableConfig = result.getString(pos++);
            this.isManual = result.getBoolean(pos++);
            this.redirectToPrimaryHostname = result.getBoolean(pos++);
            this.includeSiteConfig = result.getString(pos++);
            this.oldSslCertFile = PosixPath.valueOf(result.getString(pos++));
            this.oldSslCertKeyFile = PosixPath.valueOf(result.getString(pos++));
            this.oldSslCertChainFile = PosixPath.valueOf(result.getString(pos++));
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.httpdSite = in.readCompressedInt();
            this.httpdBind = in.readCompressedInt();
            this.name = in.readNullUTF();
            this.accessLog = PosixPath.valueOf(in.readUTF());
            this.errorLog = PosixPath.valueOf(in.readUTF());
            this.certificate = in.readCompressedInt();
            this.disableLog = in.readCompressedInt();
            this.predisableConfig = in.readNullUTF();
            this.isManual = in.readBoolean();
            this.redirectToPrimaryHostname = in.readBoolean();
            this.includeSiteConfig = in.readNullUTF();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.httpdSite);
        out.writeCompressedInt(this.httpdBind);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_14) >= 0) {
            out.writeNullUTF(this.name);
        }
        out.writeUTF(this.accessLog.toString());
        out.writeUTF(this.errorLog.toString());
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_10) >= 0) {
            out.writeCompressedInt(this.certificate);
        } else {
            out.writeNullUTF(Objects.toString(this.oldSslCertFile, null));
            out.writeNullUTF(Objects.toString(this.oldSslCertKeyFile, null));
            if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_4) >= 0) {
                out.writeNullUTF(Objects.toString(this.oldSslCertChainFile, null));
            }
        }
        out.writeCompressedInt(this.disableLog);
        out.writeNullUTF(this.predisableConfig);
        out.writeBoolean(this.isManual);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_19) >= 0) {
            out.writeBoolean(this.redirectToPrimaryHostname);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_10) >= 0) {
            out.writeNullUTF(this.includeSiteConfig);
        }
    }

    public Site getHttpdSite() throws SQLException, IOException {
        Site obj = this.table.getConnector().getWeb().getSite().get(this.httpdSite);
        if (obj == null) {
            throw new SQLException("Unable to find HttpdSite: " + this.httpdSite);
        }
        return obj;
    }

    public HttpdBind getHttpdBind() throws SQLException, IOException {
        HttpdBind obj = this.table.getConnector().getWeb().getHttpdBind().get(this.httpdBind);
        if (obj == null) {
            throw new SQLException("Unable to find HttpdBind: " + this.httpdBind + " for HttpdSite=" + this.httpdSite);
        }
        return obj;
    }

    public String getName() {
        return this.name;
    }

    public String getSystemdEscapedName() {
        return SystemdUtil.encode(this.name);
    }

    public PosixPath getAccessLog() {
        return this.accessLog;
    }

    public PosixPath getErrorLog() {
        return this.errorLog;
    }

    public Certificate getCertificate() throws SQLException, IOException {
        String protocol = this.getHttpdBind().getNetBind().getAppProtocol().getProtocol();
        if ("HTTP".equals(protocol)) {
            if (this.certificate != -1) {
                throw new SQLException("certificate non-null on HTTP protocol for HttpdSiteBind #" + this.pkey);
            }
        } else if ("HTTPS".equals(protocol)) {
            if (this.certificate == -1) {
                throw new SQLException("certificate null on HTTPS protocol for HttpdSiteBind #" + this.pkey);
            }
        } else {
            throw new SQLException("Protocol is neither HTTP nor HTTPS for HttpdSiteBind #" + this.pkey + ": " + protocol);
        }
        if (this.certificate == -1) {
            return null;
        }
        return this.table.getConnector().getPki().getCertificate().get(this.certificate);
    }

    @Override
    public DisableLog getDisableLog() throws SQLException, IOException {
        if (this.disableLog == -1) {
            return null;
        }
        DisableLog obj = this.table.getConnector().getAccount().getDisableLog().get(this.disableLog);
        if (obj == null) {
            throw new SQLException("Unable to find DisableLog: " + this.disableLog);
        }
        return obj;
    }

    @Override
    public boolean isDisabled() {
        return this.disableLog != -1;
    }

    @Override
    public boolean canDisable() {
        return this.disableLog == -1;
    }

    @Override
    public boolean canEnable() throws SQLException, IOException {
        DisableLog dl = this.getDisableLog();
        if (dl == null) {
            return false;
        }
        return dl.canEnable() && !this.getHttpdSite().isDisabled();
    }

    @Override
    public void disable(DisableLog dl) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.DISABLE, new Object[]{Table.TableId.HTTPD_SITE_BINDS, dl.getPkey(), this.pkey});
    }

    @Override
    public void enable() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.ENABLE, new Object[]{Table.TableId.HTTPD_SITE_BINDS, this.pkey});
    }

    public String getPredisableConfig() {
        return this.predisableConfig;
    }

    public void setPredisableConfig(final String config) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.SET_HTTPD_SITE_BIND_PREDISABLE_CONFIG, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(VirtualHost.this.pkey);
                out.writeNullUTF(config);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                VirtualHost.this.table.getConnector().tablesUpdated(this.invalidateList);
            }
        });
    }

    public boolean isManual() {
        return this.isManual;
    }

    public void setIsManual(boolean isManual) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_SITE_BIND_IS_MANUAL, this.pkey, isManual);
    }

    public boolean getRedirectToPrimaryHostname() {
        return this.redirectToPrimaryHostname;
    }

    public void setRedirectToPrimaryHostname(boolean redirectToPrimaryHostname) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_SITE_BIND_REDIRECT_TO_PRIMARY_HOSTNAME, this.pkey, redirectToPrimaryHostname);
    }

    public String getIncludeSiteConfig() {
        return this.includeSiteConfig;
    }

    public List<VirtualHostName> getVirtualHostNames() throws IOException, SQLException {
        return this.table.getConnector().getWeb().getVirtualHostName().getVirtualHostNames(this);
    }

    public VirtualHostName getPrimaryVirtualHostName() throws SQLException, IOException {
        return this.table.getConnector().getWeb().getVirtualHostName().getPrimaryVirtualHostName(this);
    }

    public List<VirtualHostName> getAltVirtualHostNames() throws IOException, SQLException {
        return this.table.getConnector().getWeb().getVirtualHostName().getAltVirtualHostNames(this);
    }

    public int addVirtualHostName(DomainName hostname) throws IOException, SQLException {
        return this.table.getConnector().getWeb().getVirtualHostName().addVirtualHostName(this, hostname);
    }

    public List<Header> getHttpdSiteBindHeaders() throws IOException, SQLException {
        return this.table.getConnector().getWeb().getHeader().getHttpdSiteBindHeaders(this);
    }

    public List<RewriteRule> getRewriteRules() throws IOException, SQLException {
        return this.table.getConnector().getWeb().getRewriteRule().getRewriteRules(this);
    }
}

