/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoapps.net.DomainName;
import com.aoapps.net.Port;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.net.AppProtocol;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.Site;
import com.aoindustries.aoserv.client.web.VirtualHost;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class VirtualHostName
extends CachedObjectIntegerKey<VirtualHostName>
implements Removable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_HTTPD_SITE_BIND = 1;
    static final String COLUMN_HOSTNAME_name = "hostname";
    static final String COLUMN_HTTPD_SITE_BIND_name = "httpd_site_bind";
    private int httpdSiteBind;
    private DomainName hostname;
    private boolean isPrimary;

    @Deprecated
    public VirtualHostName() {
    }

    public List<CannotRemoveReason<VirtualHostName>> getCannotRemoveReasons() throws SQLException, IOException {
        ArrayList<CannotRemoveReason<VirtualHostName>> reasons = new ArrayList<CannotRemoveReason<VirtualHostName>>();
        if (this.isPrimary) {
            reasons.add(new CannotRemoveReason<VirtualHostName>("Not allowed to remove the primary URL", this));
        }
        if (this.isTestUrl()) {
            reasons.add(new CannotRemoveReason<VirtualHostName>("Not allowed to remove the test URL", this));
        }
        return reasons;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.httpdSiteBind;
            }
            case 2: {
                return this.hostname;
            }
            case 3: {
                return this.isPrimary;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public DomainName getHostname() {
        return this.hostname;
    }

    public VirtualHost getHttpdSiteBind() throws SQLException, IOException {
        VirtualHost obj = this.table.getConnector().getWeb().getVirtualHost().get(this.httpdSiteBind);
        if (obj == null) {
            throw new SQLException("Unable to find HttpdSiteBind: " + this.httpdSiteBind);
        }
        return obj;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_SITE_URLS;
    }

    public String getUrl() throws SQLException, IOException {
        VirtualHost siteBind = this.getHttpdSiteBind();
        Bind netBind = siteBind.getHttpdBind().getNetBind();
        Port port = netBind.getPort();
        StringBuilder url = new StringBuilder();
        AppProtocol appProtocol = siteBind.getHttpdBind().getNetBind().getAppProtocol();
        String protocol = appProtocol.getProtocol();
        if ("HTTP".equals(protocol)) {
            url.append("http://");
        } else if ("HTTPS".equals(protocol)) {
            url.append("https://");
        } else {
            throw new SQLException("Unsupported protocol: " + protocol);
        }
        url.append(this.hostname);
        if (!port.equals((Object)appProtocol.getPort())) {
            url.append(':').append(port.getPort());
        }
        url.append('/');
        return url.toString();
    }

    public String getUrlNoSlash() throws SQLException, IOException {
        VirtualHost siteBind = this.getHttpdSiteBind();
        Bind netBind = siteBind.getHttpdBind().getNetBind();
        Port port = netBind.getPort();
        StringBuilder url = new StringBuilder();
        AppProtocol appProtocol = siteBind.getHttpdBind().getNetBind().getAppProtocol();
        String protocol = appProtocol.getProtocol();
        if ("HTTP".equals(protocol)) {
            url.append("http://");
        } else if ("HTTPS".equals(protocol)) {
            url.append("https://");
        } else {
            throw new SQLException("Unsupported protocol: " + protocol);
        }
        url.append(this.hostname);
        if (!port.equals((Object)appProtocol.getPort())) {
            url.append(':').append(port.getPort());
        }
        return url.toString();
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.httpdSiteBind = result.getInt(2);
            this.hostname = DomainName.valueOf((String)result.getString(3));
            this.isPrimary = result.getBoolean(4);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public boolean isTestUrl() throws SQLException, IOException {
        Site hs = this.getHttpdSiteBind().getHttpdSite();
        return this.hostname.toString().equalsIgnoreCase(hs.getName() + "." + hs.getLinuxServer().getHostname());
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.httpdSiteBind = in.readCompressedInt();
            this.hostname = DomainName.valueOf((String)in.readUTF());
            this.isPrimary = in.readBoolean();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.HTTPD_SITE_URLS, this.pkey});
    }

    public void setAsPrimary() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_PRIMARY_HTTPD_SITE_URL, this.pkey);
    }

    @Override
    public String toStringImpl() {
        return this.hostname.toString();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.httpdSiteBind);
        out.writeUTF(this.hostname.toString());
        out.writeBoolean(this.isPrimary);
    }
}

