/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.net.DomainName;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.VirtualHost;
import com.aoindustries.aoserv.client.web.VirtualHostName;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class VirtualHostNameTable
extends CachedTableIntegerKey<VirtualHostName> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("hostname", true), new AoservTable.OrderBy("httpd_site_bind.httpd_site.name", true), new AoservTable.OrderBy("httpd_site_bind.httpd_site.ao_server.hostname", true), new AoservTable.OrderBy("httpd_site_bind.httpd_bind.net_bind.ipAddress.inetAddress", true), new AoservTable.OrderBy("httpd_site_bind.httpd_bind.net_bind.ipAddress.device.deviceId", true), new AoservTable.OrderBy("httpd_site_bind.httpd_bind.net_bind.port", true), new AoservTable.OrderBy("httpd_site_bind.name", true)};

    VirtualHostNameTable(AoservConnector connector) {
        super(connector, VirtualHostName.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addVirtualHostName(VirtualHost hsb, DomainName hostname) throws IOException, SQLException {
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.HTTPD_SITE_URLS, hsb.getPkey(), hostname});
    }

    @Override
    public VirtualHostName get(int pkey) throws IOException, SQLException {
        return (VirtualHostName)this.getUniqueRow(0, pkey);
    }

    List<VirtualHostName> getVirtualHostNames(VirtualHost bind) throws IOException, SQLException {
        return this.getIndexedRows(1, bind.getPkey());
    }

    VirtualHostName getPrimaryVirtualHostName(VirtualHost bind) throws SQLException, IOException {
        List<VirtualHostName> cached = this.getVirtualHostNames(bind);
        int size = cached.size();
        for (int c = 0; c < size; ++c) {
            VirtualHostName hsu = cached.get(c);
            if (!hsu.isPrimary()) continue;
            return hsu;
        }
        throw new SQLException("Unable to find primary HttpdSiteURL for HttpdSiteBind with pkey=" + bind.getPkey());
    }

    List<VirtualHostName> getAltVirtualHostNames(VirtualHost bind) throws IOException, SQLException {
        List<VirtualHostName> cached = this.getVirtualHostNames(bind);
        int size = cached.size();
        ArrayList<VirtualHostName> matches = new ArrayList<VirtualHostName>(size - 1);
        for (int c = 0; c < size; ++c) {
            VirtualHostName hsu = cached.get(c);
            if (hsu.isPrimary()) continue;
            matches.add(hsu);
        }
        return matches;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_SITE_URLS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_httpd_site_url")) {
            if (Aosh.checkParamCount("add_httpd_site_url", args, 2, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addVirtualHostName(Aosh.parseInt(args[1], "httpd_site_bind_pkey"), Aosh.parseDomainName(args[2], "hostname")));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_httpd_site_url")) {
            if (Aosh.checkParamCount("remove_httpd_site_url", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeVirtualHostName(Aosh.parseInt(args[1], "pkey"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_primary_httpd_site_url")) {
            if (Aosh.checkParamCount("set_primary_httpd_site_url", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().setPrimaryVirtualHostName(Aosh.parseInt(args[1], "pkey"));
            }
            return true;
        }
        return false;
    }
}

