/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.pki.Certificate;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.HttpdServer;
import com.aoindustries.aoserv.client.web.Site;
import com.aoindustries.aoserv.client.web.VirtualHost;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class VirtualHostTable
extends CachedTableIntegerKey<VirtualHost> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("httpd_site.name", true), new AoservTable.OrderBy("httpd_site.ao_server.hostname", true), new AoservTable.OrderBy("httpd_bind.net_bind.ipAddress.inetAddress", true), new AoservTable.OrderBy("httpd_bind.net_bind.ipAddress.device.deviceId", true), new AoservTable.OrderBy("httpd_bind.net_bind.port", true), new AoservTable.OrderBy("name", true)};

    VirtualHostTable(AoservConnector connector) {
        super(connector, VirtualHost.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public VirtualHost get(int pkey) throws IOException, SQLException {
        return (VirtualHost)this.getUniqueRow(0, pkey);
    }

    List<VirtualHost> getHttpdSiteBinds(Site site) throws IOException, SQLException {
        return this.getIndexedRows(1, site.getPkey());
    }

    List<VirtualHost> getHttpdSiteBinds(Site site, HttpdServer server) throws SQLException, IOException {
        int serverPkey = server.getPkey();
        List<VirtualHost> cached = this.getHttpdSiteBinds(site);
        int size = cached.size();
        ArrayList<VirtualHost> matches = new ArrayList<VirtualHost>(size);
        for (int c = 0; c < size; ++c) {
            VirtualHost siteBind = cached.get(c);
            if (siteBind.getHttpdBind().getHttpdServer_pkey() != serverPkey) continue;
            matches.add(siteBind);
        }
        return matches;
    }

    public List<VirtualHost> getHttpdSiteBinds(Certificate sslCert) throws IOException, SQLException {
        return this.getIndexedRows(6, sslCert.getPkey());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_SITE_BINDS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, SQLException, IOException {
        String command = args[0];
        if (command.equalsIgnoreCase("disable_httpd_site_bind")) {
            if (Aosh.checkParamCount("disable_httpd_site_bind", args, 2, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().disableHttpdSiteBind(Aosh.parseInt(args[1], "pkey"), args[2]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("enable_httpd_site_bind")) {
            if (Aosh.checkParamCount("enable_httpd_site_bind", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().enableHttpdSiteBind(Aosh.parseInt(args[1], "pkey"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_site_bind_is_manual")) {
            if (Aosh.checkParamCount("set_httpd_site_bind_is_manual", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSiteBindIsManual(Aosh.parseInt(args[1], "pkey"), Aosh.parseBoolean(args[2], "is_manual"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_site_bind_redirect_to_primary_hostname")) {
            if (Aosh.checkParamCount("set_httpd_site_bind_redirect_to_primary_hostname", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSiteBindRedirectToPrimaryHostname(Aosh.parseInt(args[1], "pkey"), Aosh.parseBoolean(args[2], "redirect_to_primary_hostname"));
            }
            return true;
        }
        return false;
    }
}

