/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web.jboss;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.net.DomainName;
import com.aoapps.net.Email;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.linux.Group;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.User;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.net.IpAddress;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.jboss.Site;
import com.aoindustries.aoserv.client.web.jboss.Version;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;

public final class SiteTable
extends CachedTableIntegerKey<Site> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("tomcat_site.httpd_site.name", true), new AoservTable.OrderBy("tomcat_site.httpd_site.ao_server.hostname", true)};

    SiteTable(AoservConnector connector) {
        super(connector, Site.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public int addHttpdJbossSite(final Server aoServer, final String siteName, final Package packageObj, final User siteUser, final Group siteGroup, final Email serverAdmin, final boolean useApache, final IpAddress ipAddress, final DomainName primaryHttpHostname, final DomainName[] altHttpHostnames, final Version jbossVersion) throws IOException, SQLException {
        return this.connector.requestResult(true, AoservProtocol.CommandId.ADD, new AoservConnector.ResultRequest<Integer>(){
            private int pkey;
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Table.TableId.HTTPD_JBOSS_SITES.ordinal());
                out.writeCompressedInt(aoServer.getPkey());
                out.writeUTF(siteName);
                out.writeUTF(packageObj.getName().toString());
                out.writeUTF(siteUser.getUsername_id().toString());
                out.writeUTF(siteGroup.getName().toString());
                out.writeUTF(serverAdmin.toString());
                out.writeBoolean(useApache);
                out.writeCompressedInt(ipAddress == null ? -1 : ipAddress.getPkey());
                out.writeUTF(primaryHttpHostname.toString());
                out.writeCompressedInt(altHttpHostnames.length);
                for (DomainName altHttpHostname : altHttpHostnames) {
                    out.writeUTF(altHttpHostname.toString());
                }
                out.writeCompressedInt(jbossVersion.getPkey());
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unknown response code: " + code);
                }
                this.pkey = in.readCompressedInt();
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public Integer afterRelease() {
                SiteTable.this.connector.tablesUpdated(this.invalidateList);
                return this.pkey;
            }
        });
    }

    @Override
    public Site get(int pkey) throws SQLException, IOException {
        return (Site)this.getUniqueRow(0, pkey);
    }

    public Site getHttpdJbossSiteByRmiPort(Bind bind) throws IOException, SQLException {
        return (Site)this.getUniqueRow(4, bind.getId());
    }

    public Site getHttpdJbossSiteByJnpPort(Bind bind) throws IOException, SQLException {
        return (Site)this.getUniqueRow(2, bind.getId());
    }

    public Site getHttpdJbossSiteByWebserverPort(Bind bind) throws IOException, SQLException {
        return (Site)this.getUniqueRow(3, bind.getId());
    }

    public Site getHttpdJbossSiteByHypersonicPort(Bind bind) throws IOException, SQLException {
        return (Site)this.getUniqueRow(5, bind.getId());
    }

    public Site getHttpdJbossSiteByJmxPort(Bind bind) throws IOException, SQLException {
        return (Site)this.getUniqueRow(6, bind.getId());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_JBOSS_SITES;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, SQLException, IOException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_httpd_jboss_site")) {
            if (Aosh.checkMinParamCount("add_httpd_jboss_site", args, 11, (PrintWriter)err)) {
                DomainName[] altHostnames = new DomainName[args.length - 12];
                for (int i = 12; i < args.length; ++i) {
                    altHostnames[i - 12] = Aosh.parseDomainName(args[i], "alternate_http_hostname");
                }
                out.println(this.connector.getSimpleClient().addHttpdJbossSite(args[1], args[2], Aosh.parseAccountingCode(args[3], "package"), Aosh.parseLinuxUserName(args[4], "username"), Aosh.parseGroupName(args[5], "group"), Aosh.parseEmail(args[6], "server_admin_email"), Aosh.parseBoolean(args[7], "use_apache"), args[8].length() == 0 ? null : Aosh.parseInetAddress(args[8], "ip_address"), args[9], Aosh.parseDomainName(args[11], "primary_http_hostname"), altHostnames, args[10]));
                out.flush();
            }
            return true;
        }
        return false;
    }
}

